/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedQueueSessionImpl;
import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import java.util.Vector;

public class JMSXAWrappedQueueConnectionImpl
implements JMSXAQueueConnection {
    private static final boolean debug = JMSXAWrappedConnectionFactoryImpl.debug;
    private Connection wrapped_connection;
    private JMSXAWrappedConnectionFactoryImpl wcf_ = null;
    private String username_ = null;
    private String password_ = null;
    private Vector sessions_ = new Vector();
    private boolean markClosed_ = false;
    private boolean closed_ = false;

    public JMSXAWrappedQueueConnectionImpl(QueueConnection qconn, JMSXAWrappedConnectionFactoryImpl wcf, String username, String password) throws JMSException {
        this.wrapped_connection = qconn;
        this.wcf_ = wcf;
        this.username_ = username;
        this.password_ = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSXAQueueSession createXAQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Vector vector = this.sessions_;
        synchronized (vector) {
            if (this.closed_) {
                throw new IllegalStateException("JMSXWrapped Connection has been closed");
            }
            if (this.markClosed_) {
                throw new IllegalStateException("JMSXAWrapped Connection is closed");
            }
            JMSXAWrappedQueueSessionImpl s = new JMSXAWrappedQueueSessionImpl((QueueConnection)this.wrapped_connection, transacted, acknowledgeMode, this);
            if (s.delaySessionClose()) {
                this.sessions_.add(s);
            }
            return s;
        }
    }

    @Override
    public QueueConnection getQueueConnection() {
        return (QueueConnection)this.wrapped_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        JMSXAWrappedQueueConnectionImpl.dlog("closing " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
        Vector vector = this.sessions_;
        synchronized (vector) {
            if (this.sessions_.isEmpty()) {
                this.closed_ = true;
            } else {
                this.markClosed_ = true;
            }
        }
        if (this.closed_) {
            this.hardClose();
        }
    }

    private void hardClose() throws JMSException {
        JMSXAWrappedQueueConnectionImpl.dlog("hard closing " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
        this.wrapped_connection.close();
        this.closed_ = true;
        JMSXAWrappedQueueConnectionImpl.dlog("hard closed " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(JMSXAWrappedQueueSessionImpl s) {
        Vector vector = this.sessions_;
        synchronized (vector) {
            this.sessions_.remove(s);
            if (this.sessions_.isEmpty() && this.markClosed_) {
                JMSXAWrappedQueueConnectionImpl.dlog("All sessions closed, hard close connection " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
                this.closed_ = true;
            }
        }
        if (this.closed_) {
            try {
                this.hardClose();
            }
            catch (JMSException e) {
                JMSXAWrappedQueueConnectionImpl.log("Warning:", e);
            }
        }
    }

    protected JMSXAConnectionFactory getJMSXAWrappedConnectionFactory() {
        return this.wcf_;
    }

    protected String getUsername() {
        return this.username_;
    }

    protected String getPassword() {
        return this.password_;
    }

    private static void dlog(String msg) {
        if (debug) {
            JMSXAWrappedQueueConnectionImpl.log("Info:", msg);
        }
    }

    private static void log(String level, Exception e) {
        JMSXAWrappedQueueConnectionImpl.log(level, e.getMessage());
        e.printStackTrace();
    }

    private static void log(String level, String msg) {
        System.out.println(level + " JMSXAWrappedQueueConnectionImpl: " + msg);
    }
}

