/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.crossparameter;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintViolation;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.CrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.ExplicitGenericConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.GenericAndCrossParameterConstraintWithOneValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.GenericConstraint;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class GenericAndCrossParameterConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)GenericAndCrossParameterConstraintTest.webArchiveBuilder().withTestClassPackage(GenericAndCrossParameterConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="b"), @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="e")})
    public void testAnnotatedElementIsTargetedByDefault() throws Exception {
        Calendar object = new Calendar();
        Method method = Calendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, GenericConstraint.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="e")
    public void testAnnotatedElementIsTargetedUsingSupportedValidationTarget() throws Exception {
        WebCalendar object = new WebCalendar();
        Method method = WebCalendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, ExplicitGenericConstraint.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)returnValue);
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="e")
    public void testParametersAreTargetedUsingSupportedValidationTarget() throws Exception {
        OnlineCalendar object = new OnlineCalendar();
        Method method = OnlineCalendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, CrossParameterConstraint.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)parameterValues);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-parameterconstraints-crossparameterconstraints", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-returnvalueconstraints", id="b")})
    public void testOneValidatorSupportsBothValidationTargets() throws Exception {
        MobileCalendar object = new MobileCalendar();
        Method method = MobileCalendar.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        Object returnValue = new Object();
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, GenericAndCrossParameterConstraintWithOneValidator.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)returnValue);
        method = MobileCalendar.class.getMethod("addEvent", Date.class, Date.class);
        violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, GenericAndCrossParameterConstraintWithOneValidator.class);
        Assert.assertEquals((Object)((ConstraintViolation)violations.iterator().next()).getInvalidValue(), (Object)parameterValues);
    }

    private static class MobileCalendar {
        private MobileCalendar() {
        }

        @GenericAndCrossParameterConstraintWithOneValidator(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
        public Object createEvent(Date start, Date end) {
            return null;
        }

        @GenericAndCrossParameterConstraintWithOneValidator(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Object addEvent(Date start, Date end) {
            return null;
        }
    }

    private static class OnlineCalendar {
        private OnlineCalendar() {
        }

        @CrossParameterConstraint
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }

    private static class WebCalendar {
        private WebCalendar() {
        }

        @ExplicitGenericConstraint
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }

    private static class Calendar {
        private Calendar() {
        }

        @GenericConstraint
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }
}

