/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles;

import java.io.File;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GaugeCompositeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.BorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.DefaultBorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SimpleStyleConfiguration
implements StyleConfiguration {
    @Override
    public void adaptNodeLabel(DNode node, SiriusWrapLabel nodeLabel) {
        if (nodeLabel.getParent() != null) {
            Rectangle constraint = new Rectangle(nodeLabel.getParent().getBounds());
            if (nodeLabel.getParent() instanceof GaugeCompositeFigure) {
                constraint.x = 0;
                constraint.y = 0;
            }
            Insets borderDimension = this.getBorderDimension(node);
            constraint.height -= borderDimension.top + borderDimension.bottom;
            constraint.width -= borderDimension.left + borderDimension.right;
            constraint.x += borderDimension.left;
            constraint.y += borderDimension.top;
            nodeLabel.setBounds(constraint);
        }
    }

    @Override
    public int adaptViewNodeSizeWithLabel(DNode viewNode, SiriusWrapLabel nodeLabel, int nodeWidth) {
        viewNode.getResizeKind();
        return nodeWidth;
    }

    @Override
    public AnchorProvider getAnchorProvider() {
        return null;
    }

    @Override
    public BorderItemLocatorProvider getBorderItemLocatorProvider() {
        return DefaultBorderItemLocatorProvider.getInstance();
    }

    @Override
    public IBorderItemLocator getNameBorderItemLocator(DNode node, IFigure mainFigure) {
        DBorderItemLocator locator = new DBorderItemLocator(mainFigure, 29);
        locator.setBorderItemOffset(IBorderItemOffsets.NO_OFFSET);
        return locator;
    }

    @Override
    public Image getLabelIcon(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        Image icon = null;
        if (vpElement != null && this.isShowIcon(vpElement, editPart)) {
            IItemLabelProvider labelProvider;
            ImageDescriptor descriptor = null;
            EObject target = vpElement.getTarget();
            if (this.useCustomIcon(vpElement, editPart)) {
                descriptor = this.getCustomIconDescriptor(vpElement, editPart);
            } else if (target != null && (labelProvider = (IItemLabelProvider)DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory().adapt((Notifier)target, IItemLabelProvider.class)) != null) {
                descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)target));
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            icon = DiagramUIPlugin.getPlugin().getImage(descriptor);
        }
        return icon;
    }

    private ImageDescriptor getCustomIconDescriptor(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        ImageDescriptor imgDesc = null;
        BasicLabelStyle bls = this.getBasicLabelStyle(vpElement, editPart);
        if (bls != null && !StringUtil.isEmpty((String)bls.getIconPath())) {
            String iconPath = bls.getIconPath();
            File imageFile = FileProvider.getDefault().getFile((IPath)new Path(iconPath));
            if (imageFile != null && imageFile.exists() && imageFile.canRead()) {
                try {
                    imgDesc = DiagramUIPlugin.Implementation.findImageDescriptor(imageFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.logIconNotFoundWarning(iconPath, e);
                }
            } else {
                this.logIconNotFoundWarning(iconPath, null);
            }
        }
        return imgDesc;
    }

    private void logIconNotFoundWarning(String iconPath, MalformedURLException e) {
        SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.SimpleStyleConfiguration_iconFileNotFound, iconPath), (Exception)e);
    }

    protected boolean isShowIcon(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        BasicLabelStyle bls = this.getBasicLabelStyle(vpElement, editPart);
        return bls != null && bls.isShowIcon();
    }

    private boolean useCustomIcon(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        BasicLabelStyle bls = this.getBasicLabelStyle(vpElement, editPart);
        return bls != null && !StringUtil.isEmpty((String)bls.getIconPath());
    }

    private BasicLabelStyle getBasicLabelStyle(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        LabelStyle bls = null;
        if (vpElement.getStyle() instanceof LabelStyle) {
            bls = (LabelStyle)vpElement.getStyle();
        } else if (vpElement instanceof DEdge && vpElement.getStyle() instanceof EdgeStyle) {
            if (editPart instanceof DEdgeNameEditPart) {
                bls = ((EdgeStyle)vpElement.getStyle()).getCenterLabelStyle();
            } else if (editPart instanceof DEdgeBeginNameEditPart) {
                bls = ((EdgeStyle)vpElement.getStyle()).getBeginLabelStyle();
            } else if (editPart instanceof DEdgeEndNameEditPart) {
                bls = ((EdgeStyle)vpElement.getStyle()).getEndLabelStyle();
            }
        }
        return bls;
    }

    @Override
    public Dimension fitToText(DNode node, SiriusWrapLabel nodeLabel, DefaultSizeNodeFigure defaultSizeNodeFigure) {
        if (nodeLabel.getFont() != null) {
            String text = node.getName();
            float charHeight = (float)FigureUtilities.getStringExtents((String)"ABCDEF", (Font)nodeLabel.getFont()).height + 5.0f;
            float charWidth = (float)FigureUtilities.getTextWidth((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", (Font)nodeLabel.getFont()) / 52.0f;
            double ratio = charHeight / charWidth;
            int nbLines = text != null ? (int)(Math.sqrt(text.length()) / ratio) + 1 : 0;
            int nbCols = text != null ? (int)(Math.sqrt(text.length()) * ratio) + 1 : 0;
            int longestWord = text != null ? this.getTheLongestWord(text.split("\\s")) : 0;
            nbCols = Math.max(nbCols, longestWord);
            int hHeight = (int)((float)nbLines * charHeight);
            int hWidth = (int)((float)nbCols * charWidth);
            Dimension size = nodeLabel.getPreferredSize(hWidth + nodeLabel.getIconBounds().width + nodeLabel.getIconTextGap(), hHeight).getCopy();
            size.width += 20;
            size.height += 30;
            Insets borderDimension = this.getBorderDimension(node);
            size.width += borderDimension.left + borderDimension.right;
            size.height += borderDimension.top + borderDimension.bottom;
            return size;
        }
        return defaultSizeNodeFigure.getBounds().getSize().getCopy();
    }

    private int getTheLongestWord(String[] strings) {
        int max = -1;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.length() > max) {
                max = string.length();
            }
            ++n2;
        }
        return max;
    }

    public Insets getBorderDimension(DNode node) {
        Insets result = new Insets(0, 0, 0, 0);
        if (node.getStyle() instanceof BorderedStyle) {
            BorderedStyle borderedStyle = (BorderedStyle)node.getStyle();
            result.left = borderedStyle.getBorderSize();
            result.right = borderedStyle.getBorderSize();
            result.top = borderedStyle.getBorderSize();
            result.bottom = borderedStyle.getBorderSize();
        }
        return result;
    }
}

