/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.NoteFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ui.business.internal.query.StyleConfigurationQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartRefreshVisualsOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;

public final class DiagramNodeEditPartOperation {
    private DiagramNodeEditPartOperation() {
    }

    public static void refreshVisuals(IDiagramNodeEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DNode) {
            if (self.getPrimaryFigure() != null) {
                self.refreshFigure();
            }
            DiagramNodeEditPartOperation.internalRefreshVisuals(self);
            if (self.getPrimaryFigure() != null) {
                self.refreshFigure();
                self.getPrimaryFigure().repaint();
            }
        }
    }

    public static void refreshFont(IDiagramNodeEditPart self) {
        Object firstChild;
        if (!self.getChildren().isEmpty() && (firstChild = self.getChildren().get(0)) instanceof IDiagramNameEditPart) {
            DiagramNameEditPartOperation.refreshFont((IDiagramNameEditPart)firstChild);
        }
    }

    public static void internalRefreshVisuals(IDiagramNodeEditPart self) {
        AbstractDiagramNodeEditPartRefreshVisualsOperation op = new AbstractDiagramNodeEditPartRefreshVisualsOperation(self);
        if (op.canRefresh()) {
            op.refreshSize();
        }
    }

    public static void refreshFigure(IStyleEditPart styleEditPart) {
        IFigure figure = styleEditPart.getContentPane();
        if (figure instanceof StyledFigure) {
            IAbstractDiagramNodeEditPart self;
            DDiagramElement dDiagramElement;
            StyledFigure styledFigure = (StyledFigure)figure;
            EditPart parent = styleEditPart.getParent();
            if (parent instanceof IAbstractDiagramNodeEditPart && (dDiagramElement = (self = (IAbstractDiagramNodeEditPart)parent).resolveDiagramElement()) instanceof DNode) {
                DNode viewNode = (DNode)dDiagramElement;
                NodeStyle nodeStyle = (NodeStyle)viewNode.getStyle();
                LabelPosition labelPosition = nodeStyle.getLabelPosition();
                if (labelPosition != null && labelPosition == LabelPosition.NODE_LITERAL && !styledFigure.getChildren().contains((Object)self.getNodeLabel())) {
                    styledFigure.add((IFigure)self.getNodeLabel());
                }
                if (labelPosition != null && labelPosition == LabelPosition.BORDER_LITERAL && styledFigure.getChildren().contains((Object)self.getNodeLabel())) {
                    styledFigure.remove((IFigure)self.getNodeLabel());
                }
                if (styledFigure.getChildren().contains((Object)self.getNodeLabel())) {
                    DiagramElementEditPartOperation.refreshFont(self, (EObject)viewNode, (IFigure)self.getNodeLabel());
                    self.getNodeLabel().setText(viewNode.getName());
                    StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(viewNode.getDiagramElementMapping(), (Style)nodeStyle);
                    self.getNodeLabel().setIcon(new StyleConfigurationQuery(styleConfiguration).getLabelIcon(dDiagramElement, self));
                    styleConfiguration.adaptNodeLabel(viewNode, self.getNodeLabel());
                }
                DiagramNodeEditPartOperation.refreshBorderFigure((BorderedStyle)nodeStyle, styledFigure);
                self.setTooltipText(viewNode.getTooltipText());
                self.getNodeLabel().revalidate();
            }
        }
    }

    private static void refreshBorderFigure(BorderedStyle borderedStyle, StyledFigure styledFigure) {
        LineBorder lineBorder = null;
        if (styledFigure.getBorder() instanceof LineBorder) {
            lineBorder = (LineBorder)styledFigure.getBorder();
        } else {
            lineBorder = new LineBorder();
            if (styledFigure instanceof Shape) {
                styledFigure.setBorder(null);
            } else {
                styledFigure.setBorder((Border)lineBorder);
            }
        }
        int borderSize = 0;
        if (borderedStyle.getBorderSize() != null) {
            borderSize = borderedStyle.getBorderSize();
        }
        lineBorder.setWidth(borderSize);
        RGBValues borderColor = borderedStyle.getBorderColor();
        if (borderColor != null) {
            lineBorder.setColor(VisualBindingManager.getDefault().getColorFromRGBValues(borderColor));
        }
        DiagramNodeEditPartOperation.refreshBorderLineStyle(borderedStyle, styledFigure, lineBorder);
        if (borderSize == 0 && !(styledFigure instanceof NoteFigure)) {
            styledFigure.setBorder(null);
        }
    }

    private static void refreshBorderLineStyle(BorderedStyle borderedStyle, StyledFigure styledFigure, LineBorder lineBorder) {
        LineStyle borderLineStyle = borderedStyle.getBorderLineStyle();
        if (styledFigure instanceof Shape) {
            DiagramElementEditPartOperation.setLineStyle((Shape)styledFigure, borderLineStyle, false);
        } else if (styledFigure instanceof NodeFigure) {
            DiagramElementEditPartOperation.setLineStyle((NodeFigure)styledFigure, borderLineStyle);
        }
        DiagramElementEditPartOperation.setLineStyle(lineBorder, borderLineStyle);
    }

    public static void removeLabel(IAbstractDiagramNodeEditPart self, List<?> modelChildren) {
        EObject label = null;
        Iterator<?> iterChildren = modelChildren.iterator();
        while (iterChildren.hasNext() && label == null) {
            int visualId;
            Object current = iterChildren.next();
            if (!(current instanceof View) || (visualId = SiriusVisualIDRegistry.getVisualID(((View)current).getType())) != 5002 && visualId != 5001 && visualId != 5003 && visualId != 5010) continue;
            label = (EObject)current;
        }
        if (label != null) {
            modelChildren.remove(label);
        }
    }

    public static void updateResizeKind(ResizableEditPolicy ep, DNode node) {
        switch (node.getResizeKind().getValue()) {
            case 0: {
                ep.setResizeDirections(0);
                break;
            }
            case 2: {
                ep.setResizeDirections(5);
                break;
            }
            case 3: {
                ep.setResizeDirections(24);
                break;
            }
            case 1: {
                ep.setResizeDirections(29);
                break;
            }
        }
    }
}

