/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DirectEditCommandBuilder;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LabelDeletionEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LabelSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ToolBasedLabelDirectEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.refresh.LabelAndIconRefresher;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractDiagramNameEditPart
extends LabelEditPart
implements IDiagramNameEditPart {
    private LabelAndIconRefresher labelAndIconRefresher;

    public AbstractDiagramNameEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.labelAndIconRefresher = new LabelAndIconRefresher(this);
    }

    public boolean isResizable() {
        EditPolicy editPolicy = this.getEditPolicy("PrimaryDrag Policy");
        return editPolicy instanceof ResizableEditPolicy;
    }

    protected void registerModel() {
        super.registerModel();
        DiagramElementEditPartOperation.registerModel(this);
    }

    protected void unregisterModel() {
        super.unregisterModel();
        DiagramElementEditPartOperation.unregisterModel(this);
    }

    protected void refreshFont() {
        DiagramNameEditPartOperation.refreshFont(this);
    }

    protected void refreshFontColor() {
    }

    @Override
    public Image getLabelIcon() {
        return DiagramNameEditPartOperation.getLabelIcon(this);
    }

    @Override
    public IStyleEditPart getStyleEditPart() {
        if (this.getParent() instanceof IDiagramElementEditPart) {
            return DiagramElementEditPartOperation.getStyleEditPart((IDiagramElementEditPart)this.getParent());
        }
        return null;
    }

    @Override
    public NotificationListener getEAdapterDiagramElement() {
        return null;
    }

    @Override
    public NotificationListener getEditModeListener() {
        return null;
    }

    @Override
    public DDiagramElement resolveDiagramElement() {
        return DiagramElementEditPartOperation.resolveDiagramElement(this);
    }

    @Override
    public List<EObject> resolveAllSemanticElements() {
        return DiagramElementEditPartOperation.resolveAllSemanticElements(this);
    }

    @Override
    public EObject resolveTargetSemanticElement() {
        return DiagramElementEditPartOperation.resolveTargetSemanticElement(this);
    }

    @Override
    public Class<?> getMetamodelType() {
        Class<DNode> clazz = null;
        if (this.getParent() instanceof IDiagramNodeEditPart) {
            clazz = DNode.class;
        } else if (this.getParent() instanceof IDiagramEdgeEditPart) {
            clazz = DEdge.class;
        } else if (this.getParent() instanceof IDiagramContainerEditPart) {
            clazz = DNodeContainer.class;
        } else if (this.getParent() instanceof IDiagramListEditPart) {
            clazz = DNodeList.class;
        } else {
            throw new IllegalStateException();
        }
        return clazz;
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return null;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("DirectEditPolicy");
        if (this.isDirectEditEnabled()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ToolBasedLabelDirectEditPolicy(this.getEditingDomain()));
        }
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new LabelSemanticEditPolicy());
        this.removeEditPolicy("ComponentEditPolicy");
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new LabelDeletionEditPolicy());
    }

    protected boolean isDirectEditEnabled() {
        DMappingBased mappingBasedObject;
        boolean directEditEnabled = false;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DMappingBased && (mappingBasedObject = (DMappingBased)eObj).getMapping() != null && mappingBasedObject instanceof DDiagramElement && ((DDiagramElement)mappingBasedObject).getDiagramElementMapping().getLabelDirectEdit() != null) {
            DirectEditLabel labelDirectEdit = ((DDiagramElement)mappingBasedObject).getDiagramElementMapping().getLabelDirectEdit();
            DirectEditCommandBuilder builder = new DirectEditCommandBuilder((DRepresentationElement)((DDiagramElement)mappingBasedObject), labelDirectEdit, null);
            directEditEnabled = builder.canDirectEdit();
        }
        return directEditEnabled;
    }

    public void performRequest(Request request) {
        if ("direct edit".equals(request.getType())) {
            if (this.isDirectEditEnabled()) {
                this.addDirectEditPolicyIfNotInstalled();
                this.performDirectEditRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    private void addDirectEditPolicyIfNotInstalled() {
        if (this.getEditPolicy("DirectEditPolicy") == null) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ToolBasedLabelDirectEditPolicy(this.getEditingDomain()));
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.resolveDiagramElement() != null) {
            DDiagramElement view = this.resolveDiagramElement();
            this.setTooltipText(view.getTooltipText());
        }
    }

    @Override
    public void setTooltipText(String text) {
        if (!StringUtil.isEmpty((String)text)) {
            IFigure tt = this.getFigure().getToolTip();
            if (tt instanceof Label) {
                ((Label)tt).setText(text);
            } else {
                this.getFigure().setToolTip((IFigure)new Label(text));
            }
        } else {
            this.getFigure().setToolTip(null);
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public Object getAdapter(Class key) {
        try {
            return super.getAdapter(key);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.labelAndIconRefresher.dispose();
        this.labelAndIconRefresher = null;
        super.deactivate();
    }
}

