/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.binary;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.Relations;
import org.eclipse.emf.diffmerge.structures.binary.HashBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.IRangedBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;

public class HashInvertibleBinaryRelation<T, U>
extends HashBinaryRelation<T, U>
implements IRangedBinaryRelation.InvertibleEditable<T, U> {
    private final IRangedBinaryRelation.Editable<U, T> _inverser = this.newInverser();

    public HashInvertibleBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    public HashInvertibleBinaryRelation() {
        this(null);
    }

    @Override
    public boolean add(T source_p, U target_p) {
        boolean result = super.add(source_p, target_p);
        if (result) {
            this.getInverser().add(target_p, source_p);
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.getInverser().clear();
    }

    @Override
    public Collection<T> getInverse(U element_p) {
        return this.getInverser().get(element_p);
    }

    protected IRangedBinaryRelation.Editable<U, T> getInverser() {
        return this._inverser;
    }

    @Override
    public Collection<U> getTargets() {
        return this.getInverser().getSources();
    }

    @Override
    public IPropertyValue<Boolean> isInjective() {
        boolean result = Relations.rangedIsInjective(this);
        return PropertyValue.valueOf(result);
    }

    protected IRangedBinaryRelation.Editable<U, T> newInverser() {
        return new HashBinaryRelation(this.getEqualityTester());
    }

    @Override
    public boolean remove(T source_p, U target_p) {
        boolean result = super.remove(source_p, target_p);
        if (result) {
            this.getInverser().remove(target_p, source_p);
        }
        return result;
    }

    @Override
    public boolean removeSource(T source_p) {
        FArrayList targets = new FArrayList(this.get(source_p), this.getEqualityTester());
        boolean result = super.removeSource(source_p);
        if (result) {
            IRangedBinaryRelation.Editable inverser = this.getInverser();
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                Object target = iterator.next();
                inverser.remove(target, source_p);
            }
        }
        return result;
    }

    @Override
    public boolean removeTarget(U target_p) {
        FArrayList<T> sources = new FArrayList<T>(this.getInverse(target_p), this.getEqualityTester());
        boolean result = this.getInverser().removeSource(target_p);
        if (result) {
            Iterator iterator = sources.iterator();
            while (iterator.hasNext()) {
                Object source = iterator.next();
                this.remove(source, target_p);
            }
        }
        return result;
    }
}

