/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.setup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ComparisonSetup
implements IPropertyChangeNotifier {
    public static final String PROPERTY_ROLES = "ComparisonSetup.Property.Roles";
    public static final String PROPERTY_COMPARISON_METHOD = "ComparisonSetup.Property.ComparisonMethod";
    protected static IComparisonMethodFactory __lastComparisonMethodFactory = null;
    private final Map<Role, IModelScopeDefinition> _roleToScopeDefinition;
    private boolean _canSwapScopeDefinitions = true;
    private Role _twoWayReferenceRole = null;
    private boolean _canChangeTwoWayReferenceRole = true;
    private final List<IComparisonMethodFactory> _compatibleMethodFactories = new ArrayList<IComparisonMethodFactory>();
    private IComparisonMethodFactory _selectedFactory;
    protected IComparisonMethod _comparisonMethod = null;
    protected final Set<IPropertyChangeListener> _listeners;

    public ComparisonSetup(IComparisonMethod method_p) {
        this(method_p.getModelScopeDefinition(Role.TARGET), method_p.getModelScopeDefinition(Role.REFERENCE), method_p.getModelScopeDefinition(Role.ANCESTOR), EMFDiffMergeUIPlugin.getDefault().getSetupManager().getApplicableComparisonMethodFactories(method_p.getModelScopeDefinition(Role.TARGET), method_p.getModelScopeDefinition(Role.REFERENCE), method_p.getModelScopeDefinition(Role.ANCESTOR)));
        this._comparisonMethod = method_p;
        this._twoWayReferenceRole = method_p.getTwoWayReferenceRole();
        this._selectedFactory = method_p.getFactory();
    }

    public ComparisonSetup(IModelScopeDefinition scopeSpec1_p, IModelScopeDefinition scopeSpec2_p, IModelScopeDefinition scopeSpec3_p, List<IComparisonMethodFactory> compatibleFactories_p) {
        this();
        this._roleToScopeDefinition.put(Role.TARGET, scopeSpec1_p);
        this._roleToScopeDefinition.put(Role.REFERENCE, scopeSpec2_p);
        this._roleToScopeDefinition.put(Role.ANCESTOR, scopeSpec3_p);
        this._compatibleMethodFactories.addAll(compatibleFactories_p);
    }

    protected ComparisonSetup() {
        this._roleToScopeDefinition = new HashMap<Role, IModelScopeDefinition>();
        this._listeners = new HashSet<IPropertyChangeListener>();
    }

    public boolean canChangeTwoWayReferenceRole() {
        return this._canChangeTwoWayReferenceRole;
    }

    public boolean canSwapScopeDefinitions() {
        return this._canSwapScopeDefinitions;
    }

    public List<IComparisonMethodFactory> getApplicableComparisonMethodFactories() {
        return Collections.unmodifiableList(this._compatibleMethodFactories);
    }

    public IComparisonMethod getComparisonMethod() {
        return this._comparisonMethod;
    }

    public IModelScopeDefinition getScopeDefinition(Role role_p) {
        return this._roleToScopeDefinition.get(role_p);
    }

    public IComparisonMethodFactory getSelectedFactory() {
        return this._selectedFactory;
    }

    public Role getTwoWayReferenceRole() {
        return this._twoWayReferenceRole;
    }

    public boolean isThreeWay() {
        return this.getScopeDefinition(Role.ANCESTOR) != null;
    }

    protected void notify(PropertyChangeEvent event_p) {
        for (IPropertyChangeListener listener : this._listeners) {
            listener.propertyChange(event_p);
        }
    }

    public void performFinish(boolean remember_p) {
        if (this._comparisonMethod != null) {
            IComparisonMethodFactory selectedFactory = this.getSelectedFactory();
            if (remember_p && selectedFactory != null) {
                __lastComparisonMethodFactory = selectedFactory;
            }
            if (!this.isThreeWay()) {
                this._comparisonMethod.setTwoWayReferenceRole(this.getTwoWayReferenceRole());
            }
        }
    }

    public void setCanChangeTwoWayReferenceRole(boolean canChange_p) {
        this._canChangeTwoWayReferenceRole = canChange_p;
    }

    public void setCanSwapScopeDefinitions(boolean canSwap_p) {
        this._canSwapScopeDefinitions = canSwap_p;
    }

    public void setSelectedFactory(IComparisonMethodFactory selectedFactory_p) {
        this._selectedFactory = selectedFactory_p;
        this._comparisonMethod = this._selectedFactory != null ? this._selectedFactory.createComparisonMethod(this.getScopeDefinition(Role.TARGET), this.getScopeDefinition(Role.REFERENCE), this.getScopeDefinition(Role.ANCESTOR)) : null;
        this.notify(new PropertyChangeEvent((Object)this, PROPERTY_COMPARISON_METHOD, null, null));
    }

    public boolean setSelectedFactoryToLast() {
        boolean result = false;
        if (__lastComparisonMethodFactory != null && __lastComparisonMethodFactory != this.getSelectedFactory() && this.getApplicableComparisonMethodFactories().contains(__lastComparisonMethodFactory)) {
            this.setSelectedFactory(__lastComparisonMethodFactory);
            result = true;
        }
        return result;
    }

    public void setTargetRole(Role role_p) {
        this.setTwoWayReferenceRole(role_p);
        if (Role.TARGET == role_p || Role.REFERENCE == role_p) {
            IModelScopeDefinition roleDef = this.getScopeDefinition(role_p);
            IModelScopeDefinition oppositeRoleDef = this.getScopeDefinition(role_p.opposite());
            if (roleDef.isEditableSettable()) {
                roleDef.setEditable(true);
            }
            oppositeRoleDef.setEditable(false);
        } else {
            IModelScopeDefinition referenceRoleDef;
            IModelScopeDefinition targetRoleDef = this.getScopeDefinition(Role.TARGET);
            if (targetRoleDef.isEditableSettable()) {
                targetRoleDef.setEditable(true);
            }
            if ((referenceRoleDef = this.getScopeDefinition(Role.REFERENCE)).isEditableSettable()) {
                referenceRoleDef.setEditable(true);
            }
        }
        this.notify(new PropertyChangeEvent((Object)this, PROPERTY_ROLES, null, null));
    }

    public void setTwoWayReferenceRole(Role role_p) {
        if (!this.isThreeWay()) {
            this._twoWayReferenceRole = role_p;
        }
    }

    public boolean swapScopeDefinitions(Role role1_p, Role role2_p) {
        boolean result = true;
        if (this._comparisonMethod != null) {
            result = this._comparisonMethod.swapScopeDefinitions(role1_p, role2_p);
        }
        if (result) {
            IModelScopeDefinition scope1 = this.getScopeDefinition(role1_p);
            IModelScopeDefinition scope2 = this.getScopeDefinition(role2_p);
            if (scope1 != null && scope2 != null) {
                this._roleToScopeDefinition.put(role1_p, scope2);
                this._roleToScopeDefinition.put(role2_p, scope1);
            }
            this.notify(new PropertyChangeEvent((Object)this, PROPERTY_ROLES, null, null));
        }
        return result;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
        this._listeners.add(listener_p);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener_p) {
        this._listeners.remove(listener_p);
    }

    public void removePropertyChangeListeners() {
        this._listeners.clear();
    }
}

