/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.environment;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.diffmerge.patterns.ui.providers.EObjectLabelProviderHelper;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelEnvironmentUI
implements IModelEnvironmentUI {
    @Override
    public List<String> getEnvironments() {
        Version version;
        Bundle mainBundle;
        List<String> result = Collections.emptyList();
        String currentProductLabel = null;
        IProduct product = Platform.getProduct();
        if (product != null && (currentProductLabel = product.getName()) != null && (mainBundle = Platform.getProduct().getDefiningBundle()) != null && (version = mainBundle.getVersion()) != null) {
            currentProductLabel = String.valueOf(currentProductLabel) + ' ' + version.getMajor() + '.' + version.getMinor() + '.' + 'x';
        }
        if (currentProductLabel != null) {
            result = Collections.singletonList(currentProductLabel);
        }
        return result;
    }

    @Override
    public ViewerSorter getSorter(IModelEnvironmentUI.SortingMethod method_p) {
        NameTypeViewerSorter result = method_p == null || method_p == IModelEnvironmentUI.SortingMethod.NONE ? null : new NameTypeViewerSorter(method_p);
        return result;
    }

    @Override
    public String getText(Object element_p) {
        AdapterFactoryEditingDomain editingDomain;
        IItemLabelProvider provider;
        EditingDomain rawEditingDomain;
        if (!(element_p instanceof EObject)) {
            return element_p.toString();
        }
        EObject eobj = (EObject)element_p;
        String result = EObjectLabelProviderHelper.getText(eobj);
        if (!UIUtil.isSignificant(result) && (rawEditingDomain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(eobj)) instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt((Notifier)eobj, IItemLabelProvider.class)) != null) {
            result = provider.getText((Object)eobj);
        }
        return result;
    }

    @Override
    public Image getImage(Object element_p) {
        Object rawImage;
        AdapterFactoryEditingDomain editingDomain;
        IItemLabelProvider provider;
        EditingDomain rawEditingDomain;
        if (!(element_p instanceof EObject)) {
            return null;
        }
        EObject eobj = (EObject)element_p;
        Image result = EObjectLabelProviderHelper.getImage(eobj);
        if (result == null && (rawEditingDomain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(eobj)) instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt((Notifier)eobj, IItemLabelProvider.class)) != null && (rawImage = provider.getImage((Object)eobj)) != null) {
            result = ExtendedImageRegistry.getInstance().getImage(rawImage);
        }
        return result;
    }

    public static class NameTypeViewerSorter
    extends ViewerSorter {
        private final IModelEnvironmentUI.SortingMethod _sortingMethod;

        public NameTypeViewerSorter(IModelEnvironmentUI.SortingMethod method_p) {
            this._sortingMethod = method_p;
        }

        public int compare(Viewer viewer_p, Object e1_p, Object e2_p) {
            int result;
            if (this._sortingMethod == IModelEnvironmentUI.SortingMethod.BY_NAME || !(e1_p instanceof EObject) || !(e2_p instanceof EObject)) {
                result = super.compare(viewer_p, e1_p, e2_p);
            } else {
                int onTypes;
                String typeName2;
                EObject element1 = (EObject)e1_p;
                EObject element2 = (EObject)e2_p;
                String typeName1 = element1.eClass().getName();
                if (typeName1 == null) {
                    typeName1 = "";
                }
                if ((typeName2 = element2.eClass().getName()) == null) {
                    typeName2 = "";
                }
                result = (onTypes = this.getComparator().compare(typeName1, typeName2)) != 0 ? onTypes : super.compare(viewer_p, e1_p, e2_p);
            }
            return result;
        }
    }
}

