/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IIdProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdProviderDispatcher
implements IIdProvider {
    private List<IIdProvider> _IDProviders = this.discoverRegisteredIDProviders();
    private static final String ID_PROVIDER_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.core.idProvider";
    private static final String ID_PROVIDER_EXTENSION_POINT_PROPERTY = "class";

    private List<IIdProvider> discoverRegisteredIDProviders() {
        IConfigurationElement[] config;
        ArrayList<IIdProvider> result = new ArrayList<IIdProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(ID_PROVIDER_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension(ID_PROVIDER_EXTENSION_POINT_PROPERTY);
                if (o instanceof IIdProvider) {
                    result.add((IIdProvider)o);
                }
            }
            catch (CoreException o) {
            }
            catch (Exception iex) {
                System.out.println(iex.getMessage());
            }
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    protected String getDefaultNewId() {
        return EcoreUtil.generateUUID();
    }

    @Override
    public String getNewIdFor(EObject element_p) {
        String result;
        IIdProvider mainProvider = null;
        for (IIdProvider provider : this._IDProviders) {
            if (provider.isMainModel()) {
                mainProvider = provider;
                continue;
            }
            if (!provider.isApplicableTo(element_p) || (result = provider.getNewIdFor(element_p)) == null) continue;
            return result;
        }
        if (mainProvider != null && mainProvider.isApplicableTo(element_p) && (result = mainProvider.getNewIdFor(element_p)) != null) {
            return result;
        }
        return this.getDefaultNewId();
    }

    @Override
    public String getId(EObject element_p, EditingDomain editingDomain_p) {
        String result;
        IIdProvider mainProvider = null;
        for (IIdProvider provider : this._IDProviders) {
            if (provider.isMainModel()) {
                mainProvider = provider;
                continue;
            }
            if (!provider.isApplicableTo(element_p) || (result = provider.getId(element_p, editingDomain_p)) == null) continue;
            return result;
        }
        if (mainProvider != null && mainProvider.isApplicableTo(element_p)) {
            result = mainProvider.getId(element_p, editingDomain_p);
            return result;
        }
        return null;
    }

    @Override
    public EObject getById(String id_p, Collection<? extends Resource> scope_p) {
        EObject result;
        IIdProvider mainProvider = null;
        for (IIdProvider provider : this._IDProviders) {
            if (provider.isMainModel()) {
                mainProvider = provider;
                continue;
            }
            result = provider.getById(id_p, scope_p);
            if (result == null) continue;
            return result;
        }
        if (mainProvider != null && (result = mainProvider.getById(id_p, scope_p)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public EObject getByIdInContext(String id_p, Object context_p) {
        EObject result;
        IIdProvider mainProvider = null;
        for (IIdProvider provider : this._IDProviders) {
            if (provider.isMainModel()) {
                mainProvider = provider;
                continue;
            }
            result = provider.getByIdInContext(id_p, context_p);
            if (result == null) continue;
            return result;
        }
        if (mainProvider != null && (result = mainProvider.getByIdInContext(id_p, context_p)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public EObject getByIdInResource(String id_p, EObject context_p) {
        EObject result;
        IIdProvider mainProvider = null;
        for (IIdProvider provider : this._IDProviders) {
            if (provider.isMainModel()) {
                mainProvider = provider;
                continue;
            }
            result = provider.getByIdInResource(id_p, context_p);
            if (result == null) continue;
            return result;
        }
        if (mainProvider != null && (result = mainProvider.getByIdInResource(id_p, context_p)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public boolean isApplicableTo(EObject element_p) {
        for (IIdProvider provider : this._IDProviders) {
            boolean result = provider.isApplicableTo(element_p);
            if (!result) continue;
            return result;
        }
        return false;
    }

    @Override
    public boolean isMainModel() {
        return false;
    }

    @Override
    public boolean requiresNewIntrinsicID(EObject element_p, Object scope_p) {
        for (IIdProvider provider : this._IDProviders) {
            if (!provider.isApplicableTo(element_p)) continue;
            return provider.requiresNewIntrinsicID(element_p, scope_p);
        }
        return false;
    }
}

