/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.repositories.catalogs;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.CorepatternsFactory;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.util.ResourcesUtil;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.notification.CatalogResourceChangeHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class PatternCatalogAccessor {
    private static CatalogResourceChangeHandler _catalogNotifier;

    protected PatternCatalogAccessor() {
    }

    public void closeCatalog(PatternRepository repository_p) {
        CorePatternsPlugin.getDefault().getRepositoryRegistry().unregister((IPatternRepository)repository_p);
        Resource repositoryResource = repository_p.eResource();
        if (repositoryResource != null) {
            ResourceSet resourceSet = repositoryResource.getResourceSet();
            repositoryResource.unload();
            resourceSet.getResources().remove((Object)repositoryResource);
        }
    }

    public PatternRepository createCatalog(URI uri_p, ResourceSet resourceSet_p) {
        String name = uri_p.trimFileExtension().lastSegment();
        Resource resource = ResourcesUtil.getCreateResourceForUri((URI)uri_p, (ResourceSet)resourceSet_p);
        PatternRepository result = this.createCatalogIn(resource, name);
        boolean saved = this.saveCatalog(result);
        if (saved) {
            CorePatternsPlugin.getDefault().getRepositoryRegistry().register((IPatternRepository)result);
        } else {
            result = null;
        }
        return result;
    }

    private PatternRepository createCatalogIn(Resource resource_p, String name_p) {
        PatternRepository result = CorepatternsFactory.eINSTANCE.createPatternRepository();
        result.setName(name_p);
        resource_p.getContents().add((Object)result);
        PatternCatalogAccessor.set_catalogNotifier(new CatalogResourceChangeHandler(result));
        return result;
    }

    public PatternRepository getCatalogInResource(Resource resource_p) {
        for (EObject root : resource_p.getContents()) {
            if (!(root instanceof PatternRepository)) continue;
            return (PatternRepository)root;
        }
        return null;
    }

    public PatternRepository openCatalog(URI uri_p, ResourceSet resourceSet_p) throws IOException {
        Resource resource;
        PatternRepository result = null;
        if (ResourcesUtil.isPersistent((URI)uri_p) && (resource = ResourcesUtil.getCreateResourceForUri((URI)uri_p, (ResourceSet)resourceSet_p)) != null) {
            resource.load(null);
            result = this.getCatalogInResource(resource);
        }
        if (result != null) {
            CorePatternsPlugin.getDefault().getRepositoryRegistry().register(result);
            PatternCatalogAccessor.set_catalogNotifier(new CatalogResourceChangeHandler(result));
        }
        return result;
    }

    public boolean saveCatalog(PatternRepository repository_p) {
        return ResourcesUtil.makePersistent((Resource)repository_p.eResource());
    }

    public static CatalogResourceChangeHandler get_catalogNotifier() {
        return _catalogNotifier;
    }

    protected static void set_catalogNotifier(CatalogResourceChangeHandler catalogNotifier_p) {
        _catalogNotifier = catalogNotifier_p;
    }
}

