/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ITextualLanguageInterpreterFacade;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.SemanticRuleProvidersDispatcher;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternCreationSpecification;
import org.osgi.framework.BundleContext;

public class TemplatePatternsEnginePlugin
extends Plugin {
    private static TemplatePatternsEnginePlugin __plugin;
    private static final String LANGUAGE_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.templates.engine.textualLanguageInterpreterFacade";
    private static final String LANGUAGE_EXTENSION_POINT_PROPERTY = "class";
    private Map<String, ITextualLanguageInterpreterFacade> _languages = null;
    protected SemanticRuleProvidersDispatcher _semanticRuleProvidersDispatcher = new SemanticRuleProvidersDispatcher();
    private TemplatePatternCreationSpecification _creationSpecification = null;

    public void clearTraces() {
        this._creationSpecification = null;
    }

    private List<ITextualLanguageInterpreterFacade> discoverRegisteredInterpreterFacades() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT);
        ArrayList<ITextualLanguageInterpreterFacade> result = new ArrayList<ITextualLanguageInterpreterFacade>();
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension(LANGUAGE_EXTENSION_POINT_PROPERTY);
                if (o instanceof ITextualLanguageInterpreterFacade) {
                    result.add((ITextualLanguageInterpreterFacade)o);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return result;
    }

    public static TemplatePatternsEnginePlugin getDefault() {
        return __plugin;
    }

    public ITextualLanguageInterpreterFacade getLanguageFacadeFor(String languageName_p) {
        if (this._languages == null) {
            List<ITextualLanguageInterpreterFacade> facades = this.discoverRegisteredInterpreterFacades();
            this._languages = new HashMap<String, ITextualLanguageInterpreterFacade>();
            for (ITextualLanguageInterpreterFacade facade : facades) {
                this._languages.put(facade.getLanguage(), facade);
            }
        }
        return this._languages.get(languageName_p);
    }

    public TemplatePatternCreationSpecification getLastPatternCreationData() {
        return this._creationSpecification;
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public ISemanticRuleProvider getSemanticRuleProviderFor(Object context_p) {
        return this._semanticRuleProvidersDispatcher;
    }

    public TemplatePatternCreationSpecification newPatternCreationData(boolean isTemplate_p, List<? extends Object> sources_p, List<String> currentEnvironments_p) {
        this._creationSpecification = new TemplatePatternCreationSpecification(isTemplate_p, sources_p, currentEnvironments_p);
        return this._creationSpecification;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }
}

