/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.util.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.util.CollectionsUtil;
import org.eclipse.emf.diffmerge.bridge.util.structures.AbstractPureStructure;
import org.eclipse.emf.diffmerge.bridge.util.structures.IField;
import org.eclipse.emf.diffmerge.bridge.util.structures.IStruct;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuple2;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuples;

public class Struct
extends AbstractPureStructure<Object>
implements IStruct.Editable {
    protected final SortedMap<IField<?>, Object> _contentMap = new TreeMap();

    public static Struct struct(IField<?> ... fields_p) {
        return new Struct(fields_p);
    }

    public Struct(IField<?> ... fields_p) {
        this(Arrays.asList(fields_p));
    }

    public Struct(List<? extends IField<?>> fields_p) {
        for (IField<?> field : fields_p) {
            if (field == null) continue;
            this._contentMap.put(field, null);
        }
    }

    public Struct(Map<? extends IField<?>, ?> valueMap_p) {
        for (Map.Entry<IField<?>, ?> entry : valueMap_p.entrySet()) {
            IField<?> key = entry.getKey();
            if (key == null) continue;
            this._contentMap.put(key, entry.getValue());
        }
    }

    @Override
    public Collection<Object> asCollection() {
        return this._contentMap.values();
    }

    protected void checkField(IField<?> field_p) {
        if (!this.hasField(field_p)) {
            throw new IllegalArgumentException("Struct does not have field: " + field_p);
        }
    }

    public boolean equals(Object peer_p) {
        if (peer_p == this) {
            return true;
        }
        if (!(peer_p instanceof IStruct)) {
            return false;
        }
        if (peer_p instanceof Struct) {
            return this._contentMap.equals(((Struct)peer_p)._contentMap);
        }
        IStruct peer = (IStruct)peer_p;
        Set<IField<?>> ownFields = this.getFields();
        if (ownFields.size() != peer.getFields().size()) {
            return false;
        }
        for (IField<?> field : ownFields) {
            boolean sameValue = false;
            try {
                Object peerValue = peer.get(field);
                Object ownValue = this.get(field);
                sameValue = CollectionsUtil.areEqual(ownValue, peerValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (sameValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T get(IField<T> field_p) {
        Object result = this._contentMap.get(field_p);
        if (result == null) {
            this.checkField(field_p);
        }
        return (T)result;
    }

    @Override
    public Collection<Tuple2<IField<?>, Object>> getContents() {
        Set<Map.Entry<IField<?>, Object>> entries = this._contentMap.entrySet();
        ArrayList result = new ArrayList(entries.size());
        for (Map.Entry<IField<?>, Object> entry : entries) {
            result.add(Tuples.tuple(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Set<? extends IField<?>> getFields() {
        return this._contentMap.keySet();
    }

    @Override
    public Object getSymbol(ISymbolFunction function_p) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        boolean first = true;
        for (IField<?> field : this.getFields()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
                builder.append(' ');
            }
            Object fieldSymbol = function_p.getSymbol(field);
            Object value = this.get(field);
            Object valueSymbol = function_p.getSymbol(value);
            builder.append(fieldSymbol);
            builder.append(':');
            builder.append(valueSymbol);
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean hasField(IField<?> field_p) {
        return this.getFields().contains(field_p);
    }

    public int hashCode() {
        return this._contentMap.hashCode();
    }

    @Override
    public <T> void set(IField<T> field_p, T value_p) {
        this.checkField(field_p);
        this._contentMap.put(field_p, value_p);
    }

    @Override
    public int size() {
        return this._contentMap.size();
    }
}

