/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.impl;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.impl.StructureBasedCause;
import org.eclipse.emf.diffmerge.bridge.util.AbstractLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.BaseTraceLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.structures.IPureStructure;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuple2;

public abstract class AbstractBridgeExecution
implements IBridgeExecution.Editable {
    private final Logger _logger;
    private IStatus _status;

    public AbstractBridgeExecution(Logger logger_p) {
        this._logger = logger_p;
        this._status = Status.OK_STATUS;
    }

    protected AbstractLoggingMessage createTraceLoggingMessage(Object target_p, ICause<?> cause_p) {
        return new BaseTraceLoggingMessage(target_p, cause_p);
    }

    protected Logger getLogger() {
        return this._logger;
    }

    @Override
    public IStatus getStatus() {
        return this._status;
    }

    protected void handleWrongCause(ICause<?> cause_p) {
        throw new IllegalArgumentException("Wrong type of cause: " + cause_p);
    }

    protected void put(ICause<?> cause_p, Object target_p) {
        this.putInTrace(cause_p, target_p);
    }

    protected void putInTrace(ICause<?> cause_p, Object target_p) {
        if (target_p instanceof IPureStructure && cause_p instanceof ICause.Symbolic) {
            Collection contents = ((IPureStructure)target_p).getContents();
            ICause.Symbolic cause = (ICause.Symbolic)cause_p;
            for (Tuple2 slotAndValue : contents) {
                StructureBasedCause structCause = new StructureBasedCause(cause, slotAndValue.get1());
                this.putInTraceAtomic(structCause, slotAndValue.get2());
            }
        } else {
            this.putInTraceAtomic(cause_p, target_p);
        }
    }

    protected void putInTraceAtomic(ICause<?> cause_p, Object targetElement_p) {
        IBridgeTrace.Editable trace = this.getTrace();
        if (trace != null) {
            trace.putCause(cause_p, targetElement_p);
            if (cause_p instanceof ICause.Symbolic) {
                this.getLogger().info((Object)this.createTraceLoggingMessage(targetElement_p, cause_p));
            }
        }
    }

    public void setStatus(IStatus newStatus_p) {
        this._status = newStatus_p;
    }
}

