/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternProvider;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRoleBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.providers.NameBasedLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternPage;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractRoleBasedPage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoleSelectionPage<T extends IRoleBasedSpecification>
extends AbstractRoleBasedPage<T> {
    private boolean _alreadyShown = false;

    public AbstractRoleSelectionPage(String pageName_p, String pageTitle_p, String defaultMessage_p, T data_p, boolean isBlocking_p) {
        super(pageName_p, pageTitle_p, defaultMessage_p, data_p, isBlocking_p);
    }

    @Override
    protected String getValidationMessage() {
        String result = null;
        TemplatePattern pattern = ((IRoleBasedSpecification)this.getData()).getPattern();
        if (pattern != null && pattern.getRoles().isEmpty()) {
            result = Messages.AbstractRoleSelectionPage_RoleRequirement;
        } else if (!NamingUtil.haveUniqueNames(this.getRoles())) {
            result = Messages.AbstractRoleSelectionPage_RoleNameUniqueness;
        } else if (pattern != null) {
            for (IPatternRole role : pattern.getRoles()) {
                if (!(role instanceof TemplatePatternRole) || !((TemplatePatternRole)role).getTemplateElements().isEmpty()) continue;
                result = String.format(Messages.AbstractRoleSelectionPage_RoleNonEmptiness, role.getName());
                break;
            }
        }
        return result;
    }

    private Button createMoveRoleDownButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractRoleSelectionPage_Down);
        result.setEnabled(false);
        result.setLayoutData((Object)this.createButtonLayoutData());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole role = ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).getRole();
                if (role != null) {
                    List<TemplatePatternRole> roles = AbstractRoleSelectionPage.this.getRoles();
                    int index = roles.indexOf(role);
                    roles.remove(index);
                    roles.add(index + 1, role);
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).roleUpdated();
                    AbstractRoleSelectionPage.this.validate();
                }
            }
        });
        return result;
    }

    private Button createMoveRoleUpButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractRoleSelectionPage_Up);
        result.setEnabled(false);
        result.setLayoutData((Object)this.createButtonLayoutData());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplatePatternRole role = ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).getRole();
                if (role != null) {
                    List<TemplatePatternRole> roles = AbstractRoleSelectionPage.this.getRoles();
                    int index = roles.indexOf(role);
                    roles.remove(index);
                    roles.add(index - 1, role);
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).roleUpdated();
                    AbstractRoleSelectionPage.this.validate();
                }
            }
        });
        return result;
    }

    protected Composite createRoleControls(Composite parent_p, boolean allowEdition_p) {
        Group result = this.createGroup(parent_p, Messages.AbstractRoleSelectionPage_Roles, false, 2);
        if (allowEdition_p) {
            this.createRoleAdditionControls((Composite)result);
        }
        this.createRoleList((Composite)result);
        if (allowEdition_p) {
            final Button deleteButton = this.createRoleDeletionButton((Composite)result);
            final Button renameButton = this.createRoleRenamingButton((Composite)result);
            final Button upButton = this.createMoveRoleUpButton((Composite)result);
            final Button downButton = this.createMoveRoleDownButton((Composite)result);
            ((IRoleBasedSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

                public void roleChanged(TemplatePatternRole newRole_p) {
                    deleteButton.setEnabled(newRole_p != null);
                    renameButton.setEnabled(newRole_p != null);
                    if (newRole_p != null) {
                        List<TemplatePatternRole> roles = AbstractRoleSelectionPage.this.getRoles();
                        int index = roles.indexOf(newRole_p);
                        upButton.setEnabled(index > 0);
                        downButton.setEnabled(index < roles.size() - 1);
                    } else {
                        upButton.setEnabled(false);
                        downButton.setEnabled(false);
                    }
                }
            });
        }
        return result;
    }

    private void createRoleAdditionControls(Composite parent_p) {
        Button addButton = new Button(parent_p, 8);
        addButton.setText(Messages.AbstractRoleSelectionPage_Add);
        addButton.setLayoutData((Object)this.createButtonLayoutData());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                String name = AbstractRoleSelectionPage.this.promptForRoleName("newRole");
                if (name != null) {
                    ((IModifiableTemplatePatternSpecification)AbstractRoleSelectionPage.this.getData()).addRole(name);
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).roleUpdated();
                    AbstractRoleSelectionPage.this.validate();
                }
            }
        });
    }

    private Button createRoleDeletionButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractRoleSelectionPage_Delete);
        result.setEnabled(false);
        result.setLayoutData((Object)this.createButtonLayoutData());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean confirmed;
                TemplatePatternRole role = ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).getRole();
                if (role != null && (confirmed = MessageDialog.openConfirm((Shell)AbstractRoleSelectionPage.this.getShell(), (String)Messages.AbstractRoleSelectionPage_DeleteRoleTitle, (String)(String.valueOf(Messages.AbstractRoleSelectionPage_DeleteRole) + " '" + role.getName() + "'?")))) {
                    ((IModifiableTemplatePatternSpecification)AbstractRoleSelectionPage.this.getData()).removeRole(role);
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).roleUpdated();
                    AbstractRoleSelectionPage.this.validate();
                }
            }
        });
        return result;
    }

    private Button createRoleRenamingButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractRoleSelectionPage_RenameRole);
        result.setEnabled(false);
        result.setLayoutData((Object)this.createButtonLayoutData());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InputDialog inDiag;
                int answer;
                TemplatePatternRole role = ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).getRole();
                if (role != null && (answer = (inDiag = new InputDialog(AbstractRoleSelectionPage.this.getShell(), Messages.AbstractRoleSelectionPage_RenameRoleTitle, Messages.AbstractRoleSelectionPage_NewRoleName, role.getName(), null)).open()) == 0) {
                    String newName = inDiag.getValue();
                    role.setName(newName);
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).roleUpdated();
                    AbstractRoleSelectionPage.this.validate();
                }
            }
        });
        return result;
    }

    private ListViewer createRoleList(Composite parent_p) {
        ListViewer result;
        org.eclipse.swt.widgets.List rolesList = new org.eclipse.swt.widgets.List(parent_p, 2820);
        GridData listData = new GridData(4, 4, true, true);
        listData.verticalSpan = 5;
        listData.widthHint = 150;
        rolesList.setLayoutData((Object)listData);
        this._rolesViewer = result = new ListViewer(rolesList);
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement_p) {
                IPatternProvider input;
                Object[] elements = new Object[]{};
                if (inputElement_p instanceof IPatternProvider && (input = (IPatternProvider)inputElement_p).getPattern() != null) {
                    elements = input.getPattern().getRoles().toArray();
                }
                return elements;
            }
        });
        result.setInput(this.getData());
        result.setLabelProvider((IBaseLabelProvider)new AbstractRoleBasedPage.RoleViewerLabelProvider(this, (ILabelProvider)NameBasedLabelProvider.getInstance()));
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IStructuredSelection selection = (IStructuredSelection)event_p.getSelection();
                if (!(selection instanceof AbstractPatternPage.NonUserSelection)) {
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).setRole((TemplatePatternRole)selection.getFirstElement());
                }
            }
        });
        ((IRoleBasedSpecification)this.getData()).addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

            public void roleChanged(TemplatePatternRole newRole_p) {
                IStructuredSelection selection = (IStructuredSelection)result.getSelection();
                if (!(selection.isEmpty() && newRole_p == null || !selection.isEmpty() && selection.getFirstElement() == newRole_p)) {
                    result.setSelection((ISelection)AbstractPatternPage.NonUserSelection.newInstance(newRole_p));
                }
                result.refresh(true);
            }
        });
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    result.setInput(AbstractRoleSelectionPage.this.getData());
                    ((IRoleBasedSpecification)AbstractRoleSelectionPage.this.getData()).setRole(null);
                }
            });
        }
        return result;
    }

    public String promptForRoleName(String defaultName_p) {
        String roleName = null;
        String EMPTY = "";
        String defaultName = defaultName_p != null ? defaultName_p : "";
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText_p) {
                String result = null;
                if (newText_p == null || newText_p.length() == 0) {
                    result = "";
                }
                return result;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.AbstractRoleSelectionPage_AddRoleTitle, Messages.AbstractRoleSelectionPage_AddRoleDescription, defaultName, validator);
        int answer = dialog.open();
        if (answer == 0) {
            roleName = dialog.getValue();
        }
        return roleName;
    }

    @Override
    public void setVisible(boolean visible_p) {
        super.setVisible(visible_p);
        if (!this._alreadyShown) {
            List<TemplatePatternRole> roles;
            this._alreadyShown = true;
            if (((IRoleBasedSpecification)this.getData()).getRole() == null && !(roles = this.getRoles()).isEmpty()) {
                this._rolesViewer.setSelection((ISelection)new StructuredSelection((Object)roles.get(0)));
            }
        }
    }
}

