/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractElementSelectionDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractTableChoiceDialog;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageChoiceDialog
extends AbstractElementSelectionDialog<IReferenceLocation> {
    protected final Collection<EObject> _toStore;
    protected final EClass _valueType;

    public StorageChoiceDialog(Shell parentShell_p, String message_p, List<? extends EObject> proposed_p, Collection<? extends EObject> toStore_p) {
        super(parentShell_p, StorageChoiceDialog.enforceTypeMessage(message_p, toStore_p), proposed_p);
        this._toStore = new FArrayList(toStore_p, null);
        this._valueType = ModelsUtil.getCommonType(this._toStore);
    }

    protected static String enforceTypeMessage(String message_p, Collection<? extends EObject> values_p) {
        String result = message_p;
        if (result == null) {
            EClass type;
            String name = "Unnamed";
            if (values_p != null && values_p.iterator().hasNext()) {
                EObject obj = values_p.iterator().next();
                ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)obj);
                EAttribute nameattr = ruleProvider.getNameAttribute(obj);
                Object ename = nameattr != null ? obj.eGet((EStructuralFeature)nameattr) : null;
                name = ename instanceof String ? (String)ename : name;
            }
            String typeName = (type = ModelsUtil.getCommonType(values_p)) != null ? type.getName() : "";
            result = String.format(Messages.StorageChoiceDialog_PromptMulti, name, typeName);
        }
        return result;
    }

    @Override
    public IReferenceLocation getChoice() {
        ISemanticRuleProvider ruleProvider;
        List candidates;
        BasicReferenceLocation result = null;
        EObject selected = this._viewer.getChoice();
        if (selected != null && (candidates = (ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)selected)).getReferencesForAddition(selected, this._valueType, true, true)) != null) {
            if (candidates.size() > 0) {
                result = new BasicReferenceLocation(selected, (EReference)candidates.get(0));
            } else {
                AbstractTableChoiceDialog<EReference> dialog = new AbstractTableChoiceDialog<EReference>(this.getShell(), CorePatternsPlugin.getDefault().getLabel(), Messages.StorageChoiceDialog_PromptContainment, (Collection)candidates, AbstractTableChoiceDialog.SelectionKind.SINGLE){

                    @Override
                    protected List<String> getColumnHeaders() {
                        return Arrays.asList(Messages.StorageChoiceDialog_Containment, Messages.StorageChoiceDialog_Origin);
                    }

                    @Override
                    protected String getColumnText(EReference reference_p, int columnIndex_p) {
                        switch (columnIndex_p) {
                            case 0: {
                                return reference_p.getName();
                            }
                            case 1: {
                                return reference_p.getEContainingClass().getName();
                            }
                        }
                        return "";
                    }

                    @Override
                    protected int getColumnWidth(int columnNb_p) {
                        return 200;
                    }
                };
                int answer = dialog.open();
                if (answer == 0) {
                    result = new BasicReferenceLocation(selected, (EReference)dialog.getChoice());
                }
            }
        }
        return result;
    }

    @Override
    protected boolean isEligible(EObject element_p) {
        ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)element_p);
        List references = ruleProvider.getReferencesForAddition(element_p, this._valueType, true, true);
        if (references != null) {
            return !references.isEmpty();
        }
        return false;
    }
}

