/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectPrinter {
    private static final String SPAN_COMPARE_COLUMN = "_______________________________________";
    private boolean showSpan = false;
    private boolean sortLists = true;
    public boolean preprocessReferences = true;
    Vector levels = null;
    String indentLevelConnector = ":. ";
    String indent = "   ";
    private Comparator eNamedElementComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (o1 instanceof ENamedElement && o2 instanceof ENamedElement) {
                ENamedElement e1 = (ENamedElement)o1;
                ENamedElement e2 = (ENamedElement)o2;
                String e1Name = null;
                String e2Name = null;
                if (e1 != null) {
                    e1Name = e1.getName();
                }
                if (e2 != null) {
                    e2Name = e2.getName();
                }
                if ((result = this.compareNames(e1Name, e2Name)) == 0 && e1 != null && e2 != null && e1.getClass() == e2.getClass()) {
                    for (EReference ref : e1.eClass().getEAllReferences()) {
                        if (!ref.isMany()) {
                            ENamedElement e2child;
                            ENamedElement e1child = (ENamedElement)e1.eGet((EStructuralFeature)ref);
                            if (e1child == (e2child = (ENamedElement)e2.eGet((EStructuralFeature)ref))) {
                                result = 0;
                            } else if (e1child != null && e2child != null) {
                                result = this.compareNames(e1child.getName(), e2child.getName());
                            } else if (e1child != null) {
                                result = 1;
                            } else if (e2child != null) {
                                result = -1;
                            }
                        }
                        if (result != 0) break;
                    }
                }
            }
            return result;
        }

        private int compareNames(String e1Name, String e2Name) {
            int result = 0;
            if (e1Name != null && e2Name != null) {
                result = e1Name.compareTo(e2Name);
            } else if (e1Name != null) {
                result = 1;
            } else if (e2Name != null) {
                result = -1;
            }
            return result;
        }
    };

    protected boolean visited(EObject p_object, HashSet visited) {
        return visited.contains(p_object);
    }

    protected Object defaultCase(EObject p_object, PrintWriter pw, StringBuffer p_buff) {
        String p_object_String = p_object.toString();
        if (this.showSpan) {
            String sourceSnippet = new String();
            String generatedSQL = new String();
            StringBuffer sourceColumn = new StringBuffer(SPAN_COMPARE_COLUMN);
            StringBuffer generatedSQLColumn = new StringBuffer(SPAN_COMPARE_COLUMN);
            if (p_object instanceof SQLQueryObject) {
                SQLQueryObject qo = (SQLQueryObject)p_object;
                sourceSnippet = this.trimWhiteSpace(qo.getSourceInfo().getSourceSnippet());
                if (sourceSnippet != null) {
                    if (sourceSnippet.length() > sourceColumn.length()) {
                        sourceColumn.length();
                    } else {
                        sourceSnippet.length();
                    }
                    if (sourceSnippet.length() > sourceColumn.length()) {
                        sourceColumn.replace(0, sourceColumn.length(), String.valueOf(sourceSnippet) + '\n');
                        generatedSQLColumn.append(SPAN_COMPARE_COLUMN).append("____");
                    } else {
                        sourceColumn.replace(0, sourceSnippet.length(), sourceSnippet);
                    }
                }
                if ((generatedSQL = this.trimWhiteSpace(qo.getSQL())) != null) {
                    if (generatedSQL.length() > generatedSQLColumn.length()) {
                        generatedSQLColumn.length();
                    } else {
                        generatedSQL.length();
                    }
                    if (generatedSQL.length() > generatedSQLColumn.length()) {
                        generatedSQLColumn = new StringBuffer(generatedSQL);
                        generatedSQLColumn.append('\n');
                        generatedSQLColumn.append(SPAN_COMPARE_COLUMN);
                        generatedSQLColumn.append(SPAN_COMPARE_COLUMN);
                        generatedSQLColumn.append("____");
                    } else {
                        generatedSQLColumn.replace(0, generatedSQL.length(), generatedSQL);
                    }
                }
            }
            pw.print(sourceColumn);
            if (this.stripWhiteSpace(sourceSnippet).equalsIgnoreCase(this.stripWhiteSpace(generatedSQL))) {
                pw.print(" == ");
            } else {
                pw.print(" ## ");
            }
            if (sourceColumn.length() > SPAN_COMPARE_COLUMN.length()) {
                pw.print('\n');
            }
            pw.print(generatedSQLColumn);
        }
        int classNameStartIndex = p_object_String.substring(0, p_object_String.indexOf(64)).lastIndexOf(46) + 1;
        p_object_String = p_object_String.substring(classNameStartIndex);
        pw.println(String.valueOf(p_buff.toString()) + p_object_String);
        return null;
    }

    private String trimWhiteSpace(String toBeTrimmed) {
        if (toBeTrimmed == null) {
            return "";
        }
        StringBuffer trimmed = new StringBuffer();
        char SPACE = ' ';
        char NEW_LINE = '\n';
        char lastChar = ' ';
        int i = 0;
        while (i < toBeTrimmed.length()) {
            char currentChar = toBeTrimmed.charAt(i);
            if (currentChar == NEW_LINE && lastChar != SPACE) {
                trimmed.append(SPACE);
            } else if (currentChar != SPACE || lastChar != SPACE) {
                trimmed.append(currentChar);
            }
            lastChar = trimmed.charAt(trimmed.length() - 1);
            ++i;
        }
        return trimmed.toString();
    }

    private String stripWhiteSpace(String toBeTrimmed) {
        if (toBeTrimmed == null) {
            return "";
        }
        StringBuffer trimmed = new StringBuffer();
        char SPACE = ' ';
        char NEW_LINE = '\n';
        int i = 0;
        while (i < toBeTrimmed.length()) {
            char currentChar = toBeTrimmed.charAt(i);
            if (currentChar != NEW_LINE && currentChar != SPACE) {
                trimmed.append(currentChar);
            }
            ++i;
        }
        return trimmed.toString();
    }

    protected void setLevel(int p_level, StringBuffer p_buff) {
        if (p_buff.length() / this.indent.length() != p_level) {
            p_buff.setLength(0);
            int i = 0;
            while (i < p_level) {
                p_buff.append(this.indent);
                ++i;
            }
            if (p_level >= 1) {
                int conStart = p_buff.length() - this.indent.length();
                int conEnd = p_buff.length();
                p_buff.replace(conStart, conEnd, this.indentLevelConnector);
            }
        }
    }

    protected Object doSwitch(EObject p_theEObject, PrintWriter pw, StringBuffer p_buff) {
        return this.defaultCase(p_theEObject, pw, p_buff);
    }

    public PrintWriter printEObjectReferenceTree(EObject p_object) {
        return this.printEObjectReferenceTree(p_object, true);
    }

    public PrintWriter printEObjectReferenceTree(EObject p_object, boolean flush) {
        PrintWriter pw = new PrintWriter(System.out, false);
        StringBuffer p_buff = new StringBuffer();
        HashSet visited = new HashSet();
        Map levelMap = null;
        if (this.preprocessReferences) {
            if (this.levels == null) {
                this.levels = new Vector();
            }
            levelMap = this.initLevelMap(p_object, 0, levelMap);
        }
        this.foreachInternal(p_object, 0, null, visited, levelMap, pw, p_buff);
        if (flush) {
            pw.flush();
        }
        return pw;
    }

    protected Map initLevelMap(EObject p_object, int p_level, Map levelMap) {
        if (levelMap == null) {
            levelMap = new HashMap();
        }
        if (p_object == null) {
            return levelMap;
        }
        if (this.levels.size() == p_level) {
            this.levels.add(new Integer(p_level));
        }
        if (this.isHighestLevel(p_object, p_level, levelMap)) {
            levelMap.put(p_object, this.levels.get(p_level));
            for (EReference ref : p_object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    EList list = (EList)p_object.eGet((EStructuralFeature)ref);
                    for (EObject child : list) {
                        this.initLevelMap(child, p_level + 1, levelMap);
                    }
                    continue;
                }
                EObject child = (EObject)p_object.eGet((EStructuralFeature)ref);
                this.initLevelMap(child, p_level + 1, levelMap);
            }
        }
        return levelMap;
    }

    protected boolean isHighestLevel(EObject p_object, int p_level, Map levelMap) {
        Integer highestLevel = (Integer)levelMap.get(p_object);
        return highestLevel == null || highestLevel >= p_level;
    }

    private void foreachInternal(EObject p_object, int p_level, EObject referencedBy, HashSet visited, Map levelMap, PrintWriter pw, StringBuffer p_buff) {
        if (p_object == null) {
            return;
        }
        if (this.preprocessReferences && !this.isHighestLevel(p_object, p_level, levelMap)) {
            if (this.isHighestLevel(p_object, p_level - 1, levelMap) && !this.visited(p_object, visited)) {
                this.setLevel(p_level, p_buff);
                this.doSwitch(p_object, pw, p_buff);
            }
            return;
        }
        this.setLevel(p_level, p_buff);
        this.doSwitch(p_object, pw, p_buff);
        if (this.visited(p_object, visited)) {
            return;
        }
        visited.add(p_object);
        for (EReference ref : p_object.eClass().getEAllReferences()) {
            if (ref.isMany()) {
                Object list = (EList)p_object.eGet((EStructuralFeature)ref);
                if (this.sortLists) {
                    list = new ArrayList(list);
                    Collections.sort(list, this.eNamedElementComparator);
                }
                for (EObject child : list) {
                    if (child == referencedBy) continue;
                    this.foreachInternal(child, p_level + 1, p_object, visited, levelMap, pw, p_buff);
                }
                continue;
            }
            EObject child = (EObject)p_object.eGet((EStructuralFeature)ref);
            if (child == referencedBy) continue;
            this.foreachInternal(child, p_level + 1, p_object, visited, levelMap, pw, p_buff);
        }
    }
}

