/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.File;
import java.nio.file.Paths;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.RustManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class CorrosionPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final IPreferenceStore STORE = CorrosionPlugin.getDefault().getPreferenceStore();
    private static final String CARGO_DEFAULT_HOME = String.valueOf(System.getProperty("user.home")) + "/.cargo/bin/";
    private static final String DEFAULT_DEBUGGER = "rust-gdb";
    private static final boolean IS_WINDOWS = Platform.getOS().equals("win32");
    public static final String RUSTUP_PATHS_PREFERENCE = "corrosion.rustup_rustupPath";
    public static final String CARGO_PATH_PREFERENCE = "corrosion.rustup_cargoPath";
    public static final String TOOLCHAIN_ID_PREFERENCE = "corrosion.rustup_toolchain_Id";
    public static final String RLS_PATH_PREFERENCE = "corrosion.rslPath";
    public static final String RLS_CONFIGURATION_PATH_PREFERENCE = "corrosion.rls_configurationPath";
    public static final String SYSROOT_PATH_PREFERENCE = "corrosion.sysrootPath";
    public static final String WORKING_DIRECTORY_PREFERENCE = "corrosion.workingDirectory";
    public static final String DEFAULT_GDB_PREFERENCE = "corrosion.defaultGdb";

    public void initializeDefaultPreferences() {
        STORE.setDefault(RUSTUP_PATHS_PREFERENCE, CorrosionPreferenceInitializer.getRustupPathBestGuess());
        STORE.setDefault(CARGO_PATH_PREFERENCE, CorrosionPreferenceInitializer.getCargoPathBestGuess());
        CorrosionPreferenceInitializer.setToolchainBestGuesses();
        STORE.setDefault(SYSROOT_PATH_PREFERENCE, CorrosionPreferenceInitializer.getSysrootPathBestGuess(STORE));
        STORE.setDefault(RLS_PATH_PREFERENCE, CorrosionPreferenceInitializer.getLanguageServerPathBestGuess().getAbsolutePath());
        STORE.setDefault(WORKING_DIRECTORY_PREFERENCE, CorrosionPreferenceInitializer.getWorkingDirectoryBestGuess());
        STORE.setDefault(DEFAULT_GDB_PREFERENCE, DEFAULT_DEBUGGER);
    }

    private static String getRustupPathBestGuess() {
        File possibleCommandFile;
        String command = CorrosionPreferenceInitializer.findCommandPath("rustup");
        if (command.isEmpty() && (possibleCommandFile = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("rustup")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private static String getCargoPathBestGuess() {
        File possibleCommandFile;
        String command = CorrosionPreferenceInitializer.findCommandPath("cargo");
        if (command.isEmpty() && (possibleCommandFile = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("cargo")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private static String findCommandPath(String command) {
        return CorrosionPlugin.getOutputFromCommand(IS_WINDOWS ? "where" : "which", command);
    }

    private static void setToolchainBestGuesses() {
        String toolchain = RustManager.getDefaultToolchain();
        if (toolchain == null || toolchain.isEmpty()) {
            STORE.setDefault(TOOLCHAIN_ID_PREFERENCE, "");
            return;
        }
        int splitIndex = toolchain.indexOf(45);
        if (splitIndex != -1) {
            toolchain = toolchain.substring(0, splitIndex);
        }
        STORE.setDefault(TOOLCHAIN_ID_PREFERENCE, toolchain.trim());
    }

    private static File getLanguageServerPathBestGuess() {
        String command = CorrosionPreferenceInitializer.findCommandPath("rust-analyzer");
        if (command.isEmpty()) {
            File possibleCommandFile = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("rust-analyzer");
            if (possibleCommandFile.exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
                return possibleCommandFile;
            }
            if (RustManager.RUST_ANALYZER_DEFAULT_LOCATION.exists() && RustManager.RUST_ANALYZER_DEFAULT_LOCATION.isFile() && RustManager.RUST_ANALYZER_DEFAULT_LOCATION.canExecute()) {
                return RustManager.RUST_ANALYZER_DEFAULT_LOCATION;
            }
        }
        return new File(command);
    }

    private static String getSysrootPathBestGuess(IPreferenceStore preferenceStore) {
        String rustup = preferenceStore.getString(RUSTUP_PATHS_PREFERENCE);
        String toolchain = preferenceStore.getString(TOOLCHAIN_ID_PREFERENCE);
        if (!rustup.isEmpty() && !toolchain.isEmpty()) {
            String[] command = new String[]{rustup, "run", toolchain, "rustc", "--print", "sysroot"};
            return CorrosionPlugin.getOutputFromCommand(command);
        }
        File rustc = new File(CorrosionPreferenceInitializer.findCommandPath("rustc"));
        if (!(rustc.exists() && rustc.isFile() && rustc.canExecute())) {
            rustc = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("rustc");
        }
        if (!(rustc.exists() && rustc.isFile() && rustc.canExecute())) {
            return "";
        }
        String[] command = new String[]{rustc.getAbsolutePath(), "--print", "sysroot"};
        return CorrosionPlugin.getOutputFromCommand(command);
    }

    private static File getExectuableFileOfCargoDefaultHome(String executable) {
        return new File(String.valueOf(CARGO_DEFAULT_HOME) + executable + (IS_WINDOWS ? ".exe" : ""));
    }

    private static String getWorkingDirectoryBestGuess() {
        return Paths.get("", new String[0]).toAbsolutePath().toString();
    }
}

