/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.AsciiDocBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class PreformattedBlock
extends AsciiDocBlock {
    private static final Pattern startPattern = Pattern.compile("((?: {4}|\\t))((?: {4}|\\t)*)(.*)");
    private Matcher matcher;
    private boolean hasContent;

    public PreformattedBlock() {
        super(startPattern);
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        return false;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    @Override
    protected void processBlockStart() {
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        String line = this.startDelimiter;
        this.setStartDelimiter(this.matcher.group(1));
        this.hasContent = false;
        this.processBlockContent(line);
    }

    @Override
    protected boolean isClosingLine(String line, int offset) {
        return !line.startsWith(this.getStartDelimiter()) || line.trim().isEmpty();
    }

    @Override
    protected void processBlockContent(String line) {
        this.matcher = startPattern.matcher(line);
        if (this.matcher.matches()) {
            String indent = this.matcher.group(2);
            String content = this.matcher.group(3);
            if (this.hasContent) {
                this.builder.characters("\n");
            }
            if (indent != null) {
                this.builder.characters(indent);
            }
            this.builder.characters(content);
            this.hasContent = true;
        }
    }

    @Override
    protected void processBlockEnd() {
    }
}

