/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableBooleanList extends ImmutableBooleanCollection, BooleanList
{
    @Override
    ImmutableBooleanList select(BooleanPredicate predicate);

    @Override
    ImmutableBooleanList reject(BooleanPredicate predicate);

    @Override
    <V> ImmutableList<V> collect(BooleanToObjectFunction<? extends V> function);

    @Override
    ImmutableBooleanList newWith(boolean element);

    @Override
    ImmutableBooleanList newWithout(boolean element);

    @Override
    ImmutableBooleanList newWithAll(BooleanIterable elements);

    @Override
    ImmutableBooleanList newWithoutAll(BooleanIterable elements);

    @Override
    ImmutableBooleanList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    ImmutableBooleanList distinct();

    @Override
    ImmutableBooleanList subList(int fromIndex, int toIndex);
}
