/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableByteSet
extends AbstractMutableSet<Byte>
implements MutableSet<Byte> {
    private final MutableByteSet delegate;

    public BoxedMutableByteSet(MutableByteSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Byte getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Byte> procedure) {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Byte item) {
        return this.delegate.add(item);
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Byte && this.delegate.contains((Byte)object);
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Byte && this.delegate.remove((Byte)object);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Byte> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new BoxedPrimitiveByteSetIterator(this.delegate.byteIterator());
    }

    private static final class BoxedPrimitiveByteSetIterator
    implements Iterator<Byte> {
        private final MutableByteIterator delegate;

        private BoxedPrimitiveByteSetIterator(MutableByteIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Byte next() {
            return this.delegate.next();
        }
    }
}

