/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.net.jsse.NioX509KeyManager;

public class Nio2Endpoint
extends AbstractEndpoint<Nio2Channel> {
    private static final Log log = LogFactory.getLog(Nio2Endpoint.class);
    private AsynchronousServerSocketChannel serverSock = null;
    private boolean useSendfile = true;
    private int oomParachute = 0x100000;
    private static ThreadLocal<Boolean> inlineCompletion = new ThreadLocal();
    private AsynchronousChannelGroup threadGroup = null;
    private volatile boolean allClosed;
    private byte[] oomParachuteData = null;
    private static final String oomParachuteMsg = "SEVERE:Memory usage is low, parachute is non existent, your system may start failing.";
    private long lastParachuteCheck = System.currentTimeMillis();
    private SynchronizedStack<SocketProcessor> processorCache;
    private SynchronizedStack<Nio2Channel> nioChannels;
    private boolean useCaches = false;
    private int pollerThreadPriority = 5;
    private Handler handler = null;
    private boolean useComet = true;
    private SSLContext sslContext = null;
    private String[] enabledCiphers;
    private String[] enabledProtocols;
    private CompletionHandler<Integer, SocketWrapper<Nio2Channel>> awaitBytes = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

        @Override
        public synchronized void completed(Integer nBytes, SocketWrapper<Nio2Channel> attachment) {
            if (nBytes < 0) {
                this.failed((Throwable)new ClosedChannelException(), attachment);
                return;
            }
            Nio2Endpoint.this.processSocket0(attachment, SocketStatus.OPEN_READ, true);
        }

        @Override
        public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
            Nio2Endpoint.this.processSocket0(attachment, SocketStatus.DISCONNECT, true);
        }
    };
    private CompletionHandler<Integer, SendfileData> sendfile = new CompletionHandler<Integer, SendfileData>(){

        @Override
        public void completed(Integer nWrite, SendfileData attachment) {
            if (nWrite < 0) {
                this.failed((Throwable)new EOFException(), attachment);
                return;
            }
            attachment.pos += (long)nWrite.intValue();
            if (!attachment.buffer.hasRemaining()) {
                if (attachment.length <= 0L) {
                    attachment.socket.setSendfileData(null);
                    attachment.buffer.clear();
                    try {
                        attachment.fchannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (attachment.keepAlive) {
                        if (!Nio2Endpoint.isInline()) {
                            Nio2Endpoint.this.awaitBytes(attachment.socket);
                        } else {
                            attachment.doneInline = true;
                        }
                    } else if (!Nio2Endpoint.isInline()) {
                        Nio2Endpoint.this.processSocket(attachment.socket, SocketStatus.DISCONNECT, false);
                    } else {
                        attachment.doneInline = true;
                    }
                    return;
                }
                attachment.buffer.clear();
                int nRead = -1;
                try {
                    nRead = attachment.fchannel.read(attachment.buffer);
                }
                catch (IOException e) {
                    this.failed((Throwable)e, attachment);
                    return;
                }
                if (nRead > 0) {
                    attachment.buffer.flip();
                    if (attachment.length < (long)attachment.buffer.remaining()) {
                        attachment.buffer.limit(attachment.buffer.limit() - attachment.buffer.remaining() + (int)attachment.length);
                    }
                    attachment.length -= (long)nRead;
                } else {
                    this.failed((Throwable)new EOFException(), attachment);
                    return;
                }
            }
            ((Nio2Channel)attachment.socket.getSocket()).write(attachment.buffer, attachment.socket.getTimeout(), TimeUnit.MILLISECONDS, attachment, this);
        }

        @Override
        public void failed(Throwable exc, SendfileData attachment) {
            try {
                attachment.fchannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!Nio2Endpoint.isInline()) {
                Nio2Endpoint.this.processSocket(attachment.socket, SocketStatus.ERROR, false);
            } else {
                attachment.doneInline = true;
                attachment.error = true;
            }
        }
    };

    public Nio2Endpoint() {
        if (!JreCompat.isJre8Available()) {
            this.setCiphers("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA:!DHE");
        }
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setPollerThreadPriority(int pollerThreadPriority) {
        this.pollerThreadPriority = pollerThreadPriority;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    @Override
    public boolean getUseComet() {
        return this.useComet;
    }

    @Override
    public boolean getUseCometTimeout() {
        return this.getUseComet();
    }

    @Override
    public boolean getUsePolling() {
        return true;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public void setOomParachute(int oomParachute) {
        this.oomParachute = oomParachute;
    }

    public void setOomParachuteData(byte[] oomParachuteData) {
        this.oomParachuteData = oomParachuteData;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext c) {
        this.sslContext = c;
    }

    @Override
    public int getLocalPort() {
        AsynchronousServerSocketChannel ssc = this.serverSock;
        if (ssc == null) {
            return -1;
        }
        try {
            SocketAddress sa = ssc.getLocalAddress();
            if (sa != null && sa instanceof InetSocketAddress) {
                return ((InetSocketAddress)sa).getPort();
            }
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public String[] getCiphersUsed() {
        return this.enabledCiphers;
    }

    protected void checkParachute() {
        boolean para = this.reclaimParachute(false);
        if (!para && System.currentTimeMillis() - this.lastParachuteCheck > 10000L) {
            try {
                log.fatal((Object)oomParachuteMsg);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                System.err.println(oomParachuteMsg);
            }
            this.lastParachuteCheck = System.currentTimeMillis();
        }
    }

    protected boolean reclaimParachute(boolean force) {
        if (this.oomParachuteData != null) {
            return true;
        }
        if (this.oomParachute > 0 && (force || Runtime.getRuntime().freeMemory() > (long)(this.oomParachute * 2))) {
            this.oomParachuteData = new byte[this.oomParachute];
        }
        return this.oomParachuteData != null;
    }

    protected void releaseCaches() {
        if (this.useCaches) {
            this.nioChannels.clear();
            this.processorCache.clear();
        }
        if (this.handler != null) {
            this.handler.recycle();
        }
    }

    public int getKeepAliveCount() {
        return -1;
    }

    @Override
    public void bind() throws Exception {
        if (this.getExecutor() == null) {
            this.createExecutor();
        }
        if (this.getExecutor() instanceof ExecutorService) {
            this.threadGroup = AsynchronousChannelGroup.withThreadPool((ExecutorService)this.getExecutor());
        }
        if (!this.internalExecutor) {
            log.warn((Object)sm.getString("endpoint.nio2.exclusiveExecutor"));
        }
        this.serverSock = AsynchronousServerSocketChannel.open(this.threadGroup);
        this.socketProperties.setProperties(this.serverSock);
        InetSocketAddress addr = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.serverSock.bind(addr, this.getBacklog());
        if (this.acceptorThreadCount != 1) {
            this.acceptorThreadCount = 1;
        }
        if (this.isSSLEnabled()) {
            SSLUtil sslUtil = this.handler.getSslImplementation().getSSLUtil(this);
            this.sslContext = sslUtil.createSSLContext();
            this.sslContext.init(this.wrap(sslUtil.getKeyManagers()), sslUtil.getTrustManagers(), null);
            SSLSessionContext sessionContext = this.sslContext.getServerSessionContext();
            if (sessionContext != null) {
                sslUtil.configureSessionContext(sessionContext);
            }
            this.enabledCiphers = sslUtil.getEnableableCiphers(this.sslContext);
            this.enabledProtocols = sslUtil.getEnableableProtocols(this.sslContext);
        }
        if (this.oomParachute > 0) {
            this.reclaimParachute(true);
        }
    }

    public KeyManager[] wrap(KeyManager[] managers) {
        if (managers == null) {
            return null;
        }
        KeyManager[] result = new KeyManager[managers.length];
        for (int i = 0; i < result.length; ++i) {
            if (managers[i] instanceof X509KeyManager && this.getKeyAlias() != null) {
                String keyAlias = this.getKeyAlias();
                if ("jks".equalsIgnoreCase(this.getKeystoreType())) {
                    keyAlias = keyAlias.toLowerCase(Locale.ENGLISH);
                }
                result[i] = new NioX509KeyManager((X509KeyManager)managers[i], keyAlias);
                continue;
            }
            result[i] = managers[i];
        }
        return result;
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.allClosed = false;
            this.running = true;
            this.paused = false;
            if (this.useCaches) {
                this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
                this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            }
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.startAcceptorThreads();
            this.setAsyncTimeout(new AbstractEndpoint.AsyncTimeout());
            Thread timeoutThread = new Thread((Runnable)this.getAsyncTimeout(), this.getName() + "-AsyncTimeout");
            timeoutThread.setPriority(this.threadPriority);
            timeoutThread.setDaemon(true);
            timeoutThread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.getAsyncTimeout().stop();
            this.unlockAccept();
            this.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (SocketWrapper socket : Nio2Endpoint.this.waitingRequests) {
                        Nio2Endpoint.this.processSocket(socket, SocketStatus.TIMEOUT, false);
                    }
                    try {
                        Nio2Endpoint.this.handler.closeAll();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable((Throwable)t);
                    }
                    finally {
                        Nio2Endpoint.this.allClosed = true;
                    }
                }
            });
            if (this.useCaches) {
                this.nioChannels.clear();
                this.processorCache.clear();
            }
        }
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        this.serverSock.close();
        this.serverSock = null;
        this.sslContext = null;
        this.shutdownExecutor();
        this.releaseCaches();
    }

    @Override
    public void shutdownExecutor() {
        if (this.threadGroup != null && this.internalExecutor) {
            try {
                long timeout;
                for (timeout = this.getExecutorTerminationTimeoutMillis(); timeout > 0L && !this.allClosed; timeout -= 100L) {
                    Thread.sleep(100L);
                }
                this.threadGroup.shutdownNow();
                if (timeout > 0L) {
                    this.threadGroup.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.threadGroup.isTerminated()) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
            }
            this.threadGroup = null;
        }
        super.shutdownExecutor();
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public int getOomParachute() {
        return this.oomParachute;
    }

    public byte[] getOomParachuteData() {
        return this.oomParachuteData;
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(AsynchronousSocketChannel socket) {
        try {
            SSLEngine engine;
            Nio2Channel channel;
            this.socketProperties.setProperties(socket);
            Nio2Channel nio2Channel = channel = this.useCaches ? this.nioChannels.pop() : null;
            if (channel == null) {
                if (this.sslContext != null) {
                    engine = this.createSSLEngine();
                    int appBufferSize = engine.getSession().getApplicationBufferSize();
                    NioBufferHandler bufhandler = new NioBufferHandler(Math.max(appBufferSize, this.socketProperties.getAppReadBufSize()), Math.max(appBufferSize, this.socketProperties.getAppWriteBufSize()), this.socketProperties.getDirectBuffer());
                    channel = new SecureNio2Channel(engine, bufhandler, this);
                } else {
                    NioBufferHandler bufhandler = new NioBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                    channel = new Nio2Channel(bufhandler);
                }
            } else if (this.sslContext != null) {
                engine = this.createSSLEngine();
                ((SecureNio2Channel)channel).setSSLEngine(engine);
            }
            Nio2SocketWrapper socketWrapper = new Nio2SocketWrapper(channel);
            channel.reset(socket, socketWrapper);
            socketWrapper.setTimeout(this.getSocketProperties().getSoTimeout());
            socketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            socketWrapper.setSecure(this.isSSLEnabled());
            if (this.sslContext != null) {
                this.processSocket(socketWrapper, SocketStatus.OPEN_READ, true);
            } else {
                this.awaitBytes(socketWrapper);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            try {
                log.error((Object)"", t);
            }
            catch (Throwable tt) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            return false;
        }
        return true;
    }

    protected SSLEngine createSSLEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        if ("false".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(false);
            engine.setWantClientAuth(false);
        } else if ("true".equals(this.getClientAuth()) || "yes".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(true);
        } else if ("want".equals(this.getClientAuth())) {
            engine.setWantClientAuth(true);
        }
        engine.setUseClientMode(false);
        engine.setEnabledCipherSuites(this.enabledCiphers);
        engine.setEnabledProtocols(this.enabledProtocols);
        this.configureUseServerCipherSuitesOrder(engine);
        return engine;
    }

    protected boolean isWorkerAvailable() {
        return true;
    }

    @Override
    public void processSocket(SocketWrapper<Nio2Channel> socketWrapper, SocketStatus socketStatus, boolean dispatch) {
        this.processSocket0(socketWrapper, socketStatus, dispatch);
    }

    protected boolean processSocket0(SocketWrapper<Nio2Channel> socketWrapper, SocketStatus status, boolean dispatch) {
        try {
            SocketProcessor sc;
            this.waitingRequests.remove(socketWrapper);
            SocketProcessor socketProcessor = sc = this.useCaches ? this.processorCache.pop() : null;
            if (sc == null) {
                sc = new SocketProcessor(socketWrapper, status);
            } else {
                sc.reset(socketWrapper, status);
            }
            Executor executor = this.getExecutor();
            if (dispatch && executor != null) {
                executor.execute(sc);
            } else {
                sc.run();
            }
        }
        catch (RejectedExecutionException ree) {
            log.debug((Object)sm.getString("endpoint.executor.fail", new Object[]{socketWrapper}), (Throwable)ree);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSocket(SocketWrapper<Nio2Channel> socket, SocketStatus status) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        if (socket == null) {
                            return;
                        }
                        try {
                            if (socket.isComet() && status != null) {
                                socket.setComet(false);
                                if (status == SocketStatus.TIMEOUT) {
                                    if (this.processSocket0(socket, status, true)) {
                                        return;
                                    }
                                } else {
                                    this.processSocket0(socket, status, false);
                                }
                            }
                        }
                        catch (Throwable e) {
                            ExceptionUtils.handleThrowable((Throwable)e);
                            if (!log.isDebugEnabled()) break block18;
                            log.error((Object)"", e);
                        }
                    }
                    try {
                        this.handler.release(socket);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable((Throwable)e);
                        if (!log.isDebugEnabled()) break block19;
                        log.error((Object)"", e);
                    }
                }
                try {
                    if (socket.getSocket() == null) break block20;
                    Nio2Channel e = socket.getSocket();
                    synchronized (e) {
                        if (socket.getSocket() != null && socket.getSocket().isOpen()) {
                            this.countDownConnection();
                            socket.getSocket().close(true);
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block20;
                    log.debug((Object)sm.getString("endpoint.debug.socketCloseFail"), (Throwable)e);
                }
            }
            try {
                Nio2SocketWrapper nio2Socket = (Nio2SocketWrapper)socket;
                if (nio2Socket.getSendfileData() != null && nio2Socket.getSendfileData().fchannel != null && nio2Socket.getSendfileData().fchannel.isOpen()) {
                    nio2Socket.getSendfileData().fchannel.close();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                if (!log.isDebugEnabled()) break block21;
                log.error((Object)"", e);
            }
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void closeSocket(AsynchronousSocketChannel socket) {
        block2: {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"", (Throwable)ioe);
            }
        }
    }

    public void addTimeout(SocketWrapper<Nio2Channel> socket) {
        this.waitingRequests.add(socket);
    }

    public boolean removeTimeout(SocketWrapper<Nio2Channel> socket) {
        return this.waitingRequests.remove(socket);
    }

    public static void startInline() {
        inlineCompletion.set(Boolean.TRUE);
    }

    public static void endInline() {
        inlineCompletion.set(Boolean.FALSE);
    }

    public static boolean isInline() {
        Boolean flag = inlineCompletion.get();
        if (flag == null) {
            return false;
        }
        return flag;
    }

    public void awaitBytes(SocketWrapper<Nio2Channel> socket) {
        if (socket == null || socket.getSocket() == null) {
            return;
        }
        ByteBuffer byteBuffer = socket.getSocket().getBufHandler().getReadBuffer();
        byteBuffer.clear();
        socket.getSocket().read(byteBuffer, socket.getTimeout(), TimeUnit.MILLISECONDS, socket, this.awaitBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendfileState processSendfile(Nio2SocketWrapper socket) {
        SendfileData data = socket.getSendfileData();
        if (data.fchannel == null || !data.fchannel.isOpen()) {
            Path path = new File(data.fileName).toPath();
            try {
                data.fchannel = FileChannel.open(path, StandardOpenOption.READ).position(data.pos);
            }
            catch (IOException e) {
                return SendfileState.ERROR;
            }
        }
        ByteBuffer buffer = ((Nio2Channel)socket.getSocket()).getBufHandler().getWriteBuffer();
        buffer.clear();
        int nRead = -1;
        try {
            nRead = data.fchannel.read(buffer);
        }
        catch (IOException e1) {
            return SendfileState.ERROR;
        }
        if (nRead >= 0) {
            buffer.flip();
            data.socket = socket;
            data.buffer = buffer;
            data.length -= (long)nRead;
            Nio2Endpoint.startInline();
            try {
                ((Nio2Channel)socket.getSocket()).write(buffer, socket.getTimeout(), TimeUnit.MILLISECONDS, data, this.sendfile);
            }
            finally {
                Nio2Endpoint.endInline();
            }
            if (data.doneInline) {
                if (data.error) {
                    return SendfileState.ERROR;
                }
                return SendfileState.DONE;
            }
            return SendfileState.PENDING;
        }
        return SendfileState.ERROR;
    }

    static /* synthetic */ byte[] access$1102(Nio2Endpoint x0, byte[] x1) {
        x0.oomParachuteData = x1;
        return x1;
    }

    public static class SendfileData {
        public String fileName;
        public FileChannel fchannel;
        public long pos;
        public long length;
        public boolean keepAlive;
        private Nio2SocketWrapper socket;
        private ByteBuffer buffer;
        private boolean doneInline = false;
        private boolean error = false;
    }

    protected class SocketProcessor
    implements Runnable {
        private SocketWrapper<Nio2Channel> socket = null;
        private SocketStatus status = null;

        public SocketProcessor(SocketWrapper<Nio2Channel> socket, SocketStatus status) {
            this.reset(socket, status);
        }

        public void reset(SocketWrapper<Nio2Channel> socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.socket.isUpgraded() && SocketStatus.OPEN_WRITE == this.status) {
                Object object = this.socket.getWriteThreadLock();
                synchronized (object) {
                    this.doRun();
                }
            }
            SocketWrapper<Nio2Channel> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                this.doRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            boolean launch = false;
            try {
                int handshake;
                block39: {
                    handshake = -1;
                    try {
                        if (this.socket.getSocket() != null) {
                            if (this.socket.getSocket().isHandshakeComplete() || this.status == SocketStatus.STOP) {
                                handshake = 0;
                            } else {
                                handshake = this.socket.getSocket().handshake();
                                this.status = SocketStatus.OPEN_READ;
                            }
                        }
                    }
                    catch (IOException x) {
                        handshake = -1;
                        if (!log.isDebugEnabled()) break block39;
                        log.debug((Object)AbstractEndpoint.sm.getString("endpoint.err.handshake"), (Throwable)x);
                    }
                }
                if (handshake == 0) {
                    AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                    state = this.status == null ? Nio2Endpoint.this.handler.process(this.socket, SocketStatus.OPEN_READ) : Nio2Endpoint.this.handler.process(this.socket, this.status);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.socket.setComet(false);
                        Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.ERROR);
                        if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                            Nio2Endpoint.this.nioChannels.push(this.socket.getSocket());
                        }
                    } else if (state == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                        this.socket.setKeptAlive(true);
                        this.socket.access();
                        launch = true;
                    }
                } else if (handshake == -1) {
                    Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.DISCONNECT);
                    if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                        Nio2Endpoint.this.nioChannels.push(this.socket.getSocket());
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    Nio2Endpoint.access$1102(Nio2Endpoint.this, null);
                    log.error((Object)"", (Throwable)oom);
                    Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.ERROR);
                    Nio2Endpoint.this.releaseCaches();
                }
                catch (Throwable oomt) {
                    try {
                        System.err.println(Nio2Endpoint.oomParachuteMsg);
                        oomt.printStackTrace();
                    }
                    catch (Throwable letsHopeWeDontGetHere) {
                        ExceptionUtils.handleThrowable((Throwable)letsHopeWeDontGetHere);
                    }
                }
            }
            catch (VirtualMachineError vme) {
                ExceptionUtils.handleThrowable((Throwable)vme);
            }
            catch (Throwable t) {
                log.error((Object)AbstractEndpoint.sm.getString("endpoint.processing.fail"), t);
                if (this.socket != null) {
                    Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.ERROR);
                }
            }
            finally {
                block41: {
                    if (launch) {
                        try {
                            Nio2Endpoint.this.getExecutor().execute(new SocketProcessor(this.socket, SocketStatus.OPEN_READ));
                        }
                        catch (NullPointerException npe) {
                            if (!Nio2Endpoint.this.running) break block41;
                            log.error((Object)AbstractEndpoint.sm.getString("endpoint.launch.fail"), (Throwable)npe);
                        }
                    }
                }
                this.socket = null;
                this.status = null;
                if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                    Nio2Endpoint.this.processorCache.push(this);
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Nio2Channel> var1, SocketStatus var2);

        public void release(SocketWrapper<Nio2Channel> var1);

        public void closeAll();

        public SSLImplementation getSslImplementation();
    }

    public static class NioBufferHandler
    implements SecureNio2Channel.ApplicationBufferHandler {
        private ByteBuffer readbuf = null;
        private ByteBuffer writebuf = null;

        public NioBufferHandler(int readsize, int writesize, boolean direct) {
            if (direct) {
                this.readbuf = ByteBuffer.allocateDirect(readsize);
                this.writebuf = ByteBuffer.allocateDirect(writesize);
            } else {
                this.readbuf = ByteBuffer.allocate(readsize);
                this.writebuf = ByteBuffer.allocate(writesize);
            }
        }

        @Override
        public ByteBuffer getReadBuffer() {
            return this.readbuf;
        }

        @Override
        public ByteBuffer getWriteBuffer() {
            return this.writebuf;
        }
    }

    public static class Nio2SocketWrapper
    extends SocketWrapper<Nio2Channel> {
        private SendfileData sendfileData = null;
        private boolean upgradeInit = false;

        public Nio2SocketWrapper(Nio2Channel channel) {
            super(channel);
        }

        @Override
        public long getTimeout() {
            long timeout = super.getTimeout();
            return timeout > 0L ? timeout : Long.MAX_VALUE;
        }

        @Override
        public void setUpgraded(boolean upgraded) {
            if (upgraded && !this.isUpgraded()) {
                this.upgradeInit = true;
            }
            super.setUpgraded(upgraded);
        }

        public boolean isUpgradeInit() {
            boolean value = this.upgradeInit;
            this.upgradeInit = false;
            return value;
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (Nio2Endpoint.this.running) {
                while (Nio2Endpoint.this.paused && Nio2Endpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!Nio2Endpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    Nio2Endpoint.this.countUpOrAwaitConnection();
                    AsynchronousSocketChannel socket = null;
                    try {
                        socket = Nio2Endpoint.this.serverSock.accept().get();
                    }
                    catch (Exception e) {
                        Nio2Endpoint.this.countDownConnection();
                        if (!Nio2Endpoint.this.running) break;
                        errorDelay = Nio2Endpoint.this.handleExceptionWithDelay(errorDelay);
                        throw e;
                    }
                    errorDelay = 0;
                    if (Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                        if (Nio2Endpoint.this.setSocketOptions(socket)) continue;
                        Nio2Endpoint.this.countDownConnection();
                        Nio2Endpoint.this.closeSocket(socket);
                        continue;
                    }
                    Nio2Endpoint.this.countDownConnection();
                    Nio2Endpoint.this.closeSocket(socket);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), t);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

