/**********************************************
 * Copyright (C) 2010 Lukas Laag
 * This file is part of lib-gwt-svg.
 * 
 * libgwtsvg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgwtsvg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgwtsvg.  If not, see http://www.gnu.org/licenses/
 **********************************************/
/*
 * Copyright (c) 2004 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.vectomatic.dom.svg.impl;

import org.vectomatic.dom.svg.OMSVGAnimatedNumber;

/**
 * The {@link org.vectomatic.dom.svg.impl.SVGFEDistantLightElement} interface
 * corresponds to the <a href='http://www.w3.org/TR/SVG11/filters.html#feDistantLightElement'
 * title='feDistantLight element specification'>feDistantLight</a> element.
 */
public class SVGFEDistantLightElement extends SVGElement {
  protected SVGFEDistantLightElement() {
  }

  // Implementation of the svg::SVGFEDistantLightElement W3C IDL interface
  /**
   * Corresponds to attribute {@link org.vectomatic.dom.svg.impl.SVGFEDistantLightElement#getAzimuth()}
   * on the given <a href='http://www.w3.org/TR/SVG11/filters.html#feDistantLightElement'
   * title='feDistantLight element specification'>feDistantLight</a> element.
   */
  public final native OMSVGAnimatedNumber getAzimuth() /*-{
    return this.azimuth;
  }-*/;
  /**
   * Corresponds to attribute {@link org.vectomatic.dom.svg.impl.SVGFEDistantLightElement#getElevation()}
   * on the given <a href='http://www.w3.org/TR/SVG11/filters.html#feDistantLightElement'
   * title='feDistantLight element specification'>feDistantLight</a> element.
   */
  public final native OMSVGAnimatedNumber getElevation() /*-{
    return this.elevation;
  }-*/;

}
