/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 23:17:53 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9792 $
//  type=root

/**
 * Localized names for the "or" locale.
 */
public class LocalizedNamesImpl_or extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BQ",
        "CP",
        "CW",
        "DG",
        "EA",
        "IC",
        "SX",
        "TA",
        "XK",
        "AT",
        "AU",
        "CI",
        "IM",
        "IS",
        "QO",
        "AI",
        "AO",
        "AZ",
        "AG",
        "AD",
        "AF",
        "AS",
        "AW",
        "AR",
        "AQ",
        "AM",
        "DZ",
        "AL",
        "AX",
        "IE",
        "GQ",
        "EC",
        "EG",
        "IT",
        "ID",
        "ET",
        "IQ",
        "IR",
        "ER",
        "IL",
        "UG",
        "UZ",
        "KP",
        "MP",
        "UY",
        "SV",
        "EE",
        "OM",
        "CD",
        "CG",
        "QA",
        "KZ",
        "CA",
        "CM",
        "KM",
        "KH",
        "KI",
        "KG",
        "KW",
        "CK",
        "KE",
        "CV",
        "KY",
        "CC",
        "CO",
        "CR",
        "HR",
        "CU",
        "CX",
        "GA",
        "GM",
        "GU",
        "GY",
        "GW",
        "GT",
        "GN",
        "GG",
        "GP",
        "GL",
        "GR",
        "GD",
        "GH",
        "TD",
        "CN",
        "CL",
        "CZ",
        "GE",
        "DE",
        "JE",
        "JP",
        "JM",
        "ZM",
        "GI",
        "ZW",
        "JO",
        "TV",
        "TK",
        "TG",
        "TO",
        "DJ",
        "DK",
        "DO",
        "DM",
        "TW",
        "TJ",
        "TZ",
        "TN",
        "TM",
        "TC",
        "TR",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NF",
        "NO",
        "NE",
        "NG",
        "NR",
        "NA",
        "NU",
        "NI",
        "NC",
        "NL",
        "AN",
        "NP",
        "NZ",
        "PG",
        "PT",
        "EH",
        "PK",
        "PA",
        "PY",
        "PW",
        "PS",
        "PN",
        "PR",
        "TL",
        "PE",
        "PL",
        "TF",
        "FK",
        "FO",
        "FJ",
        "FI",
        "PH",
        "FR",
        "GF",
        "PF",
        "BM",
        "BD",
        "BB",
        "BS",
        "BH",
        "BI",
        "BF",
        "BG",
        "BJ",
        "BE",
        "BY",
        "BZ",
        "BW",
        "BO",
        "BA",
        "BV",
        "BR",
        "VG",
        "IO",
        "GB",
        "BN",
        "VA",
        "VU",
        "IN",
        "VN",
        "BT",
        "VE",
        "MN",
        "ME",
        "MS",
        "CF",
        "FM",
        "MR",
        "MO",
        "MG",
        "MQ",
        "MH",
        "MD",
        "MY",
        "MT",
        "MW",
        "MV",
        "ML",
        "MK",
        "YT",
        "MM",
        "MX",
        "MZ",
        "MC",
        "MA",
        "MU",
        "US",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LR",
        "LB",
        "LS",
        "LK",
        "AE",
        "RS",
        "CY",
        "SA",
        "ST",
        "SM",
        "WS",
        "SJ",
        "SL",
        "SG",
        "SY",
        "SD",
        "SR",
        "SC",
        "KN",
        "PM",
        "BL",
        "VC",
        "MF",
        "LC",
        "SH",
        "SN",
        "SO",
        "SB",
        "ES",
        "SZ",
        "CH",
        "SK",
        "SI",
        "SE",
        "HK",
        "HU",
        "HT",
        "HM",
        "HN",
        "VI",
        "UA",
        "UM",
        "EU",
        "YE",
        "WF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ବିଶ୍ବ");
    namesMap.put("002", "ଆଫ୍ରିକା");
    namesMap.put("003", "ଉତ୍ତର ଆମେରିକା");
    namesMap.put("005", "ଦକ୍ଷିଣ ଆମେରିକା");
    namesMap.put("009", "ଓସୋନିଆନ୍");
    namesMap.put("011", "ପଶ୍ଚିମ ଆଫ୍ରିକା");
    namesMap.put("013", "ମଧ୍ୟ ଆମେରିକା");
    namesMap.put("014", "ପୂର୍ବ ଆଫ୍ରିକା");
    namesMap.put("015", "ଉତ୍ତର ଆଫ୍ରିକା");
    namesMap.put("017", "ମଧ୍ୟ ଆଫ୍ରିକା");
    namesMap.put("018", "ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା");
    namesMap.put("019", "ଆମେରିକାସ୍");
    namesMap.put("021", "ଉତ୍ତରସ୍ଥ ଆମେରିକା");
    namesMap.put("029", "କାରିବିଆନ୍");
    namesMap.put("030", "ପୂର୍ବ ଏସିଆ");
    namesMap.put("034", "ଦକ୍ଷିଣ ଏସିଆ");
    namesMap.put("035", "ଦକ୍ଷିଣ-ପୂର୍ବ ଏସିଆ");
    namesMap.put("039", "ଦକ୍ଷିଣ ୟୁରୋପ୍");
    namesMap.put("053", "ଅଷ୍ଟ୍ରେଲିଆ ଏବଂ ନ୍ୟୁଜିଲ୍ୟାଣ୍ଡ");
    namesMap.put("054", "ମେଲାନେସିଆ");
    namesMap.put("057", "ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ");
    namesMap.put("061", "ପଲିନେସିଆ");
    namesMap.put("142", "ଏସିଆ");
    namesMap.put("143", "ମଧ୍ୟ ଏସିଆ");
    namesMap.put("145", "ପଶ୍ଚିମ ଏସିଆ");
    namesMap.put("150", "ୟୁରୋପ୍");
    namesMap.put("151", "ପୂର୍ବ ୟୁରୋପ୍");
    namesMap.put("154", "ଉତ୍ତର ୟୁରୋପ୍");
    namesMap.put("155", "ପଶ୍ଚିମ ୟୁରୋପ୍");
    namesMap.put("419", "ଲାଟିନ୍ ଆମେରିକା ଏବଂ କାରିବିଆନ୍");
    namesMap.put("AD", "ଆଣ୍ଡୋରା");
    namesMap.put("AE", "ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍");
    namesMap.put("AF", "ଆଫାଗାନିସ୍ତାନ୍");
    namesMap.put("AG", "ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା");
    namesMap.put("AI", "ଆଙ୍ଗୁଇଲ୍ଲା");
    namesMap.put("AL", "ଆଲବାନିଆ");
    namesMap.put("AM", "ଆର୍ମେନିଆ");
    namesMap.put("AN", "ନେଦରଲ୍ୟାଣ୍ଡସ୍ ଆଣ୍ଟିଲିଜ୍");
    namesMap.put("AO", "ଆଙ୍ଗୋଲା");
    namesMap.put("AQ", "ଆର୍ଣ୍ଟକଟିକା");
    namesMap.put("AR", "ଆର୍ଜେଣ୍ଟିନା");
    namesMap.put("AS", "ଆମେରିକାନ୍ ସାମୋଆ");
    namesMap.put("AT", "ଅଷ୍ଟ୍ରିଆ");
    namesMap.put("AU", "ଅଷ୍ଟ୍ରେଲିଆ");
    namesMap.put("AW", "ଆରୁବା");
    namesMap.put("AX", "ଆଲାଣ୍ଡ ଆଇସଲ୍ୟାଣ୍ଡ");
    namesMap.put("AZ", "ଆଜେରବାଇଜାନ୍");
    namesMap.put("BA", "ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା");
    namesMap.put("BB", "ବାରବାଡୋସ୍");
    namesMap.put("BD", "ବାଙ୍ଗଲାଦେଶ୍");
    namesMap.put("BE", "ବେଲଜିୟମ୍");
    namesMap.put("BF", "ବୁର୍କିନୋ ଫାସୋ");
    namesMap.put("BG", "ବୁଲଗେରିଆ");
    namesMap.put("BH", "ବାହାରିନ୍");
    namesMap.put("BI", "ବୁରୁନ୍ଦି");
    namesMap.put("BJ", "ବେନିନ୍");
    namesMap.put("BL", "ସେଣ୍ଟ ବାର୍ଥେଲେମି");
    namesMap.put("BM", "ବରମୁଡା");
    namesMap.put("BN", "ବ୍ରୁନେଇ");
    namesMap.put("BO", "ବୋଲଭିଆ");
    namesMap.put("BR", "ବ୍ରାଜିଲ୍");
    namesMap.put("BS", "ବାହାମାସ୍");
    namesMap.put("BT", "ଭୁଟାନ୍");
    namesMap.put("BV", "ବୌଭେଟ୍ ଆଇସଲ୍ୟାଣ୍ଡ");
    namesMap.put("BW", "ବୋଟସ୍ବାନ୍");
    namesMap.put("BY", "ବେଲାରୁଷ୍");
    namesMap.put("BZ", "ବେଲିଜ୍");
    namesMap.put("CA", "କାନାଡା");
    namesMap.put("CC", "କୋକୋସ୍ ଆଇସଲ୍ୟାଣ୍ଡ");
    namesMap.put("CD", "କଙ୍ଗୋ-କିନସାସା");
    namesMap.put("CF", "ମଧ୍ୟ ଆଫ୍ରିକୀୟ ଗଣତନ୍ତ୍ର");
    namesMap.put("CG", "କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ");
    namesMap.put("CH", "ସ୍ବିଜରଲ୍ୟାଣ୍ଡ");
    namesMap.put("CI", "ଆଇବରୀ କୋଷ୍ଟ");
    namesMap.put("CK", "କୁକ୍ ଆଇସଲ୍ୟାଣ୍ଡ");
    namesMap.put("CL", "ଚିଲ୍ଲୀ");
    namesMap.put("CM", "କାମେରୁନ୍");
    namesMap.put("CN", "ଚିନ୍");
    namesMap.put("CO", "କୋଲମ୍ବିଆ");
    namesMap.put("CR", "କୋଷ୍ଟା ରିକା");
    namesMap.put("CU", "କ୍ୱିବା");
    namesMap.put("CV", "କେପ୍ ଭର୍ଦେ");
    namesMap.put("CX", "ଖ୍ରୀଷ୍ଟମାସ ଆଇଲ୍ୟାଣ୍ଡ");
    namesMap.put("CY", "ସାଇପ୍ରସ୍");
    namesMap.put("CZ", "ଚେକ୍ ସାଧାରଣତନ୍ତ୍ର");
    namesMap.put("DE", "ଜର୍ମାନୀ");
    namesMap.put("DJ", "ଡିବୌଟି");
    namesMap.put("DK", "ଡେନମାର୍କ");
    namesMap.put("DM", "ଡୋମିନାକା");
    namesMap.put("DO", "ଡୋମିନକାନ୍ ପ୍ରଜାତନ୍ତ୍ର");
    namesMap.put("DZ", "ଆଲଜେରିଆ");
    namesMap.put("EC", "ଇକ୍ୱାଡୋର୍");
    namesMap.put("EE", "ଏସ୍ତୋନିଆ");
    namesMap.put("EG", "ଇଜିପ୍ଟ");
    namesMap.put("EH", "ପଶ୍ଚିମ ସାହାରା");
    namesMap.put("ER", "ଇରିଟ୍ରିୟା");
    namesMap.put("ES", "ସ୍ପେନ୍");
    namesMap.put("ET", "ଇଥିଓପିଆ");
    namesMap.put("EU", "ୟୁରୋପିଆନ୍ ୟୁନିଅନ୍");
    namesMap.put("FI", "ଫିନଲ୍ୟାଣ୍ଡ");
    namesMap.put("FJ", "ଫିଜି");
    namesMap.put("FK", "ଫଲ୍କଲ୍ୟାଣ୍ଡ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("FM", "ମାଇକ୍ରୋନେସିଆ");
    namesMap.put("FO", "ଫାରୋଇ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("FR", "ଫ୍ରାନ୍ସ");
    namesMap.put("GA", "ଗାବୋନ୍");
    namesMap.put("GB", "ବ୍ରିଟେନ୍");
    namesMap.put("GD", "ଗ୍ରେନାଡା");
    namesMap.put("GE", "ଜର୍ଜିଆ");
    namesMap.put("GF", "ଫ୍ରେଞ୍ଚ ଗୁଇନା");
    namesMap.put("GG", "ଗୁଏରନେସି");
    namesMap.put("GH", "ଘାନା");
    namesMap.put("GI", "ଜିବ୍ରାଲ୍ଟର୍");
    namesMap.put("GL", "ଗ୍ରୀନଲ୍ୟାଣ୍ଡ");
    namesMap.put("GM", "ଗାମ୍ବିଆ");
    namesMap.put("GN", "ଗୁଏନେଆ");
    namesMap.put("GP", "ଗୌଡେଲୌପେ");
    namesMap.put("GQ", "ଇକ୍ବାଟେରିଆଲ୍ ଗୁଇନିଆ");
    namesMap.put("GR", "ଗ୍ରୀସ୍");
    namesMap.put("GS", "ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("GT", "ଗୁଏତମାଲା");
    namesMap.put("GU", "ଗୁଆମ୍");
    namesMap.put("GW", "ଗୁଇନିଆ-ବିସାଉ");
    namesMap.put("GY", "ଗୁଇନା");
    namesMap.put("HK", "ହଂକଂ ବିଶେଷ ପ୍ରଶାସନିକ କ୍ଷେତ୍ର ଚୀନ୍");
    namesMap.put("HM", "ହାର୍ଡ ଦ୍ବୀପପୁଞ୍ଜ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("HN", "ହୋଣ୍ଡାରୁସ୍");
    namesMap.put("HR", "କ୍ରୋଆଟିଆ");
    namesMap.put("HT", "ହାଇତି");
    namesMap.put("HU", "ହଙ୍ଗେରୀ");
    namesMap.put("ID", "ଇଣ୍ଡୋନେସିଆ");
    namesMap.put("IE", "ଆୟରଲ୍ୟାଣ୍ଡ");
    namesMap.put("IL", "ଇସ୍ରାଏଲ୍");
    namesMap.put("IM", "ଆଇଲ୍ ଅଫ୍ ମୈନ୍");
    namesMap.put("IN", "ଭାରତ");
    namesMap.put("IO", "ବ୍ରିଟିଶ୍ ଭାରତୀୟ ସାମୁଦ୍ରିକ କ୍ଷେତ୍ର");
    namesMap.put("IQ", "ଇରାକ୍");
    namesMap.put("IR", "ଇରାନ୍");
    namesMap.put("IS", "ଆଇସଲ୍ୟାଣ୍ଡ");
    namesMap.put("IT", "ଇଟାଲୀ");
    namesMap.put("JE", "ଜର୍ସି");
    namesMap.put("JM", "ଜାମାଇକା");
    namesMap.put("JO", "ଜୋର୍ଡାନ୍");
    namesMap.put("JP", "ଜାପାନ୍");
    namesMap.put("KE", "କେନିୟା");
    namesMap.put("KG", "କିର୍ଗିଜିସ୍ଥାନ");
    namesMap.put("KH", "କାମ୍ବୋଡିଆ");
    namesMap.put("KI", "କିରିବାଟୀ");
    namesMap.put("KM", "କାମୋରସ୍");
    namesMap.put("KN", "ସେଣ୍ଟ କିଟସ୍ ଏଣ୍ଡ ନେଭିସ୍");
    namesMap.put("KP", "ଉତ୍ତର କୋରିଆ");
    namesMap.put("KR", "ଦକ୍ଷିଣ କୋରିଆ");
    namesMap.put("KW", "କୁଏତ୍");
    namesMap.put("KY", "କେମ୍ୟାନ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("KZ", "କାଜାକାସ୍ଥାନ୍");
    namesMap.put("LA", "ଲାଓସ୍");
    namesMap.put("LB", "ଲେବାନନ୍");
    namesMap.put("LC", "ସେଣ୍ଟ ଲୁସିଆ");
    namesMap.put("LI", "ଲିଚେସ୍ତିଆନାନ୍");
    namesMap.put("LK", "ଶ୍ରୀଲଙ୍କା");
    namesMap.put("LR", "ଲିବେରିଆ");
    namesMap.put("LS", "ଲେସୋଥୋ");
    namesMap.put("LT", "ଲିଥାଆନିଆ");
    namesMap.put("LU", "ଲକ୍ସେମବର୍ଗ");
    namesMap.put("LV", "ଲାଟଭିଆ");
    namesMap.put("LY", "ଲିବିଆ");
    namesMap.put("MA", "ମୋରୋକ୍କୋ");
    namesMap.put("MC", "ମୋନାକୋ");
    namesMap.put("MD", "ମାଲଡୋଭା");
    namesMap.put("ME", "ମଣ୍ଟେଗ୍ରୋ");
    namesMap.put("MF", "ସେଣ୍ଟ ମାର୍ଟିନ୍");
    namesMap.put("MG", "ମାଡାଗାସ୍କର୍");
    namesMap.put("MH", "ମାର୍ଶଲ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("MK", "ମାସେଡୋନିଆ");
    namesMap.put("ML", "ମାଳୀ");
    namesMap.put("MM", "ମିୟାମାର୍");
    namesMap.put("MN", "ମଙ୍ଗୋଲିଆ");
    namesMap.put("MO", "ମାକାଉ SAR ଚିନ୍");
    namesMap.put("MP", "ଉତ୍ତର ମାରିଆନା ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("MQ", "ମାର୍ଟିନିକ୍ୟୁ");
    namesMap.put("MR", "ମାଉରିଟାନିଆ");
    namesMap.put("MS", "ମଣ୍ଟେସେରାଟ୍");
    namesMap.put("MT", "ମାଲ୍ଟା");
    namesMap.put("MU", "ମୌରିସସ୍");
    namesMap.put("MV", "ମାଳଦ୍ବୀପ");
    namesMap.put("MW", "ମାଲୱି");
    namesMap.put("MX", "ମେକ୍ସିକୋ");
    namesMap.put("MY", "ମାଲେସିଆ");
    namesMap.put("MZ", "ମୋଜାମ୍ବିକ୍ୟୁ");
    namesMap.put("NA", "ନାମ୍ବିଆ");
    namesMap.put("NC", "ନୂତନ କାଲେଡୋନିଆ");
    namesMap.put("NE", "ନାଇଜର୍");
    namesMap.put("NF", "ନରଫ୍ଲକ୍ ଦ୍ବୀପ");
    namesMap.put("NG", "ନାଇଜେରିଆ");
    namesMap.put("NI", "ନିକାରାଗୁଆ");
    namesMap.put("NL", "ନେଦରଲ୍ୟାଣ୍ଡ");
    namesMap.put("NO", "ନରୱେ");
    namesMap.put("NP", "ନେପାଳ");
    namesMap.put("NR", "ନାଉରୁ");
    namesMap.put("NU", "ନିଉ");
    namesMap.put("NZ", "ନ୍ୟୁଜିଲାଣ୍ଡ");
    namesMap.put("OM", "ଓମାନ୍");
    namesMap.put("PA", "ପାନାମା");
    namesMap.put("PE", "ପେରୁ");
    namesMap.put("PF", "ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ");
    namesMap.put("PG", "ପପୁଆ ନ୍ୟୁ ଗୁଏନିଆ");
    namesMap.put("PH", "ଫିଲିପାଇନସ୍");
    namesMap.put("PK", "ପାକିସ୍ତାନ");
    namesMap.put("PL", "ପୋଲାଣ୍ଡ");
    namesMap.put("PM", "ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ବାଲୋନ୍");
    namesMap.put("PN", "ପିଟକାଇରିନ୍");
    namesMap.put("PR", "ପୁଏର୍ତ୍ତୋ ରିକୋ");
    namesMap.put("PS", "ପାଲେସ୍ତେନିଆ");
    namesMap.put("PT", "ପର୍ତ୍ତୁଗାଲ୍");
    namesMap.put("PW", "ପାଲାଉ");
    namesMap.put("PY", "ପାରାଗୁଏ");
    namesMap.put("QA", "କତାର୍");
    namesMap.put("QO", "ଆଉଟଲେଇଂ ଓସେନିଆ");
    namesMap.put("RE", "ରିୟୁନିଅନ୍");
    namesMap.put("RO", "ରୋମାନିଆ");
    namesMap.put("RS", "ସର୍ବିଆ");
    namesMap.put("RU", "ରୁଷିଆ");
    namesMap.put("RW", "ରାୱାଣ୍ଡା");
    namesMap.put("SA", "ସାଉଦି ଆରବିଆ");
    namesMap.put("SB", "ସୋଲୋମନ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("SC", "ସେଚେଲସ୍");
    namesMap.put("SD", "ସୁଦାନ୍");
    namesMap.put("SE", "ସ୍ୱେଡେନ୍");
    namesMap.put("SG", "ସିଙ୍ଗାପୁର୍");
    namesMap.put("SH", "ସେଣ୍ଟ ହେଲେନା");
    namesMap.put("SI", "ସ୍ଲୋଭେନିଆ");
    namesMap.put("SJ", "ସାଲ୍ଭାର୍ଡ ଏବଂ ଜାନ୍ ମାୟୋନ୍");
    namesMap.put("SK", "ସ୍ଲୋଭାକିଆ");
    namesMap.put("SL", "ସିଓରା ଲିଓନ୍");
    namesMap.put("SM", "ସାନ୍ ମାରିନୋ");
    namesMap.put("SN", "ସେନେଗାଲ୍");
    namesMap.put("SO", "ସୋମାଲିଆ");
    namesMap.put("SR", "ସୁରିନାମ");
    namesMap.put("SS", "ଦକ୍ଷିନ ସୁଦାନ");
    namesMap.put("ST", "ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି");
    namesMap.put("SV", "ଏଲ୍ ସାଲଭାଡୋର୍");
    namesMap.put("SY", "ସିରିଆ");
    namesMap.put("SZ", "ସ୍ବାଜିଲାଣ୍ଡ");
    namesMap.put("TC", "ତୁର୍କସ୍ ଏବଂ ସାଇକସ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("TD", "ଚାଦ୍");
    namesMap.put("TF", "ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର");
    namesMap.put("TG", "ଟୋଗୋ");
    namesMap.put("TH", "ଥାଇଲାଣ୍ଡ");
    namesMap.put("TJ", "ତାଜିକିସ୍ଥାନ୍");
    namesMap.put("TK", "ଟୋକେଲାଉ");
    namesMap.put("TL", "ପୁର୍ବ ତିମୋର୍");
    namesMap.put("TM", "ତୁର୍କମେନିସ୍ତାନ୍");
    namesMap.put("TN", "ତୁନିସିଆ");
    namesMap.put("TO", "ଟୋଙ୍ଗା");
    namesMap.put("TR", "ତୁର୍କୀ");
    namesMap.put("TT", "ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ");
    namesMap.put("TV", "ଟୁଭାଲୁ");
    namesMap.put("TW", "ତାଇୱାନ୍");
    namesMap.put("TZ", "ତାଞ୍ଜାନିଆ");
    namesMap.put("UA", "ୟୁକ୍ରାଇନ୍");
    namesMap.put("UG", "ଉଗାଣ୍ଡା");
    namesMap.put("UM", "ୟୁନାଇଟେଡ୍ ଷ୍ଟେଟସ୍ ମାଇନର୍ ଆଉଟଲେଇଂ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("US", "ଯୁକ୍ତ ରାଷ୍ଟ୍ର ଆମେରିକା");
    namesMap.put("UY", "ଉରୁଗୁଏ");
    namesMap.put("UZ", "ଉଜବେକିସ୍ଥାନ୍");
    namesMap.put("VA", "ଭାଟିକାନ୍");
    namesMap.put("VC", "ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଦି ଗ୍ରେନାଡିସ୍");
    namesMap.put("VE", "ଭେନଜୁଏଲା");
    namesMap.put("VG", "ବ୍ରିଟିଶ୍ ଭର୍ଜିନ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("VI", "ୟୁଏସ୍ ଭର୍ଜିନ୍ ଦ୍ବୀପପୁଞ୍ଜ");
    namesMap.put("VN", "ଭିଏତନାମ୍");
    namesMap.put("VU", "ଭାନୁଆତୁ");
    namesMap.put("WF", "ୱାଲିସ୍ ଏବଂ ଫୁତୁନା");
    namesMap.put("WS", "ସାମୋଆ");
    namesMap.put("YE", "ୟେମେନ୍");
    namesMap.put("YT", "ମାୟୋଟେ");
    namesMap.put("ZA", "ଦକ୍ଷିଣ ଆଫ୍ରିକା");
    namesMap.put("ZM", "ଜାମ୍ବିଆ");
    namesMap.put("ZW", "ଜିମ୍ବାୱେ");
    namesMap.put("ZZ", "ଅଜଣା କିମ୍ବା ଅବୈଧ ପ୍ରଦେଶ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ବିଶ୍ବ",
        "002": "ଆଫ୍ରିକା",
        "003": "ଉତ୍ତର ଆମେରିକା",
        "005": "ଦକ୍ଷିଣ ଆମେରିକା",
        "009": "ଓସୋନିଆନ୍",
        "011": "ପଶ୍ଚିମ ଆଫ୍ରିକା",
        "013": "ମଧ୍ୟ ଆମେରିକା",
        "014": "ପୂର୍ବ ଆଫ୍ରିକା",
        "015": "ଉତ୍ତର ଆଫ୍ରିକା",
        "017": "ମଧ୍ୟ ଆଫ୍ରିକା",
        "018": "ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା",
        "019": "ଆମେରିକାସ୍",
        "021": "ଉତ୍ତରସ୍ଥ ଆମେରିକା",
        "029": "କାରିବିଆନ୍",
        "030": "ପୂର୍ବ ଏସିଆ",
        "034": "ଦକ୍ଷିଣ ଏସିଆ",
        "035": "ଦକ୍ଷିଣ-ପୂର୍ବ ଏସିଆ",
        "039": "ଦକ୍ଷିଣ ୟୁରୋପ୍",
        "053": "ଅଷ୍ଟ୍ରେଲିଆ ଏବଂ ନ୍ୟୁଜିଲ୍ୟାଣ୍ଡ",
        "054": "ମେଲାନେସିଆ",
        "057": "ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ",
        "061": "ପଲିନେସିଆ",
        "142": "ଏସିଆ",
        "143": "ମଧ୍ୟ ଏସିଆ",
        "145": "ପଶ୍ଚିମ ଏସିଆ",
        "150": "ୟୁରୋପ୍",
        "151": "ପୂର୍ବ ୟୁରୋପ୍",
        "154": "ଉତ୍ତର ୟୁରୋପ୍",
        "155": "ପଶ୍ଚିମ ୟୁରୋପ୍",
        "419": "ଲାଟିନ୍ ଆମେରିକା ଏବଂ କାରିବିଆନ୍",
        "AD": "ଆଣ୍ଡୋରା",
        "AE": "ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍",
        "AF": "ଆଫାଗାନିସ୍ତାନ୍",
        "AG": "ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା",
        "AI": "ଆଙ୍ଗୁଇଲ୍ଲା",
        "AL": "ଆଲବାନିଆ",
        "AM": "ଆର୍ମେନିଆ",
        "AN": "ନେଦରଲ୍ୟାଣ୍ଡସ୍ ଆଣ୍ଟିଲିଜ୍",
        "AO": "ଆଙ୍ଗୋଲା",
        "AQ": "ଆର୍ଣ୍ଟକଟିକା",
        "AR": "ଆର୍ଜେଣ୍ଟିନା",
        "AS": "ଆମେରିକାନ୍ ସାମୋଆ",
        "AT": "ଅଷ୍ଟ୍ରିଆ",
        "AU": "ଅଷ୍ଟ୍ରେଲିଆ",
        "AW": "ଆରୁବା",
        "AX": "ଆଲାଣ୍ଡ ଆଇସଲ୍ୟାଣ୍ଡ",
        "AZ": "ଆଜେରବାଇଜାନ୍",
        "BA": "ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା",
        "BB": "ବାରବାଡୋସ୍",
        "BD": "ବାଙ୍ଗଲାଦେଶ୍",
        "BE": "ବେଲଜିୟମ୍",
        "BF": "ବୁର୍କିନୋ ଫାସୋ",
        "BG": "ବୁଲଗେରିଆ",
        "BH": "ବାହାରିନ୍",
        "BI": "ବୁରୁନ୍ଦି",
        "BJ": "ବେନିନ୍",
        "BL": "ସେଣ୍ଟ ବାର୍ଥେଲେମି",
        "BM": "ବରମୁଡା",
        "BN": "ବ୍ରୁନେଇ",
        "BO": "ବୋଲଭିଆ",
        "BR": "ବ୍ରାଜିଲ୍",
        "BS": "ବାହାମାସ୍",
        "BT": "ଭୁଟାନ୍",
        "BV": "ବୌଭେଟ୍ ଆଇସଲ୍ୟାଣ୍ଡ",
        "BW": "ବୋଟସ୍ବାନ୍",
        "BY": "ବେଲାରୁଷ୍",
        "BZ": "ବେଲିଜ୍",
        "CA": "କାନାଡା",
        "CC": "କୋକୋସ୍ ଆଇସଲ୍ୟାଣ୍ଡ",
        "CD": "କଙ୍ଗୋ-କିନସାସା",
        "CF": "ମଧ୍ୟ ଆଫ୍ରିକୀୟ ଗଣତନ୍ତ୍ର",
        "CG": "କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ",
        "CH": "ସ୍ବିଜରଲ୍ୟାଣ୍ଡ",
        "CI": "ଆଇବରୀ କୋଷ୍ଟ",
        "CK": "କୁକ୍ ଆଇସଲ୍ୟାଣ୍ଡ",
        "CL": "ଚିଲ୍ଲୀ",
        "CM": "କାମେରୁନ୍",
        "CN": "ଚିନ୍",
        "CO": "କୋଲମ୍ବିଆ",
        "CR": "କୋଷ୍ଟା ରିକା",
        "CU": "କ୍ୱିବା",
        "CV": "କେପ୍ ଭର୍ଦେ",
        "CX": "ଖ୍ରୀଷ୍ଟମାସ ଆଇଲ୍ୟାଣ୍ଡ",
        "CY": "ସାଇପ୍ରସ୍",
        "CZ": "ଚେକ୍ ସାଧାରଣତନ୍ତ୍ର",
        "DE": "ଜର୍ମାନୀ",
        "DJ": "ଡିବୌଟି",
        "DK": "ଡେନମାର୍କ",
        "DM": "ଡୋମିନାକା",
        "DO": "ଡୋମିନକାନ୍ ପ୍ରଜାତନ୍ତ୍ର",
        "DZ": "ଆଲଜେରିଆ",
        "EC": "ଇକ୍ୱାଡୋର୍",
        "EE": "ଏସ୍ତୋନିଆ",
        "EG": "ଇଜିପ୍ଟ",
        "EH": "ପଶ୍ଚିମ ସାହାରା",
        "ER": "ଇରିଟ୍ରିୟା",
        "ES": "ସ୍ପେନ୍",
        "ET": "ଇଥିଓପିଆ",
        "EU": "ୟୁରୋପିଆନ୍ ୟୁନିଅନ୍",
        "FI": "ଫିନଲ୍ୟାଣ୍ଡ",
        "FJ": "ଫିଜି",
        "FK": "ଫଲ୍କଲ୍ୟାଣ୍ଡ ଦ୍ବୀପପୁଞ୍ଜ",
        "FM": "ମାଇକ୍ରୋନେସିଆ",
        "FO": "ଫାରୋଇ ଦ୍ବୀପପୁଞ୍ଜ",
        "FR": "ଫ୍ରାନ୍ସ",
        "GA": "ଗାବୋନ୍",
        "GB": "ବ୍ରିଟେନ୍",
        "GD": "ଗ୍ରେନାଡା",
        "GE": "ଜର୍ଜିଆ",
        "GF": "ଫ୍ରେଞ୍ଚ ଗୁଇନା",
        "GG": "ଗୁଏରନେସି",
        "GH": "ଘାନା",
        "GI": "ଜିବ୍ରାଲ୍ଟର୍",
        "GL": "ଗ୍ରୀନଲ୍ୟାଣ୍ଡ",
        "GM": "ଗାମ୍ବିଆ",
        "GN": "ଗୁଏନେଆ",
        "GP": "ଗୌଡେଲୌପେ",
        "GQ": "ଇକ୍ବାଟେରିଆଲ୍ ଗୁଇନିଆ",
        "GR": "ଗ୍ରୀସ୍",
        "GS": "ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "GT": "ଗୁଏତମାଲା",
        "GU": "ଗୁଆମ୍",
        "GW": "ଗୁଇନିଆ-ବିସାଉ",
        "GY": "ଗୁଇନା",
        "HK": "ହଂକଂ ବିଶେଷ ପ୍ରଶାସନିକ କ୍ଷେତ୍ର ଚୀନ୍",
        "HM": "ହାର୍ଡ ଦ୍ବୀପପୁଞ୍ଜ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "HN": "ହୋଣ୍ଡାରୁସ୍",
        "HR": "କ୍ରୋଆଟିଆ",
        "HT": "ହାଇତି",
        "HU": "ହଙ୍ଗେରୀ",
        "ID": "ଇଣ୍ଡୋନେସିଆ",
        "IE": "ଆୟରଲ୍ୟାଣ୍ଡ",
        "IL": "ଇସ୍ରାଏଲ୍",
        "IM": "ଆଇଲ୍ ଅଫ୍ ମୈନ୍",
        "IN": "ଭାରତ",
        "IO": "ବ୍ରିଟିଶ୍ ଭାରତୀୟ ସାମୁଦ୍ରିକ କ୍ଷେତ୍ର",
        "IQ": "ଇରାକ୍",
        "IR": "ଇରାନ୍",
        "IS": "ଆଇସଲ୍ୟାଣ୍ଡ",
        "IT": "ଇଟାଲୀ",
        "JE": "ଜର୍ସି",
        "JM": "ଜାମାଇକା",
        "JO": "ଜୋର୍ଡାନ୍",
        "JP": "ଜାପାନ୍",
        "KE": "କେନିୟା",
        "KG": "କିର୍ଗିଜିସ୍ଥାନ",
        "KH": "କାମ୍ବୋଡିଆ",
        "KI": "କିରିବାଟୀ",
        "KM": "କାମୋରସ୍",
        "KN": "ସେଣ୍ଟ କିଟସ୍ ଏଣ୍ଡ ନେଭିସ୍",
        "KP": "ଉତ୍ତର କୋରିଆ",
        "KR": "ଦକ୍ଷିଣ କୋରିଆ",
        "KW": "କୁଏତ୍",
        "KY": "କେମ୍ୟାନ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "KZ": "କାଜାକାସ୍ଥାନ୍",
        "LA": "ଲାଓସ୍",
        "LB": "ଲେବାନନ୍",
        "LC": "ସେଣ୍ଟ ଲୁସିଆ",
        "LI": "ଲିଚେସ୍ତିଆନାନ୍",
        "LK": "ଶ୍ରୀଲଙ୍କା",
        "LR": "ଲିବେରିଆ",
        "LS": "ଲେସୋଥୋ",
        "LT": "ଲିଥାଆନିଆ",
        "LU": "ଲକ୍ସେମବର୍ଗ",
        "LV": "ଲାଟଭିଆ",
        "LY": "ଲିବିଆ",
        "MA": "ମୋରୋକ୍କୋ",
        "MC": "ମୋନାକୋ",
        "MD": "ମାଲଡୋଭା",
        "ME": "ମଣ୍ଟେଗ୍ରୋ",
        "MF": "ସେଣ୍ଟ ମାର୍ଟିନ୍",
        "MG": "ମାଡାଗାସ୍କର୍",
        "MH": "ମାର୍ଶଲ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "MK": "ମାସେଡୋନିଆ",
        "ML": "ମାଳୀ",
        "MM": "ମିୟାମାର୍",
        "MN": "ମଙ୍ଗୋଲିଆ",
        "MO": "ମାକାଉ SAR ଚିନ୍",
        "MP": "ଉତ୍ତର ମାରିଆନା ଦ୍ବୀପପୁଞ୍ଜ",
        "MQ": "ମାର୍ଟିନିକ୍ୟୁ",
        "MR": "ମାଉରିଟାନିଆ",
        "MS": "ମଣ୍ଟେସେରାଟ୍",
        "MT": "ମାଲ୍ଟା",
        "MU": "ମୌରିସସ୍",
        "MV": "ମାଳଦ୍ବୀପ",
        "MW": "ମାଲୱି",
        "MX": "ମେକ୍ସିକୋ",
        "MY": "ମାଲେସିଆ",
        "MZ": "ମୋଜାମ୍ବିକ୍ୟୁ",
        "NA": "ନାମ୍ବିଆ",
        "NC": "ନୂତନ କାଲେଡୋନିଆ",
        "NE": "ନାଇଜର୍",
        "NF": "ନରଫ୍ଲକ୍ ଦ୍ବୀପ",
        "NG": "ନାଇଜେରିଆ",
        "NI": "ନିକାରାଗୁଆ",
        "NL": "ନେଦରଲ୍ୟାଣ୍ଡ",
        "NO": "ନରୱେ",
        "NP": "ନେପାଳ",
        "NR": "ନାଉରୁ",
        "NU": "ନିଉ",
        "NZ": "ନ୍ୟୁଜିଲାଣ୍ଡ",
        "OM": "ଓମାନ୍",
        "PA": "ପାନାମା",
        "PE": "ପେରୁ",
        "PF": "ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ",
        "PG": "ପପୁଆ ନ୍ୟୁ ଗୁଏନିଆ",
        "PH": "ଫିଲିପାଇନସ୍",
        "PK": "ପାକିସ୍ତାନ",
        "PL": "ପୋଲାଣ୍ଡ",
        "PM": "ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ବାଲୋନ୍",
        "PN": "ପିଟକାଇରିନ୍",
        "PR": "ପୁଏର୍ତ୍ତୋ ରିକୋ",
        "PS": "ପାଲେସ୍ତେନିଆ",
        "PT": "ପର୍ତ୍ତୁଗାଲ୍",
        "PW": "ପାଲାଉ",
        "PY": "ପାରାଗୁଏ",
        "QA": "କତାର୍",
        "QO": "ଆଉଟଲେଇଂ ଓସେନିଆ",
        "RE": "ରିୟୁନିଅନ୍",
        "RO": "ରୋମାନିଆ",
        "RS": "ସର୍ବିଆ",
        "RU": "ରୁଷିଆ",
        "RW": "ରାୱାଣ୍ଡା",
        "SA": "ସାଉଦି ଆରବିଆ",
        "SB": "ସୋଲୋମନ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "SC": "ସେଚେଲସ୍",
        "SD": "ସୁଦାନ୍",
        "SE": "ସ୍ୱେଡେନ୍",
        "SG": "ସିଙ୍ଗାପୁର୍",
        "SH": "ସେଣ୍ଟ ହେଲେନା",
        "SI": "ସ୍ଲୋଭେନିଆ",
        "SJ": "ସାଲ୍ଭାର୍ଡ ଏବଂ ଜାନ୍ ମାୟୋନ୍",
        "SK": "ସ୍ଲୋଭାକିଆ",
        "SL": "ସିଓରା ଲିଓନ୍",
        "SM": "ସାନ୍ ମାରିନୋ",
        "SN": "ସେନେଗାଲ୍",
        "SO": "ସୋମାଲିଆ",
        "SR": "ସୁରିନାମ",
        "SS": "ଦକ୍ଷିନ ସୁଦାନ",
        "ST": "ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି",
        "SV": "ଏଲ୍ ସାଲଭାଡୋର୍",
        "SY": "ସିରିଆ",
        "SZ": "ସ୍ବାଜିଲାଣ୍ଡ",
        "TC": "ତୁର୍କସ୍ ଏବଂ ସାଇକସ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "TD": "ଚାଦ୍",
        "TF": "ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର",
        "TG": "ଟୋଗୋ",
        "TH": "ଥାଇଲାଣ୍ଡ",
        "TJ": "ତାଜିକିସ୍ଥାନ୍",
        "TK": "ଟୋକେଲାଉ",
        "TL": "ପୁର୍ବ ତିମୋର୍",
        "TM": "ତୁର୍କମେନିସ୍ତାନ୍",
        "TN": "ତୁନିସିଆ",
        "TO": "ଟୋଙ୍ଗା",
        "TR": "ତୁର୍କୀ",
        "TT": "ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ",
        "TV": "ଟୁଭାଲୁ",
        "TW": "ତାଇୱାନ୍",
        "TZ": "ତାଞ୍ଜାନିଆ",
        "UA": "ୟୁକ୍ରାଇନ୍",
        "UG": "ଉଗାଣ୍ଡା",
        "UM": "ୟୁନାଇଟେଡ୍ ଷ୍ଟେଟସ୍ ମାଇନର୍ ଆଉଟଲେଇଂ ଦ୍ବୀପପୁଞ୍ଜ",
        "US": "ଯୁକ୍ତ ରାଷ୍ଟ୍ର ଆମେରିକା",
        "UY": "ଉରୁଗୁଏ",
        "UZ": "ଉଜବେକିସ୍ଥାନ୍",
        "VA": "ଭାଟିକାନ୍",
        "VC": "ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଦି ଗ୍ରେନାଡିସ୍",
        "VE": "ଭେନଜୁଏଲା",
        "VG": "ବ୍ରିଟିଶ୍ ଭର୍ଜିନ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "VI": "ୟୁଏସ୍ ଭର୍ଜିନ୍ ଦ୍ବୀପପୁଞ୍ଜ",
        "VN": "ଭିଏତନାମ୍",
        "VU": "ଭାନୁଆତୁ",
        "WF": "ୱାଲିସ୍ ଏବଂ ଫୁତୁନା",
        "WS": "ସାମୋଆ",
        "YE": "ୟେମେନ୍",
        "YT": "ମାୟୋଟେ",
        "ZA": "ଦକ୍ଷିଣ ଆଫ୍ରିକା",
        "ZM": "ଜାମ୍ବିଆ",
        "ZW": "ଜିମ୍ବାୱେ",
        "ZZ": "ଅଜଣା କିମ୍ବା ଅବୈଧ ପ୍ରଦେଶ"
    };
  }-*/;
}
