/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.pde;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.resolved.ResolvedLocation;
import org.eclipse.cbi.targetplatform.resolved.ResolvedTargetPlatform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TargetDefinitionGenerator {
    public String generate(ResolvedTargetPlatform targetPlatform, int sequenceNumber) {
        String _xblockexpression = null;
        Preconditions.checkNotNull((Object)targetPlatform);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder.newLine();
        _builder.append("<?pde?>");
        _builder.newLine();
        _builder.append("<!-- generated with https://github.com/eclipse-cbi/targetplatform-dsl -->");
        _builder.newLine();
        _builder.append("<target name=\"");
        String _name = targetPlatform.getName();
        _builder.append(_name);
        _builder.append("\" sequenceNumber=\"");
        _builder.append((Object)sequenceNumber);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        if (targetPlatform.getLocations() != null && !targetPlatform.getLocations().isEmpty()) {
            _builder.append("  ");
            _builder.append("<locations>");
            _builder.newLine();
            List<ResolvedLocation> _locations = targetPlatform.getLocations();
            for (ResolvedLocation location : _locations) {
                _builder.append("  ");
                _builder.append("  ");
                String _generateLocation = this.generateLocation(targetPlatform, location);
                _builder.append(_generateLocation, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("</locations>");
            _builder.newLine();
        }
        if (!(targetPlatform.getEnvironment() == null || StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getOs()) && StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getWs()) && StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getArch()) && StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getNl()))) {
            boolean _isNullOrEmpty_3;
            boolean _not_3;
            boolean _isNullOrEmpty_2;
            boolean _not_2;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            boolean _not;
            _builder.append("  ");
            _builder.append("<environment>");
            _builder.newLine();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getOs());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<os>");
                String _os = targetPlatform.getEnvironment().getOs();
                _builder.append(_os, "    ");
                _builder.append("</os>");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getWs()));
            if (_not_1) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<ws>");
                String _ws = targetPlatform.getEnvironment().getWs();
                _builder.append(_ws, "    ");
                _builder.append("</ws>");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _not_2 = !(_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getArch()));
            if (_not_2) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<arch>");
                String _arch = targetPlatform.getEnvironment().getArch();
                _builder.append(_arch, "    ");
                _builder.append("</arch>");
                _builder.newLineIfNotEmpty();
            }
            boolean bl4 = _not_3 = !(_isNullOrEmpty_3 = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getNl()));
            if (_not_3) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<nl>");
                String _nl = targetPlatform.getEnvironment().getNl();
                _builder.append(_nl, "    ");
                _builder.append("</nl>");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("</environment>");
            _builder.newLine();
        }
        if (targetPlatform.getEnvironment() != null && !StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getTargetJRE())) {
            _builder.append("  ");
            _builder.append("<targetJRE path=\"");
            String _targetJRE = targetPlatform.getEnvironment().getTargetJRE();
            _builder.append(_targetJRE, "  ");
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</target>");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String generateLocation(ResolvedTargetPlatform targetPlatform, ResolvedLocation location) {
        boolean _not_1;
        String _xblockexpression = null;
        EnumSet<Option> _xifexpression = null;
        boolean _isEmpty = targetPlatform.getOptions().isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? targetPlatform.getOptions() : location.getOptions();
        EnumSet<Option> options = _xifexpression;
        String _xifexpression_1 = null;
        boolean _contains = options.contains(Option.INCLUDE_REQUIRED);
        _xifexpression_1 = _contains ? "planner" : "slicer";
        String _plus = "includeMode=\"" + _xifexpression_1;
        String includeMode = String.valueOf(_plus) + "\"";
        boolean _contains_1 = options.contains(Option.INCLUDE_ALL_ENVIRONMENTS);
        String _plus_1 = "includeAllPlatforms=\"" + Boolean.valueOf(_contains_1);
        String includeAllPlatforms = String.valueOf(_plus_1) + "\"";
        boolean _contains_2 = options.contains(Option.INCLUDE_SOURCE);
        String _plus_2 = "includeSource=\"" + Boolean.valueOf(_contains_2);
        String includeSource = String.valueOf(_plus_2) + "\"";
        boolean _contains_3 = options.contains(Option.INCLUDE_CONFIGURE_PHASE);
        String _plus_3 = "includeConfigurePhase=\"" + Boolean.valueOf(_contains_3);
        String includeConfigurePhase = String.valueOf(_plus_3) + "\"";
        String locationAttributes = String.valueOf(includeMode) + " " + includeAllPlatforms + " " + includeSource + " " + includeConfigurePhase;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)location.getID());
        boolean bl = _not_1 = !_isNullOrEmpty;
        if (_not_1) {
            _builder.append("id=\"");
            String _iD = location.getID();
            _builder.append(_iD);
            _builder.append("\" ");
        }
        _builder.append("location=\"");
        URI _uRI = location.getURI();
        _builder.append((Object)_uRI);
        _builder.append("\"");
        String repositoryAttributes = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<location ");
        _builder_1.append(locationAttributes);
        _builder_1.append(" type=\"InstallableUnit\">");
        _builder_1.newLineIfNotEmpty();
        List<IInstallableUnit> _resolvedIUs = location.getResolvedIUs();
        for (IInstallableUnit iu : _resolvedIUs) {
            _builder_1.append("  ");
            _builder_1.append("<unit id=\"");
            String _id = iu.getId();
            _builder_1.append(_id, "  ");
            _builder_1.append("\" version=\"");
            Version _version = iu.getVersion();
            _builder_1.append((Object)_version, "  ");
            _builder_1.append("\"/>");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("  ");
        _builder_1.append("<repository ");
        _builder_1.append(repositoryAttributes, "  ");
        _builder_1.append("/>");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("</location>");
        _builder_1.newLine();
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }
}

