/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.ui.editor.syntaxcoloring;

import com.google.inject.Singleton;
import java.util.regex.Pattern;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;

@Singleton
public class TargetPlatformTokenToAttributeIdMapper
extends AbstractAntlrTokenToAttributeIdMapper {
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}*");
    private static final Pattern QUOTED = Pattern.compile("(?:^'([^']*)'$)|(?:^\"([^\"]*)\")$", 8);

    protected String calculateId(String tokenName, int tokenType) {
        if (PUNCTUATION.matcher(tokenName).matches()) {
            return "default";
        }
        if ("'requirements'".equals(tokenName) || "'allEnvironments'".equals(tokenName) || "'source'".equals(tokenName) || "'configurePhase'".equals(tokenName)) {
            return "option";
        }
        if ("'version'".equals(tokenName) || "'='".equals(tokenName) || "';'".equals(tokenName)) {
            return "default";
        }
        if (QUOTED.matcher(tokenName).matches()) {
            return "keyword";
        }
        if ("RULE_STRING".equals(tokenName)) {
            return "string";
        }
        if ("RULE_ML_COMMENT".equals(tokenName) || "RULE_SL_COMMENT".equals(tokenName)) {
            return "comment";
        }
        return "default";
    }
}

