/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleDisplayGraphHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ToggleDisplayGraphHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        ToggleDisplayGraphHandler.setDisplayGraph(!oldValue);
        return null;
    }

    public static boolean isDisplayGraph() {
        Preferences graphDisplay = ToggleDisplayGraphHandler.getPreference();
        return graphDisplay.get("option", "matrix").equals("graph");
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.displayGraph");
        return preferences.node("displayGraph");
    }

    public static void setDisplayGraph(boolean value) {
        Preferences transitivity = ToggleDisplayGraphHandler.getPreference();
        transitivity.put("option", value ? "graph" : "matrix");
        try {
            transitivity.flush();
        }
        catch (BackingStoreException e) {
            LOG.warn("Could not save display graph preferences!", (Throwable)e);
        }
    }
}

