/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.views;

import com.google.common.io.Files;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.SchemaTypeLoaderException;
import org.eclipse.capra.ui.office.Activator;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeFileNotSupportedException;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeObjectNotFound;
import org.eclipse.capra.ui.office.model.CapraExcelRow;
import org.eclipse.capra.ui.office.model.CapraGoogleSheetsRow;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.capra.ui.office.model.CapraWordRequirement;
import org.eclipse.capra.ui.office.table.BodyLayerStack;
import org.eclipse.capra.ui.office.table.ColumnHeaderLayerStack;
import org.eclipse.capra.ui.office.table.LinkedArtifactLabelAccumulator;
import org.eclipse.capra.ui.office.table.LinkedArtifactToolTip;
import org.eclipse.capra.ui.office.table.OfficeSelectionProvider;
import org.eclipse.capra.ui.office.table.OfficeTableColumnHeaderDataProvider;
import org.eclipse.capra.ui.office.table.OfficeTableDataProvider;
import org.eclipse.capra.ui.office.table.OfficeTableRowHeaderDataProvider;
import org.eclipse.capra.ui.office.table.RowHeaderLayerStack;
import org.eclipse.capra.ui.office.utils.CapraOfficeUtils;
import org.eclipse.capra.ui.office.utils.CellPopupMenuAction;
import org.eclipse.capra.ui.office.utils.OfficeSourceProvider;
import org.eclipse.capra.ui.office.utils.OfficeTransferType;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.mode.ColumnResizeDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeView
extends ViewPart {
    private static final Logger LOG = LoggerFactory.getLogger(OfficeView.class);
    public static final String ID = "org.eclipse.capra.ui.views.OfficeView";
    private static final String ERROR_TITLE = "Error";
    private static final String BUGZILLA_OFFICE_URL = "https://bugs.eclipse.org/bugs/show_bug.cgi?id=503313#add_comment";
    private List<CapraOfficeObject> selection = new ArrayList<CapraOfficeObject>();
    private Map<String, Boolean> isSheetEmptyMap;
    private String selectedSheetName;
    private File selectedFile;
    private String selectedFileId;
    private Composite parent;
    private NatTable officeTable;
    private OfficeTableDataProvider bodyDataProvider;
    private OfficeSelectionProvider selectionProvider;
    private BodyLayerStack bodyLayer;
    private OfficeSourceProvider provider = (OfficeSourceProvider)((ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class)).getSourceProvider("org.eclipse.capra.ui.office.utils.capraOfficeObject");

    public void setFocus() {
        this.officeTable.setFocus();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.updateOfficeObject();
    }

    public void parseGenericFile(File file) throws CapraOfficeFileNotSupportedException {
        String fileExtension = Files.getFileExtension((String)file.getName());
        if (fileExtension.equals("xlsx") || fileExtension.equals("xls")) {
            this.parseExcelDocument(file, null, null);
            this.updateOfficeObject();
        } else if (fileExtension.equals("docx")) {
            this.parseWordDocument(file);
        } else {
            throw new CapraOfficeFileNotSupportedException(fileExtension);
        }
    }

    public void parseExcelDocument(File officeFile, String googleDriveFileId, String sheetName) {
        Workbook workBook;
        try {
            workBook = CapraOfficeUtils.getExcelWorkbook(officeFile);
        }
        catch (OldExcelFormatException e) {
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            return;
        }
        catch (IOException e) {
            this.showErrorMessage(ERROR_TITLE, "Could not open the Excel workbook.", null);
            LOG.warn("Could not open the Excel workbook", (Throwable)e);
            return;
        }
        Sheet sheet = CapraOfficeUtils.getSheet(workBook, sheetName);
        if (sheet == null) {
            String hyperlinkMessage = "It appears that the file doesn't contain any sheets. If that is not true, please report the issue to our <a href=\"https://bugs.eclipse.org/bugs/show_bug.cgi?id=503313#add_comment\"> Bugzilla project page </a> and we will do our best to resolve it.";
            this.showErrorMessage(ERROR_TITLE, hyperlinkMessage, BUGZILLA_OFFICE_URL);
            return;
        }
        Map<String, Boolean> isNewSheetEmptyMap = CapraOfficeUtils.getSheetsEmptinessInfo(workBook);
        if (!isNewSheetEmptyMap.values().contains(false)) {
            this.showErrorMessage(ERROR_TITLE, "There are no rows to display in any of the sheets.", null);
            this.clearSelection();
            return;
        }
        this.clearSelection();
        this.selectedSheetName = sheet.getSheetName();
        this.selectedFile = officeFile;
        this.selectedFileId = googleDriveFileId;
        this.isSheetEmptyMap = isNewSheetEmptyMap;
        String idColumn = Activator.getDefault().getPreferenceStore().getString("org.eclipse.capra.ui.office.preferences.excelColumnValue");
        boolean isGoogleSheet = googleDriveFileId != null;
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            CapraExcelRow cRow;
            Row row = sheet.getRow(i);
            if (row != null && !(cRow = isGoogleSheet ? new CapraGoogleSheetsRow(officeFile, row, idColumn, googleDriveFileId) : new CapraExcelRow(officeFile, row, idColumn)).getData().isEmpty()) {
                this.selection.add(cRow);
            }
            ++i;
        }
        if (!this.selection.isEmpty()) {
            this.provider.setResource(this.selection.get(0));
        }
    }

    private void updateOfficeObject() {
        this.bodyDataProvider = new OfficeTableDataProvider(this.selection);
        this.bodyLayer = new BodyLayerStack(this.bodyDataProvider);
        OfficeTableColumnHeaderDataProvider colHeaderDataProvider = new OfficeTableColumnHeaderDataProvider(this.bodyDataProvider.getColumns());
        OfficeTableRowHeaderDataProvider rowHeaderDataProvider = new OfficeTableRowHeaderDataProvider(this.bodyDataProvider.getRows());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)colHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        ColumnHeaderLayerStack columnHeaderLayer = new ColumnHeaderLayerStack(colHeaderDataProvider, this.bodyLayer);
        RowHeaderLayerStack rowHeaderLayer = new RowHeaderLayerStack(rowHeaderDataProvider, this.bodyLayer);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)this.bodyLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        if (this.officeTable != null) {
            this.officeTable.dispose();
        }
        this.officeTable = new NatTable(this.parent, (ILayer)gridLayer, false);
        this.setStyleConfiguration();
        this.officeTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3), (IMouseAction)new CellPopupMenuAction(OfficeView.this.hookContextMenu(), OfficeView.this.bodyLayer.getSelectionLayer()));
                uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new ColumnResizeCursorAction());
                uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 1), (IDragMode)new ColumnResizeDragMode());
            }
        });
        this.officeTable.setLayer((ILayer)gridLayer);
        this.officeTable.refresh();
        this.officeTable.getVerticalBar().setVisible(true);
        this.officeTable.getHorizontalBar().setVisible(false);
        this.officeTable.setRedraw(true);
        this.officeTable.setVisible(true);
        this.officeTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                if (!OfficeView.this.selection.isEmpty()) {
                    uiBindingRegistry.registerDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.bodyLeftClick((int)0), (IMouseAction)new DoubleClickEventAction());
                }
            }
        });
        this.officeTable.configure();
        this.officeTable.redraw();
        if (this.selectionProvider == null) {
            this.selectionProvider = new OfficeSelectionProvider(this.bodyLayer.getSelectionLayer(), this.bodyDataProvider);
        } else {
            this.selectionProvider.updateProvider(this.bodyLayer.getSelectionLayer(), this.bodyDataProvider);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.addDragSupport();
        new LinkedArtifactToolTip(this.officeTable, this.bodyDataProvider, "BODY");
        this.parent.layout();
    }

    private void addDragSupport() {
        DragAndDropSupport dndSupport = new DragAndDropSupport(this.officeTable, this.bodyLayer.getSelectionLayer(), this.selection);
        int ops = 2015;
        Transfer[] transfersIn = new Transfer[]{FileTransfer.getInstance()};
        Transfer[] transfersOut = new Transfer[]{OfficeTransferType.getInstance()};
        this.officeTable.addDropSupport(ops, transfersIn, (DropTargetListener)dndSupport);
        this.officeTable.addDragSupport(ops, transfersOut, (DragSourceListener)dndSupport);
    }

    private void setStyleConfiguration() {
        this.officeTable.addConfiguration((IConfiguration)new ModernNatTableThemeConfiguration());
        this.officeTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){
            private final HorizontalAlignmentEnum ALIGNMENT = HorizontalAlignmentEnum.LEFT;

            public void configureRegistry(IConfigRegistry configRegistry) {
                IStyle columnHeaderStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"COLUMN_HEADER"});
                columnHeaderStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)this.ALIGNMENT);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)columnHeaderStyle, "NORMAL", "COLUMN_HEADER");
                IStyle rowHeaderStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"ROW_HEADER"});
                rowHeaderStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)this.ALIGNMENT);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)rowHeaderStyle, "NORMAL", "ROW_HEADER");
                IStyle cellStyle = (IStyle)configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", new String[]{"BODY"});
                cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)this.ALIGNMENT);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle);
                LineBorderDecorator cellPainter = new LineBorderDecorator((ICellPainter)new TextPainter(false, true, 5, true));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cellPainter);
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter());
                Style incomingLinkStyle = new Style();
                incomingLinkStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)incomingLinkStyle, "NORMAL", LinkedArtifactLabelAccumulator.INCOMING_LINK_LABEL);
                Style outgoingLinkStyle = new Style();
                outgoingLinkStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_GREEN);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)outgoingLinkStyle, "NORMAL", LinkedArtifactLabelAccumulator.OUTGOING_LINK_LABEL);
            }
        });
    }

    private void parseWordDocument(File officeFile) {
        List<XWPFParagraph> paragraphs;
        try {
            paragraphs = CapraOfficeUtils.getWordParagraphs(officeFile);
        }
        catch (IOException | SchemaTypeLoaderException e) {
            LOG.debug("Could not read Word file.", e);
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            return;
        }
        if (paragraphs.isEmpty()) {
            return;
        }
        this.clearSelection();
        this.selectedFile = officeFile;
        String fieldName = Activator.getDefault().getPreferenceStore().getString("org.eclipse.capra.ui.office.preferences.wordFieldId");
        int i = 0;
        while (i < paragraphs.size()) {
            CapraWordRequirement cRequirement;
            XWPFParagraph paragraph = paragraphs.get(i);
            if (paragraph != null && !(cRequirement = new CapraWordRequirement(officeFile, paragraph, fieldName)).getData().isEmpty()) {
                this.selection.add(cRequirement);
            }
            ++i;
        }
        if (this.selection.isEmpty()) {
            this.showErrorMessage(ERROR_TITLE, "There are no fields with the specified field name in this document.", null);
            this.clearSelection();
            return;
        }
        this.provider.setResource(this.selection.get(0));
    }

    public void showObjectDetails() {
        try {
            this.selectionProvider.returnSelectedItem().showOfficeObjectInNativeEnvironment();
        }
        catch (CapraOfficeObjectNotFound e) {
            LOG.debug("Could not find office object.", (Throwable)e);
            this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
        }
    }

    public void clearSelection() {
        this.selection.clear();
        this.officeTable.dispose();
        this.selectedSheetName = null;
        this.selectedFile = null;
        this.selectedFileId = null;
        this.isSheetEmptyMap = null;
        this.updateOfficeObject();
    }

    public void openFile() {
        File file;
        FileDialog fd = new FileDialog(this.getSite().getShell(), 32);
        String filePath = fd.open();
        if (filePath != null && !filePath.isEmpty() && (file = new File(filePath)).exists()) {
            try {
                this.parseGenericFile(file);
            }
            catch (CapraOfficeFileNotSupportedException e) {
                LOG.debug("Capra does not support the file.", (Throwable)e);
                this.showErrorMessage(ERROR_TITLE, e.getMessage(), null);
            }
        }
    }

    public void displaySheet(String sheetName) {
        if (!this.selection.isEmpty() && this.selection.get(0) instanceof CapraExcelRow) {
            this.parseExcelDocument(this.selectedFile, this.selectedFileId, sheetName);
        }
    }

    public Map<String, Boolean> getIsSheetEmptyMap() {
        if (this.isSheetEmptyMap == null && !this.selection.isEmpty()) {
            try {
                this.isSheetEmptyMap = CapraOfficeUtils.getSheetsEmptinessInfo(CapraOfficeUtils.getExcelWorkbook(((CapraExcelRow)this.selection.get(0)).getFile()));
            }
            catch (IOException | OldExcelFormatException e) {
                LOG.debug("Could not open Excel file.", e);
            }
        }
        return this.isSheetEmptyMap;
    }

    public String getSelectedSheetName() {
        return this.selectedSheetName;
    }

    public static OfficeView getOpenedView() {
        try {
            return (OfficeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (PartInitException e) {
            LOG.debug("Could not open office view.", (Throwable)e);
            return null;
        }
    }

    public void refreshView() {
        if (this.selection.isEmpty()) {
            return;
        }
        if (this.selection.get(0) instanceof CapraExcelRow) {
            this.parseExcelDocument(this.selectedFile, this.selectedFileId, this.selectedSheetName);
            this.updateOfficeObject();
        } else if (this.selection.get(0) instanceof CapraWordRequirement) {
            this.parseWordDocument(this.selectedFile);
        }
    }

    private void showErrorMessage(String caption, String message, String url) {
        new HyperlinkDialog(new HyperlinkDialog.HyperlinkDialogParameter(this.officeTable.getShell(), caption, null, 1, new String[]{"OK"}, 0), message, url).open();
    }

    private Menu hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.officeTable.getParent());
        this.officeTable.getParent().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        return menu;
    }

    class DoubleClickEventAction
    implements IMouseAction {
        DoubleClickEventAction() {
        }

        public void run(NatTable natTable, MouseEvent event) {
            try {
                OfficeView.this.selectionProvider.returnSelectedItem().showOfficeObjectInNativeEnvironment();
            }
            catch (CapraOfficeObjectNotFound e) {
                LOG.debug("Could not find office object.", (Throwable)e);
                OfficeView.this.showErrorMessage(OfficeView.ERROR_TITLE, e.getMessage(), null);
            }
        }
    }

    class DragAndDropSupport
    implements DragSourceListener,
    DropTargetListener {
        private final NatTable officeTable;
        private final SelectionLayer selectionLayer;

        public DragAndDropSupport(NatTable natTable, SelectionLayer selectionLayer, List<CapraOfficeObject> data) {
            this.officeTable = natTable;
            this.selectionLayer = selectionLayer;
        }

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
            String[] data = (String[])event.data;
            if (data != null) {
                File file = new File(data[0]);
                event.data = file;
            }
        }

        public void drop(DropTargetEvent event) {
            try {
                String[] data;
                File file;
                if (event.data instanceof String[] && (file = new File((data = (String[])event.data)[0])).exists()) {
                    OfficeView.this.parseGenericFile(file);
                }
            }
            catch (CapraOfficeFileNotSupportedException e) {
                LOG.debug("Capra does not support this file.", (Throwable)e);
                OfficeView.this.showErrorMessage(OfficeView.ERROR_TITLE, e.getMessage(), null);
            }
            try {
                this.officeTable.refresh();
            }
            catch (SWTException e) {
                LOG.debug("Office table failed to refresh.", (Throwable)e);
            }
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void dragStart(DragSourceEvent event) {
            if (this.selectionLayer.getSelectedRowCount() == 0) {
                event.doit = false;
            } else if (!this.officeTable.getRegionLabelsByXY(event.x, event.y).hasLabel("BODY")) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (OfficeTransferType.getInstance().isSupportedType(event.dataType)) {
                ArrayList<CapraOfficeObject> tr = new ArrayList<CapraOfficeObject>();
                tr.add(OfficeView.this.bodyDataProvider.getAllEllements().get(this.selectionLayer.getFullySelectedRowPositions()[0] + 1));
                event.data = tr;
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }

    static class HyperlinkDialog
    extends MessageDialog {
        private static final int PREFERRED_DIALOG_WIDTH = 300;
        private String hyperlinkMessage;
        private String url;

        public HyperlinkDialog(HyperlinkDialogParameter parameterObject, String hyperlinkMessage, String url) {
            super(parameterObject.parentShell, parameterObject.dialogTitle, parameterObject.dialogTitleImage, null, parameterObject.dialogImageType, parameterObject.dialogButtonLabels, parameterObject.defaultIndex);
            this.hyperlinkMessage = hyperlinkMessage;
            this.url = url;
        }

        protected Control createCustomArea(Composite parent) {
            Link link = new Link(parent, 0);
            link.setText(this.hyperlinkMessage);
            GridData gd = new GridData();
            gd.widthHint = 300;
            link.setLayoutData((Object)gd);
            if (this.url != null && !this.url.contentEquals("")) {
                link.setToolTipText(this.url);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            Desktop.getDesktop().browse(new URI(url));
                            this.okPressed();
                        }
                        catch (IOException e1) {
                            LOG.info("No default browser found.", (Throwable)e1);
                        }
                        catch (URISyntaxException e1) {
                            LOG.info("Provided malformed URI.", (Throwable)e1);
                        }
                    }
                });
            }
            return link;
        }

        public static class HyperlinkDialogParameter {
            public Shell parentShell;
            public String dialogTitle;
            public Image dialogTitleImage;
            public int dialogImageType;
            public String[] dialogButtonLabels;
            public int defaultIndex;

            public HyperlinkDialogParameter(Shell parentShell, String dialogTitle, Image dialogTitleImage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
                this.parentShell = parentShell;
                this.dialogTitle = dialogTitle;
                this.dialogTitleImage = dialogTitleImage;
                this.dialogImageType = dialogImageType;
                this.dialogButtonLabels = dialogButtonLabels;
                this.defaultIndex = defaultIndex;
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
            OfficeView.this.officeTable.dispose();
            OfficeView.this.officeTable = null;
        }

        public Object[] getElements(Object parent) {
            return OfficeView.this.selection.toArray();
        }
    }

    static class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            int minAllowed = Activator.getDefault().getPreferenceStore().getInt("org.eclipse.capra.ui.office.preferences.charCount");
            String text = obj.toString();
            int textLength = Math.min(text.length(), minAllowed);
            if (textLength == minAllowed) {
                text = String.valueOf(text.substring(0, textLength)) + "...";
            }
            return text;
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

