/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.table;

import java.util.ArrayList;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.ui.office.table.LinkedArtifactLabelAccumulator;
import org.eclipse.capra.ui.office.table.OfficeTableDataProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.swt.widgets.Event;

public class LinkedArtifactToolTip
extends NatTableContentTooltip {
    private final OfficeTableDataProvider dataProvider;

    public LinkedArtifactToolTip(NatTable natTable, OfficeTableDataProvider dataProvider, String ... tooltipRegions) {
        super(natTable, tooltipRegions);
        this.dataProvider = dataProvider;
    }

    protected String getText(Event event) {
        int row;
        int col;
        ILayerCell cell;
        String tooltip = super.getText(event);
        if (tooltip != null) {
            tooltip = tooltip.trim();
        }
        if ((cell = this.natTable.getCellByPosition(col = this.natTable.getColumnPositionByX(event.x), row = this.natTable.getRowPositionByY(event.y))) != null) {
            ArrayList<Connection> links = new ArrayList<Connection>();
            if (cell.getConfigLabels().getLabels().contains(LinkedArtifactLabelAccumulator.OUTGOING_LINK_LABEL)) {
                links.addAll(this.dataProvider.getOutgoingConnectionsForRow(row));
            }
            if (cell.getConfigLabels().getLabels().contains(LinkedArtifactLabelAccumulator.INCOMING_LINK_LABEL)) {
                links.addAll(this.dataProvider.getIncomingConnectionsForRow(row));
            }
            if (!links.isEmpty()) {
                StringBuilder builder = new StringBuilder(tooltip);
                if (!tooltip.isBlank()) {
                    builder.append("\n\n");
                }
                builder.append("Links:\n");
                for (Connection con : links) {
                    builder.append(" * ");
                    builder.append(EMFHelper.getIdentifier((EObject)con.getTlink()));
                    builder.append("\n");
                }
                tooltip = builder.toString().stripTrailing();
            }
        }
        return tooltip;
    }
}

