/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.model;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.poi.ss.usermodel.Row;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeObjectNotFound;
import org.eclipse.capra.ui.office.model.CapraExcelRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapraGoogleSheetsRow
extends CapraExcelRow {
    private static final Logger LOG = LoggerFactory.getLogger(CapraGoogleSheetsRow.class);

    public CapraGoogleSheetsRow(File officeFile, Row row, String idColumn, String googleDriveFileId) {
        super(officeFile, row, idColumn);
        String rowId = this.getRowIdFromExcelRow(row);
        try {
            URI uri = new URIBuilder().setScheme("google").setPath(googleDriveFileId).addParameter("sheet", row.getSheet().getSheetName()).addParameter("row", rowId).build();
            this.setUri(uri);
        }
        catch (URISyntaxException e) {
            LOG.error("Could not build URI for ", (Object)googleDriveFileId);
        }
    }

    @Override
    public void showOfficeObjectInNativeEnvironment() throws CapraOfficeObjectNotFound {
        try {
            Desktop.getDesktop().browse(new URI("https://docs.google.com/spreadsheets/d/" + this.getPath()));
        }
        catch (IOException | URISyntaxException e) {
            LOG.info("Could not open Google spreadsheet.", (Throwable)e);
        }
    }
}

