/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixEntryData;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class TraceabilityMatrixDataProvider
implements IDataProvider {
    private ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
    private IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().get();
    private List<TraceabilityMatrixEntryData> rows = new ArrayList<TraceabilityMatrixEntryData>();
    private List<TraceabilityMatrixEntryData> columns = new ArrayList<TraceabilityMatrixEntryData>();

    private Set<EObject> getSortedSetOfArtifacts(List<Connection> connections, Function<? super Connection, ? extends List<EObject>> func) {
        List inserted = connections.stream().map(func).flatMap(Collection::stream).collect(Collectors.toList());
        Collections.sort(inserted, new ArtifactHandlerClassNameComparator());
        return new LinkedHashSet<EObject>(inserted);
    }

    private Set<EObject> getTraceOrigins(List<Connection> connections) {
        return this.getSortedSetOfArtifacts(connections, Connection::getOrigins);
    }

    private Set<EObject> getTraceTargets(List<Connection> connections) {
        return this.getSortedSetOfArtifacts(connections, Connection::getTargets);
    }

    public TraceabilityMatrixDataProvider(List<Connection> connections, EObject traceModel, ITraceabilityInformationModelAdapter traceAdapter, ArtifactHelper artifactHelper) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMarker[] markers = null;
        try {
            markers = root.findMarkers("org.eclipse.capra.ui.notification.capraProblemMarker", true, 2);
        }
        catch (CoreException e) {
            return;
        }
        if (markers == null || markers.length == 0) {
            return;
        }
        for (EObject element : this.getTraceOrigins(connections)) {
            if (element == null) continue;
            TraceabilityMatrixEntryData rowEntry = new TraceabilityMatrixEntryData(element, artifactHelper.getArtifactLabel(element));
            rowEntry.setConnections(traceAdapter.getConnectedElements(element, traceModel));
            this.findMarkers(artifactHelper, markers, element, rowEntry);
            this.rows.add(rowEntry);
        }
        for (EObject element : this.getTraceTargets(connections)) {
            if (element == null) continue;
            TraceabilityMatrixEntryData colEntry = new TraceabilityMatrixEntryData(element, artifactHelper.getArtifactLabel(element));
            this.findMarkers(artifactHelper, markers, element, colEntry);
            this.columns.add(colEntry);
        }
    }

    private void findMarkers(ArtifactHelper artifactHelper, IMarker[] markers, EObject element, TraceabilityMatrixEntryData entry) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                if (Objects.equals(marker.getAttribute("oldArtifactUri"), artifactHelper.getArtifactLocation(element))) {
                    entry.getMarkers().add(marker);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Object getDataValue(int colIndex, int rowIndex) {
        Connection connection = this.getCellConnection(colIndex, rowIndex);
        if (connection != null) {
            EClass eClass = connection.getTlink().eClass();
            return eClass == null ? "" : eClass.getName();
        }
        return "";
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void setDataValue(int arg0, int arg1, Object arg2) {
        throw new UnsupportedOperationException();
    }

    public List<TraceabilityMatrixEntryData> getColumns() {
        return this.columns.stream().collect(Collectors.toCollection(ArrayList::new));
    }

    public TraceabilityMatrixEntryData getColumn(int index) {
        return this.columns.get(index);
    }

    public List<TraceabilityMatrixEntryData> getRows() {
        return this.rows.stream().collect(Collectors.toCollection(ArrayList::new));
    }

    public TraceabilityMatrixEntryData getRow(int index) {
        return this.rows.get(index);
    }

    public Connection getCellConnection(int column, int row) {
        TraceabilityMatrixEntryData colEntry = this.columns.get(column);
        TraceabilityMatrixEntryData rowEntry = this.rows.get(row);
        for (Connection connection : rowEntry.getConnections()) {
            for (EObject target : connection.getTargets()) {
                if (EMFHelper.hasSameIdentifier((EObject)rowEntry.getArtifact(), (EObject)target) || !EMFHelper.hasSameIdentifier((EObject)colEntry.getArtifact(), (EObject)target)) continue;
                return connection;
            }
        }
        return null;
    }

    private class ArtifactHandlerClassNameComparator
    implements Comparator<Object> {
        private ArtifactHandlerClassNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || o2 == null) {
                return o1 == null ? 1 : -1;
            }
            EObject artifactModel = TraceabilityMatrixDataProvider.this.persistenceAdapter.getArtifactWrappers(TraceabilityMatrixDataProvider.this.resourceSet);
            ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
            IArtifactHandler o1Handler = artifactHelper.getHandler(artifactHelper.unwrapWrapper(o1)).orElse(null);
            IArtifactHandler o2Handler = artifactHelper.getHandler(artifactHelper.unwrapWrapper(o2)).orElse(null);
            if (o1Handler != null && o2Handler != null) {
                return o1Handler.getClass().getSimpleName().compareTo(o2Handler.getClass().getSimpleName());
            }
            if (o1Handler == null && o2Handler == null) {
                return 0;
            }
            return o1Handler == null ? 1 : -1;
        }
    }
}

