/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.metadatamodel.listeners;

import java.util.Date;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IMetadataAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.listeners.ITraceCreationListener;
import org.eclipse.capra.generic.metadatamodel.MetadataContainer;
import org.eclipse.capra.generic.metadatamodel.MetadatamodelFactory;
import org.eclipse.capra.generic.metadatamodel.Person;
import org.eclipse.capra.generic.metadatamodel.TraceMetadata;
import org.eclipse.emf.ecore.EObject;

public class GenericTraceCreationListener
implements ITraceCreationListener {
    public void onTraceCreation(Connection newTrace) {
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        IMetadataAdapter metadataAdapter = (IMetadataAdapter)ExtensionPointHelper.getTraceMetadataAdapter().orElseThrow();
        MetadataContainer metadataContainer = (MetadataContainer)persistenceAdapter.getMetadataContainer(EditingDomainHelper.getResourceSet());
        TraceMetadata metadata = MetadatamodelFactory.eINSTANCE.createTraceMetadata();
        metadata.setCreationDate(new Date());
        Person creator = MetadatamodelFactory.eINSTANCE.createPerson();
        creator.setName(System.getProperty("user.name"));
        creator.setEmail(System.getProperty("user.email"));
        metadata.setCreationUser(creator);
        metadata.setTrace(newTrace.getTlink());
        metadataAdapter.setMetadataForTrace(newTrace.getTlink(), (EObject)metadata, (EObject)metadataContainer);
    }
}

