/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.interaction.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.core.semantic.data.interaction.CombinedFragment;
import org.polarsys.capella.core.semantic.data.interaction.InteractionFactory;
import org.polarsys.capella.core.semantic.data.interaction.InteractionOperand;
import org.polarsys.capella.core.semantic.data.interaction.InteractionOperatorKind;
import org.polarsys.capella.core.semantic.data.interaction.InteractionPackage;
import org.polarsys.capella.core.semantic.data.interaction.MessageKind;
import org.polarsys.capella.core.semantic.data.interaction.Scenario;
import org.polarsys.capella.core.semantic.data.interaction.ScenarioKind;
import org.polarsys.capella.core.semantic.data.interaction.SequenceMessage;
import org.polarsys.capella.core.semantic.data.interaction.SequenceMessageValuation;
import org.polarsys.capella.core.semantic.data.interaction.impl.CombinedFragmentImpl;
import org.polarsys.capella.core.semantic.data.interaction.impl.InteractionOperandImpl;
import org.polarsys.capella.core.semantic.data.interaction.impl.ScenarioImpl;
import org.polarsys.capella.core.semantic.data.interaction.impl.SequenceMessageImpl;
import org.polarsys.capella.core.semantic.data.interaction.impl.SequenceMessageValuationImpl;

public class InteractionFactoryImpl
extends EFactoryImpl
implements InteractionFactory {
    public static InteractionFactory init() {
        try {
            InteractionFactory theInteractionFactory = (InteractionFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/core/interaction/0.8.0/semantic");
            if (theInteractionFactory != null) {
                return theInteractionFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new InteractionFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createSequenceMessage();
            }
            case 1: {
                return this.createScenario();
            }
            case 3: {
                return this.createCombinedFragment();
            }
            case 4: {
                return this.createInteractionOperand();
            }
            case 5: {
                return this.createSequenceMessageValuation();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createMessageKindFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createScenarioKindFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createInteractionOperatorKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertMessageKindToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertScenarioKindToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertInteractionOperatorKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public SequenceMessage createSequenceMessage() {
        SequenceMessageImpl sequenceMessage = new SequenceMessageImpl();
        return sequenceMessage;
    }

    @Override
    public Scenario createScenario() {
        ScenarioImpl scenario = new ScenarioImpl();
        return scenario;
    }

    @Override
    public CombinedFragment createCombinedFragment() {
        CombinedFragmentImpl combinedFragment = new CombinedFragmentImpl();
        return combinedFragment;
    }

    @Override
    public InteractionOperand createInteractionOperand() {
        InteractionOperandImpl interactionOperand = new InteractionOperandImpl();
        return interactionOperand;
    }

    @Override
    public SequenceMessageValuation createSequenceMessageValuation() {
        SequenceMessageValuationImpl sequenceMessageValuation = new SequenceMessageValuationImpl();
        return sequenceMessageValuation;
    }

    public MessageKind createMessageKindFromString(EDataType eDataType, String initialValue) {
        MessageKind result = MessageKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMessageKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ScenarioKind createScenarioKindFromString(EDataType eDataType, String initialValue) {
        ScenarioKind result = ScenarioKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertScenarioKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public InteractionOperatorKind createInteractionOperatorKindFromString(EDataType eDataType, String initialValue) {
        InteractionOperatorKind result = InteractionOperatorKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertInteractionOperatorKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public InteractionPackage getInteractionPackage() {
        return (InteractionPackage)this.getEPackage();
    }

    @Deprecated
    public static InteractionPackage getPackage() {
        return InteractionPackage.eINSTANCE;
    }
}

