/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.PlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.platform.pde.IPlatformManager;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPlatformManager
implements IPlatformManager {
    protected Object _lockPlatformManager = new Object();
    private Set<IPlatformExtensionPointListener> _listeners;

    public static <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Map<Class<?>, Set<Object>> registry, Class<T> clazz) {
        ArrayList extensionPoints = new ArrayList();
        if (clazz != null && registry.get(clazz) != null) {
            extensionPoints.addAll(registry.get(clazz));
        }
        return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
    }

    protected static void addPlatformBundle(IPlatformBundle bundle, Map<String, IPlatformBundle> registry, Map<Class<?>, Set<Object>> extensions, PlatformExtensionPointDelta delta) {
        registry.put(bundle.getBundleId(), bundle);
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = bundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                AbstractPlatformManager.addExtensionPoint(extensionPoint, clazz, extensions, delta);
                ++n2;
            }
        }
    }

    protected static void addExtensionPoint(IPlatformExtensionPoint extensionPoint, Class<? extends IPlatformExtensionPoint> clazz, Map<Class<?>, Set<Object>> extensions, PlatformExtensionPointDelta delta) {
        Set<Object> extensionPoints = extensions.get(clazz);
        if (extensionPoints == null) {
            extensionPoints = new HashSet<Object>();
            extensions.put(clazz, extensionPoints);
        }
        if (!extensionPoints.add(extensionPoint)) {
            EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"AbstractPlatformManager.addExtensionPoint(..) _ ''{0}'' already added Extension Point.", (Object)extensionPoint.getId()));
        } else if (delta != null) {
            delta.storeAddedPlatformExtensionPoint(clazz, extensionPoint);
        }
    }

    protected static void removePlatformBundle(IPlatformBundle bundle, Map<String, IPlatformBundle> registry, Map<Class<?>, Set<Object>> extensions, PlatformExtensionPointDelta delta) {
        if (!bundle.equals(registry.remove(bundle.getBundleId()))) {
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"AbstractPlatformManager.removePlatformBundle(..) _ ''{0}'' unknown IPlatformBundle.", (Object)bundle.getBundleId()));
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = bundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                AbstractPlatformManager.removeExtensionPoint(extensionPoint, clazz, extensions, delta);
                ++n2;
            }
        }
    }

    protected static void removeExtensionPoint(IPlatformExtensionPoint extensionPoint, Class<? extends IPlatformExtensionPoint> clazz, Map<Class<?>, Set<Object>> extensions, PlatformExtensionPointDelta delta) {
        if (extensions.get(clazz).remove(extensionPoint)) {
            if (extensions.get(clazz).isEmpty()) {
                extensions.remove(clazz);
            }
            if (delta != null) {
                delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
            }
        }
    }

    public AbstractPlatformManager() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new HashSet<IPlatformExtensionPointListener>();
            }
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            if (this._listeners == null) {
                return;
            }
            this._listeners.remove(listener);
        }
    }

    protected void firePlatformExtensionPoint(IPlatformExtensionPointDelta delta) {
        if (this._listeners != null) {
            for (IPlatformExtensionPointListener listener : this._listeners) {
                listener.platformExtensionPointChanged(delta);
            }
        }
    }

    @Override
    public void dispose() {
        if (this._listeners != null) {
            this._listeners.clear();
        }
    }

    protected abstract void initialize();

    protected abstract void initializeRegistry();
}

