/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.docgen.util.IImageHandler;
import org.polarsys.capella.docgen.util.ImageHelper;
import org.polarsys.capella.docgen.util.StringUtil;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;

public class DefaultImageHandler
implements IImageHandler {
    @Override
    public boolean isHandlerFor(String uri) {
        return true;
    }

    @Override
    public String handleImage(ILog logger, EObject eObject, String imageSrc, IFolder parentTargetFolder, List<String> imageFileNames) {
        String id = this.getID(eObject);
        String targetIconPath = "";
        boolean isDataImage = imageSrc.startsWith("data:image/");
        if (isDataImage) {
            targetIconPath = ImageHelper.INSTANCE.serializeImageInTargetFolder(imageSrc, String.valueOf(parentTargetFolder.getLocationURI().getPath()) + "/images/", id, imageFileNames, logger);
            if (targetIconPath == null) {
                logger.log((IStatus)new Status(2, "org.polarsys.capella.docgen", MessageFormat.format("Image serialization failed, default to keep img serialized value for element if id: {0}", id), (Throwable)new Exception()));
            }
            return targetIconPath;
        }
        String decodedImageSrc = StringUtil.decodeHtmlFilePath(imageSrc, logger);
        if (decodedImageSrc == null) {
            return null;
        }
        Path aPath = new Path(decodedImageSrc);
        targetIconPath = this.getTargetIconPath((IPath)aPath, id, imageFileNames);
        String iconSourcePath = "";
        if (this.isNetworkImage(decodedImageSrc)) {
            logger.log((IStatus)new Status(2, "org.polarsys.capella.docgen", MessageFormat.format("Network images are left as is and not copied to the generated documentation: {0}. Element id: {1}", decodedImageSrc, id)));
            return null;
        }
        if (this.isNetworkDrive(decodedImageSrc)) {
            iconSourcePath = StringUtil.unencodeURIString(decodedImageSrc, logger);
            targetIconPath = StringUtil.unencodeURIString(targetIconPath, logger);
        } else if (aPath.isAbsolute()) {
            iconSourcePath = aPath.toFile().toURI().getPath();
            iconSourcePath = StringUtil.unencodeURIString(iconSourcePath, logger);
            targetIconPath = StringUtil.unencodeURIString(targetIconPath, logger);
        } else {
            Path path = new Path(decodedImageSrc);
            IFile iconFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (!iconFile.exists()) {
                Path parentSrcFolder = new Path(eObject.eResource().getURI().segment(1));
                path = parentSrcFolder.append(decodedImageSrc);
                iconFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
            if (iconFile.exists()) {
                iconSourcePath = iconFile.getLocationURI().getPath();
            } else {
                logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", StringUtil.getResourceCopyError(eObject, path.toString())));
                return null;
            }
        }
        this.copyImage(logger, eObject, iconSourcePath, parentTargetFolder, targetIconPath);
        return targetIconPath;
    }

    private boolean isNetworkDrive(String imageSrc) {
        return imageSrc.startsWith("//") || imageSrc.startsWith("\\\\");
    }

    private boolean isNetworkImage(String imageSrc) {
        return imageSrc.startsWith("http") || imageSrc.startsWith("https");
    }

    protected void copyImage(ILog logger, EObject eObject, String iconSourcePath, IFolder parentTargetFolder, String iconName) {
        try {
            ImageHelper.INSTANCE.copyProjectImageToSystemLocation(iconSourcePath, String.valueOf(parentTargetFolder.getLocationURI().getPath()) + "/images/" + iconName);
        }
        catch (Exception e) {
            logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", StringUtil.getResourceCopyError(eObject, iconSourcePath), (Throwable)e));
        }
    }

    protected String getTargetIconPath(IPath aPath, String id, List<String> imageFileNames) {
        String targetFolderPath = aPath.removeFileExtension().lastSegment();
        targetFolderPath = String.valueOf(id) + "/" + targetFolderPath;
        targetFolderPath = ImageHelper.INSTANCE.getUniqueFileName(targetFolderPath, imageFileNames);
        targetFolderPath = String.valueOf(targetFolderPath) + "." + aPath.getFileExtension();
        return targetFolderPath;
    }

    protected String getID(EObject eObject) {
        String id = IdManager.getInstance().getId(eObject);
        id = DocGenHtmlUtil.getValidFileName((String)id);
        return id;
    }
}

