/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Substitution;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SubstitutionHelper {
    public static List<Pattern> apply(PatternContext context, List<Pattern> patterns1, List<Object> parameterValues) throws PatternException {
        TypePatternSubstitution substitutions = (TypePatternSubstitution)context.getValue("pattern.substitutions");
        if (substitutions == null || substitutions.getSubstitutions().isEmpty() || patterns1.isEmpty()) {
            return patterns1;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patterns1);
        block0: for (Substitution substitution : substitutions.getSubstitutions()) {
            Pattern[] array;
            Pattern[] patternArray = array = patterns.toArray(new Pattern[patterns.size()]);
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                Pattern target = substitution.getReplacedElement();
                if (target != null && pattern.getID().equals(target.getID())) {
                    int index = patterns.indexOf(pattern);
                    EList replacement = substitution.getReplacement();
                    if (replacement == null) continue block0;
                    if (replacement.isEmpty()) {
                        patterns.remove(index);
                        continue block0;
                    }
                    ArrayList<Pattern> toAdd = new ArrayList<Pattern>(replacement.size());
                    for (Pattern replacementPattern : replacement) {
                        if (!SubstitutionHelper.checkCondition(context, replacementPattern, parameterValues)) continue;
                        toAdd.add(replacementPattern);
                    }
                    if (toAdd.isEmpty()) continue block0;
                    patterns.remove(index);
                    patterns.addAll(index, (Collection<Pattern>)replacement);
                    continue block0;
                }
                ++n2;
            }
        }
        return patterns;
    }

    private static boolean checkCondition(PatternContext context, Pattern replacementPattern, List<Object> parameterValues) throws PatternException {
        HashMap<PatternParameter, Object> parameters;
        PatternExtension extension;
        block4: {
            extension = ExtensionHelper.getExtension(replacementPattern.getNature());
            parameters = new HashMap<PatternParameter, Object>();
            if (replacementPattern.getAllParameters().size() == parameterValues.size()) break block4;
            return false;
        }
        try {
            int nb = replacementPattern.getAllParameters().size();
            int i = 0;
            while (i < nb) {
                parameters.put((PatternParameter)replacementPattern.getAllParameters().get(i), parameterValues.get(i));
                ++i;
            }
            return extension.createEngine(replacementPattern).checkCondition(context, parameters);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new PatternException((Throwable)e);
        }
    }

    public static void apply(List<Pattern> patterns, TypePatternSubstitution substitutions) {
        if (substitutions == null || substitutions.getSubstitutions().isEmpty() || patterns.isEmpty()) {
            return;
        }
        for (Substitution substitution : substitutions.getSubstitutions()) {
            Pattern[] array;
            Pattern[] patternArray = array = patterns.toArray(new Pattern[patterns.size()]);
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                Pattern target = substitution.getReplacedElement();
                if (target != null && pattern.getID().equals(target.getID())) {
                    int index = patterns.indexOf(pattern);
                    patterns.remove(index);
                    if (substitution.getReplacement() != null) {
                        patterns.addAll(index, (Collection<Pattern>)substitution.getReplacement());
                    }
                }
                ++n2;
            }
        }
    }

    public static TypePatternSubstitution merge(TypePatternSubstitution inputA, TypePatternSubstitution inputB) {
        TypePatternSubstitution result = PatternFactory.eINSTANCE.createTypePatternSubstitution();
        SubstitutionHelper.copySubstitutions(inputA, result);
        SubstitutionHelper.copySubstitutions(inputB, result);
        return result;
    }

    private static void copySubstitutions(TypePatternSubstitution input, TypePatternSubstitution result) {
        if (input == null) {
            return;
        }
        for (Substitution substitution : input.getSubstitutions()) {
            Substitution newSub = (Substitution)EcoreUtil.copy((EObject)substitution);
            result.getSubstitutions().add((Object)newSub);
        }
    }
}

