/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.dsl.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.polarsys.capella.scenario.editor.dsl.helpers.TextualScenarioHelper;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ArmTimerMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Block;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CreateMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.DeleteMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Element;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.FoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Function;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostFoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Message;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Operand;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Participant;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ParticipantDeactivation;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Reference;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessageType;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.StateFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.TextualScenarioPackage;
import org.polarsys.capella.scenario.editor.dsl.validation.AbstractTextualScenarioValidator;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class TextualScenarioValidator
extends AbstractTextualScenarioValidator {
    public static final String INVALID_NAME = "invalidName";
    public static final String DUPLICATED_NAME = "duplicatedName";
    public static final String DUPLICATED_MESSAGES_NAME = "duplicatedMessageName";
    public static final String SAME_SOURCE_AND_TARGET_ERROR = "Invalid element! Source and target must be different!";

    @Check
    public void checkPartExists(Participant participant) {
        boolean _not;
        boolean _contains = EmbeddedEditorInstanceHelper.getAvailablePartNames((String)participant.getKeyword()).contains(participant.getName());
        boolean bl = _not = !_contains;
        if (_not) {
            if (participant instanceof Function) {
                this.error("Function does not exist!", (EStructuralFeature)TextualScenarioPackage.Literals.PARTICIPANT__NAME, INVALID_NAME, new String[0]);
            } else {
                this.error("Represented part does not exist!", (EStructuralFeature)TextualScenarioPackage.Literals.PARTICIPANT__NAME, INVALID_NAME, new String[0]);
            }
        }
    }

    @Check
    public void checkParticipantKeywordIsValid(Participant participant) {
        boolean _not;
        boolean _checkValidKeyword = EmbeddedEditorInstanceHelper.checkValidKeyword((String)participant.getKeyword());
        boolean bl = _not = !_checkValidKeyword;
        if (_not) {
            String _keyword = participant.getKeyword();
            String _plus = "'" + _keyword;
            String _plus_1 = String.valueOf(_plus) + "' can not be used in this diagram!";
            this.error(_plus_1, (EStructuralFeature)TextualScenarioPackage.Literals.PARTICIPANT__KEYWORD);
        }
    }

    @Check
    public void checkMessagesExist(SequenceMessageType message) {
        boolean _not;
        boolean _contains = EmbeddedEditorInstanceHelper.getExchangeNames((String)message.getSource(), (String)message.getTarget()).contains(message.getName());
        boolean bl = _not = !_contains;
        if (_not) {
            String _source = message.getSource();
            String _plus = "Exchange does not exist between \"" + _source;
            String _plus_1 = String.valueOf(_plus) + "\" and \"";
            String _target = message.getTarget();
            String _plus_2 = String.valueOf(_plus_1) + _target;
            String _plus_3 = String.valueOf(_plus_2) + "\"!";
            this.error(_plus_3, (EStructuralFeature)TextualScenarioPackage.Literals.MESSAGE__NAME);
        }
    }

    @Check
    public void checkMessagesExist(LostMessage message) {
        boolean _not;
        boolean _contains = EmbeddedEditorInstanceHelper.getExchangeNames((String)message.getSource(), null).contains(message.getName());
        boolean bl = _not = !_contains;
        if (_not) {
            String _source = message.getSource();
            String _plus = "Exchange does not exist from \"" + _source;
            String _plus_1 = String.valueOf(_plus) + "\"!";
            this.error(_plus_1, (EStructuralFeature)TextualScenarioPackage.Literals.MESSAGE__NAME);
        }
    }

    @Check
    public void checkMessagesExist(FoundMessage message) {
        boolean _not;
        boolean _contains = EmbeddedEditorInstanceHelper.getExchangeNames(null, (String)message.getTarget()).contains(message.getName());
        boolean bl = _not = !_contains;
        if (_not) {
            String _target = message.getTarget();
            String _plus = "Exchange does not exist to \"" + _target;
            String _plus_1 = String.valueOf(_plus) + "\"!";
            this.error(_plus_1, (EStructuralFeature)TextualScenarioPackage.Literals.MESSAGE__NAME);
        }
    }

    @Check
    public void checkSequenceMessagesExchangeType(SequenceMessage sequenceMessage) {
        this.checkMessagesExchangeType(sequenceMessage);
    }

    @Check
    public void checkSequenceMessagesExchangeType(LostFoundMessage lostFoundMessage) {
        this.checkMessagesExchangeType(lostFoundMessage);
    }

    public void checkMessagesExchangeType(Message message) {
        EObject model;
        boolean _isESScenario = EmbeddedEditorInstanceHelper.isESScenario();
        if (_isESScenario && (model = TextualScenarioHelper.getModelContainer(message)) instanceof Model) {
            Set _allMessageExchangeType;
            Object scenarioExchangesType = TextualScenarioHelper.getScenarioAllowedExchangesType(((Model)model).getElements());
            Set exchangeTypes = _allMessageExchangeType = TextualScenarioHelper.getAllMessageExchangeType(message);
            if (scenarioExchangesType != null && !exchangeTypes.contains(scenarioExchangesType)) {
                this.error("Exchange type can not be used, expected " + scenarioExchangesType + "!", (EStructuralFeature)TextualScenarioPackage.Literals.MESSAGE__NAME);
            }
        }
    }

    @Check
    public void checkDuplicatedParticipantsNames(Model model) {
        int index = 0;
        HashSet names = CollectionLiterals.newHashSet();
        EList<Participant> _participants = model.getParticipants();
        for (Participant p : _participants) {
            boolean _not;
            boolean _add = names.add(this.getParticipantsMapKey(p));
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Duplicated participant!", (EStructuralFeature)TextualScenarioPackage.Literals.MODEL__PARTICIPANTS, index, DUPLICATED_NAME, new String[0]);
            }
            ++index;
        }
    }

    @Check
    public void checkDeactivateMessagesModel(Model model) {
        this.checkDeactivateMessages(model, CollectionLiterals.newLinkedList(), (List<Element>)model.getElements());
    }

    public void checkDeactivateMessages(EObject container, LinkedList<String> messageTargets, List<Element> elements) {
        int index = 0;
        for (Element obj : elements) {
            if (obj instanceof SequenceMessage && ((SequenceMessage)obj).getExecution() != null) {
                messageTargets.add(((SequenceMessage)obj).getTarget());
            }
            if (obj instanceof ArmTimerMessage && ((ArmTimerMessage)obj).getExecution() != null) {
                messageTargets.add(((ArmTimerMessage)obj).getParticipant());
            }
            if (obj instanceof FoundMessage && ((FoundMessage)obj).getExecution() != null) {
                messageTargets.add(((FoundMessage)obj).getTarget());
            }
            if (obj instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)obj;
                this.checkDeactivateMessages(cf.getBlock(), messageTargets, (List<Element>)cf.getBlock().getBlockElements());
                Consumer<Operand> _function = operand -> this.checkDeactivateMessages(operand.getBlock(), messageTargets, (List<Element>)operand.getBlock().getBlockElements());
                cf.getOperands().forEach(_function);
            }
            if (obj instanceof ParticipantDeactivation) {
                EReference refFeature = TextualScenarioPackage.Literals.MODEL__ELEMENTS;
                if (container instanceof Block) {
                    refFeature = TextualScenarioPackage.Literals.BLOCK__BLOCK_ELEMENTS;
                }
                this.showErrorDeactivateMessages((ParticipantDeactivation)obj, container, messageTargets, refFeature, index);
            }
            ++index;
        }
    }

    public String showErrorDeactivateMessages(ParticipantDeactivation deactivation, EObject container, LinkedList<String> messageTargets, EReference refFeature, int index) {
        String _xblockexpression = null;
        int indexOfTarget = messageTargets.lastIndexOf(deactivation.getName());
        String _xifexpression = null;
        if (indexOfTarget < 0) {
            this.error("Deactivation keyword not expected!", container, (EStructuralFeature)refFeature, index);
        } else {
            _xifexpression = messageTargets.remove(indexOfTarget);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public void checkDefinedTimelinesMessages(SequenceMessageType message) {
        boolean _not_1;
        boolean _not;
        ArrayList<String> participantsNames = TextualScenarioHelper.participantsDefinedBeforeNames(message);
        boolean _contains = participantsNames.contains(message.getSource());
        boolean bl = _not = !_contains;
        if (_not) {
            this.error(String.format("Timeline not defined in text editor!", new Object[0]), (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__SOURCE);
            return;
        }
        boolean _contains_1 = participantsNames.contains(message.getTarget());
        boolean bl2 = _not_1 = !_contains_1;
        if (_not_1) {
            this.error(String.format("Timeline not defined in text editor!", new Object[0]), (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__TARGET);
            return;
        }
    }

    @Check
    public void checkContainedTimelinesMessages(SequenceMessageType message) {
        EObject upContainer;
        EObject container = TextualScenarioHelper.getDirectContainer(message);
        if (container instanceof CombinedFragment && (upContainer = this.getUpperContainerCombinedFragmentTimelines(message, (CombinedFragment)container)) != null && upContainer instanceof CombinedFragment) {
            this.checkTimelinesMessages(message, (CombinedFragment)upContainer);
        }
    }

    public EObject getUpperContainerCombinedFragmentTimelines(SequenceMessageType message, CombinedFragment container) {
        if (container.getTimelines().contains((Object)message.getSource()) || container.getTimelines().contains((Object)message.getTarget())) {
            return container;
        }
        EObject upperContainer = TextualScenarioHelper.getDirectContainer(container);
        if (upperContainer instanceof CombinedFragment) {
            return this.getUpperContainerCombinedFragmentTimelines(message, (CombinedFragment)upperContainer);
        }
        return null;
    }

    public void checkTimelinesMessages(SequenceMessageType message, CombinedFragment container) {
        boolean _contains_1;
        boolean _not_1;
        boolean _not;
        String _keyword = container.getKeyword();
        String _plus = "Timeline not covered by this " + _keyword;
        String _plus_1 = String.valueOf(_plus) + "!";
        String _plus_2 = String.valueOf(_plus_1) + " Expected values in : ";
        EList<String> _timelines = container.getTimelines();
        String _plus_3 = String.valueOf(_plus_2) + _timelines;
        String msg = String.format(_plus_3, new Object[0]);
        boolean _contains = container.getTimelines().contains((Object)message.getSource());
        boolean bl = _not = !_contains;
        if (_not) {
            this.error(msg, (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__SOURCE);
        }
        boolean bl2 = _not_1 = !(_contains_1 = container.getTimelines().contains((Object)message.getTarget()));
        if (_not_1) {
            this.error(msg, (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__TARGET);
        }
    }

    @Check
    public void checkDeleteMessage(DeleteMessage deleteMessage) {
        this.checkCreateOrDeleteCouldBeUsed();
        this.checkSameSourceAndTarget(deleteMessage);
    }

    public void checkCreateOrDeleteCouldBeUsed() {
        if (EmbeddedEditorInstanceHelper.isFSScenario() || EmbeddedEditorInstanceHelper.isESScenario() && !EmbeddedEditorInstanceHelper.isInteractionScenario()) {
            this.error("Create or delete message can not be used in this diagram!", (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__ARROW);
        }
    }

    @Check
    public void checkArmTimer(ArmTimerMessage armTimer) {
        boolean _contains;
        boolean _not;
        boolean _isFSScenario = EmbeddedEditorInstanceHelper.isFSScenario();
        if (_isFSScenario) {
            this.error("Arm Timer can not be used in this diagram!", (EStructuralFeature)TextualScenarioPackage.Literals.ARM_TIMER_MESSAGE__ARROW);
        }
        boolean bl = _not = !(_contains = TextualScenarioHelper.participantsDefinedBeforeNames(armTimer).contains(armTimer.getParticipant()));
        if (_not) {
            this.error("Timeline not defined in text editor!", (EStructuralFeature)TextualScenarioPackage.Literals.ARM_TIMER_MESSAGE__PARTICIPANT);
        }
    }

    @Check
    public void checkLostMessage(LostMessage message) {
        boolean _contains;
        boolean _not_1;
        boolean _not;
        boolean _isESScenario = EmbeddedEditorInstanceHelper.isESScenario();
        boolean bl = _not = !_isESScenario;
        if (_not) {
            this.error("Lost message can not be used in this diagram!", (EStructuralFeature)TextualScenarioPackage.Literals.LOST_FOUND_MESSAGE__ARROW);
        }
        boolean bl2 = _not_1 = !(_contains = TextualScenarioHelper.participantsDefinedBeforeNames(message).contains(message.getSource()));
        if (_not_1) {
            this.error("Timeline not defined in text editor!", (EStructuralFeature)TextualScenarioPackage.Literals.LOST_MESSAGE__SOURCE);
        }
    }

    @Check
    public void checkFoundMessage(FoundMessage message) {
        boolean _contains;
        boolean _not_1;
        boolean _not;
        boolean _isESScenario = EmbeddedEditorInstanceHelper.isESScenario();
        boolean bl = _not = !_isESScenario;
        if (_not) {
            this.error("Found message can not be used in this diagram!", (EStructuralFeature)TextualScenarioPackage.Literals.LOST_FOUND_MESSAGE__ARROW);
        }
        boolean bl2 = _not_1 = !(_contains = TextualScenarioHelper.participantsDefinedBeforeNames(message).contains(message.getTarget()));
        if (_not_1) {
            this.error("Timeline not defined in text editor!", (EStructuralFeature)TextualScenarioPackage.Literals.FOUND_MESSAGE__TARGET);
        }
    }

    public void checkSameSourceAndTarget(SequenceMessageType message) {
        boolean _equals = message.getSource().equals(message.getTarget());
        if (_equals) {
            this.error(SAME_SOURCE_AND_TARGET_ERROR, (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__TARGET);
            this.error(SAME_SOURCE_AND_TARGET_ERROR, (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__SOURCE);
        }
    }

    @Check
    public void checkTimelineUsedAfterDeleteMessage(CombinedFragment combinedFragment) {
        EObject model = TextualScenarioHelper.getModelContainer(combinedFragment);
        if (model instanceof Model) {
            int index = 0;
            EList<String> _timelines = combinedFragment.getTimelines();
            for (String timeline : _timelines) {
                int _plusPlus = index++;
                this.checkElementAfterDelete((Model)model, combinedFragment, timeline, TextualScenarioPackage.Literals.COMBINED_FRAGMENT__TIMELINES, _plusPlus);
            }
        }
    }

    @Check
    public boolean checkTimelineUsedAfterDeleteMessage(StateFragment fragment) {
        boolean _xblockexpression = false;
        EObject model = TextualScenarioHelper.getModelContainer(fragment);
        boolean _xifexpression = false;
        if (model instanceof Model) {
            _xifexpression = this.checkElementAfterDelete((Model)model, fragment, fragment.getTimeline(), TextualScenarioPackage.Literals.STATE_FRAGMENT__TIMELINE, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public boolean checkParticipantUsedAfterDeleteMessage(ArmTimerMessage armTimer) {
        boolean _xblockexpression = false;
        EObject model = TextualScenarioHelper.getModelContainer(armTimer);
        boolean _xifexpression = false;
        if (model instanceof Model) {
            _xifexpression = this.checkElementAfterDelete((Model)model, armTimer, armTimer.getParticipant(), TextualScenarioPackage.Literals.ARM_TIMER_MESSAGE__PARTICIPANT, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public boolean checkParticipantUsedAfterLostMessage(LostMessage message) {
        boolean _xblockexpression = false;
        EObject model = TextualScenarioHelper.getModelContainer(message);
        boolean _xifexpression = false;
        if (model instanceof Model) {
            _xifexpression = this.checkElementAfterDelete((Model)model, message, message.getSource(), TextualScenarioPackage.Literals.LOST_MESSAGE__SOURCE, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public boolean checkParticipantUsedAfterFoundMessage(FoundMessage message) {
        boolean _xblockexpression = false;
        EObject model = TextualScenarioHelper.getModelContainer(message);
        boolean _xifexpression = false;
        if (model instanceof Model) {
            _xifexpression = this.checkElementAfterDelete((Model)model, message, message.getTarget(), TextualScenarioPackage.Literals.FOUND_MESSAGE__TARGET, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public boolean checkMessageSourceUsedAfterDeleteMessage(SequenceMessageType message) {
        boolean _xblockexpression = false;
        EObject model = TextualScenarioHelper.getModelContainer(message);
        boolean _xifexpression = false;
        if (model instanceof Model) {
            _xifexpression = this.checkElementAfterDelete((Model)model, message, message.getSource(), TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__SOURCE, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public boolean checkMessageTargetUsedAfterDeleteMessage(SequenceMessageType message) {
        boolean _xblockexpression = false;
        EObject model = TextualScenarioHelper.getModelContainer(message);
        boolean _xifexpression = false;
        if (model instanceof Model) {
            _xifexpression = this.checkElementAfterDelete((Model)model, message, message.getTarget(), TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__TARGET, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean checkElementAfterDelete(EObject model, EObject checkedElement, String target, EAttribute checkedAttribute, int index) {
        List<Element> elements = TextualScenarioHelper.getContainerElements(model);
        for (EObject eObject : elements) {
            boolean _checkElementAfterDelete;
            boolean _equals_1;
            boolean _equals = eObject.equals(checkedElement);
            if (_equals) {
                return true;
            }
            if (eObject instanceof DeleteMessage && (_equals_1 = ((DeleteMessage)eObject).getTarget().equals(target))) {
                this.error(String.format("Element \"" + target + "\" can not be used at this point! A delete message was already defined on this timeline.", new Object[0]), (EStructuralFeature)checkedAttribute, index);
                return true;
            }
            if (!(eObject instanceof CombinedFragment) || !(_checkElementAfterDelete = this.checkElementAfterDelete(eObject, checkedElement, target, checkedAttribute, index))) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkCreateMessage(CreateMessage createMessage) {
        this.checkCreateOrDeleteCouldBeUsed();
        this.checkSameSourceAndTarget(createMessage);
        EObject model = TextualScenarioHelper.getModelContainer(createMessage);
        if (model instanceof Model && !this.checkCreateMessageValid((Model)model, createMessage)) {
            this.errorCreateMessage(createMessage.getTarget());
        }
    }

    public boolean checkCreateMessageValid(EObject model, CreateMessage createMessage) {
        String target = createMessage.getTarget();
        List<Element> elements = TextualScenarioHelper.getContainerElements(model);
        for (EObject eObject : elements) {
            boolean _contains_1;
            boolean _equals_4;
            boolean _equals_3;
            boolean _equals_2;
            boolean _equals_1;
            if (eObject instanceof SequenceMessageType) {
                boolean _equals = ((SequenceMessageType)eObject).equals(createMessage);
                if (_equals) {
                    return true;
                }
                if (((SequenceMessageType)eObject).getTarget().equals(target) || ((SequenceMessageType)eObject).getSource().equals(target)) {
                    return false;
                }
            }
            if (eObject instanceof ArmTimerMessage && (_equals_1 = ((ArmTimerMessage)eObject).getParticipant().equals(target))) {
                return false;
            }
            if (eObject instanceof LostMessage && (_equals_2 = ((LostMessage)eObject).getSource().equals(target))) {
                return false;
            }
            if (eObject instanceof FoundMessage && (_equals_3 = ((FoundMessage)eObject).getTarget().equals(target))) {
                return false;
            }
            if (eObject instanceof CombinedFragment) {
                boolean _not;
                boolean _contains = ((CombinedFragment)eObject).getTimelines().contains((Object)target);
                if (_contains) {
                    return false;
                }
                boolean _checkCreateMessageValid = this.checkCreateMessageValid(eObject, createMessage);
                boolean bl = _not = Boolean.valueOf(_checkCreateMessageValid) == false;
                if (_not) {
                    return false;
                }
            }
            if (eObject instanceof StateFragment && (_equals_4 = ((StateFragment)eObject).getTimeline().equals(target))) {
                return false;
            }
            if (!(eObject instanceof Reference) || !(_contains_1 = ((Reference)eObject).getTimelines().contains((Object)target))) continue;
            return false;
        }
        return true;
    }

    public void errorCreateMessage(String target) {
        this.error(String.format("Target \"" + target + "\" can not be used in a create message at this point! Other operations were already defined on this timeline.", new Object[0]), (EStructuralFeature)TextualScenarioPackage.Literals.SEQUENCE_MESSAGE_TYPE__TARGET);
    }

    @Check
    public void checkStateFragment(StateFragment fragment) {
        boolean _not_1;
        boolean _not;
        boolean _contains = TextualScenarioHelper.participantsDefinedBeforeNames(fragment).contains(fragment.getTimeline());
        boolean bl = _not = !_contains;
        if (_not) {
            this.error(String.format("Timeline not defined in text editor!", fragment.getKeyword()), (EStructuralFeature)TextualScenarioPackage.Literals.STATE_FRAGMENT__TIMELINE);
            return;
        }
        String scenarioType = EmbeddedEditorInstanceHelper.getScenarioType();
        if (fragment.getKeyword().equals("function") && scenarioType.equals("FUNCTIONAL")) {
            this.error(String.format("'function' can not be used in this diagram!", new Object[0]), (EStructuralFeature)TextualScenarioPackage.Literals.STATE_FRAGMENT__KEYWORD);
            return;
        }
        List availableStateFragments = EmbeddedEditorInstanceHelper.getAvailableStateFragments((String)fragment.getKeyword(), (String)fragment.getTimeline());
        boolean _contains_1 = availableStateFragments.contains(fragment.getName());
        boolean bl2 = _not_1 = !_contains_1;
        if (_not_1) {
            String _keyword = fragment.getKeyword();
            String _plus = "This " + _keyword;
            String _plus_1 = String.valueOf(_plus) + " does not exist or is not available for \"";
            String _timeline = fragment.getTimeline();
            String _plus_2 = String.valueOf(_plus_1) + _timeline;
            String _plus_3 = String.valueOf(_plus_2) + "\"!";
            this.error(String.format(_plus_3, new Object[0]), (EStructuralFeature)TextualScenarioPackage.Literals.STATE_FRAGMENT__NAME);
        }
    }

    @Check
    public void checkWithExecutionHasDeactivateModel(Model model) {
        LinkedList messageWithExecutionTargets = CollectionLiterals.newLinkedList();
        LinkedList messageWithExecutionTargetsIndex = CollectionLiterals.newLinkedList();
        LinkedList messageWithExecutionTargetsContainer = CollectionLiterals.newLinkedList();
        this.checkWithExecutionHasDeactivate(model, messageWithExecutionTargets, messageWithExecutionTargetsIndex, messageWithExecutionTargetsContainer, (List<Element>)model.getElements());
        this.showErrorWithExecutionHasDeactivate(messageWithExecutionTargets, messageWithExecutionTargetsIndex, messageWithExecutionTargetsContainer);
    }

    public void showErrorWithExecutionHasDeactivate(LinkedList<String> messageWithExecutionTargets, LinkedList<Integer> messageWithExecutionTargetsIndex, LinkedList<EObject> messageWithExecutionTargetsContainer) {
        int i = 0;
        while (i < messageWithExecutionTargets.size()) {
            EObject container = messageWithExecutionTargetsContainer.get(i);
            if (container instanceof Model) {
                this.error("Deactivation keyword expected for a withExecution message!", container, (EStructuralFeature)TextualScenarioPackage.Literals.MODEL__ELEMENTS, messageWithExecutionTargetsIndex.get(i));
            } else if (container instanceof Block) {
                this.error("Deactivation keyword expected for a withExecution message!", container, (EStructuralFeature)TextualScenarioPackage.Literals.BLOCK__BLOCK_ELEMENTS, messageWithExecutionTargetsIndex.get(i));
            }
            ++i;
        }
    }

    public void checkWithExecutionHasDeactivate(EObject container, LinkedList<String> messageWithExecutionTargets, LinkedList<Integer> messageWithExecutionTargetsIndex, LinkedList<EObject> messageWithExecutionTargetsContainer, List<Element> elements) {
        int index = 0;
        for (Element obj : elements) {
            String targetName;
            int indexOfTarget;
            if (obj instanceof SequenceMessage && ((SequenceMessage)obj).getExecution() != null) {
                messageWithExecutionTargets.add(((SequenceMessage)obj).getTarget());
                messageWithExecutionTargetsIndex.add(index);
                messageWithExecutionTargetsContainer.add(container);
            }
            if (obj instanceof ArmTimerMessage && ((ArmTimerMessage)obj).getExecution() != null) {
                messageWithExecutionTargets.add(((ArmTimerMessage)obj).getParticipant());
                messageWithExecutionTargetsIndex.add(index);
                messageWithExecutionTargetsContainer.add(container);
            }
            if (obj instanceof FoundMessage && ((FoundMessage)obj).getExecution() != null) {
                messageWithExecutionTargets.add(((FoundMessage)obj).getTarget());
                messageWithExecutionTargetsIndex.add(index);
                messageWithExecutionTargetsContainer.add(container);
            }
            if (obj instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)obj;
                this.checkWithExecutionHasDeactivate(cf.getBlock(), messageWithExecutionTargets, messageWithExecutionTargetsIndex, messageWithExecutionTargetsContainer, (List<Element>)cf.getBlock().getBlockElements());
                Consumer<Operand> _function = operand -> this.checkWithExecutionHasDeactivate(operand.getBlock(), messageWithExecutionTargets, messageWithExecutionTargetsIndex, messageWithExecutionTargetsContainer, (List<Element>)operand.getBlock().getBlockElements());
                cf.getOperands().forEach(_function);
            }
            if (obj instanceof ParticipantDeactivation && (indexOfTarget = messageWithExecutionTargets.lastIndexOf(targetName = ((ParticipantDeactivation)obj).getName())) >= 0) {
                messageWithExecutionTargets.remove(indexOfTarget);
                messageWithExecutionTargetsIndex.remove(indexOfTarget);
                messageWithExecutionTargetsContainer.remove(indexOfTarget);
            }
            ++index;
        }
    }

    @Check
    public void checkElseKeyworkAvailable(Operand operand) {
        EObject _eContainer_1;
        CombinedFragment combinedFragment;
        EObject _eContainer = operand.eContainer();
        if (_eContainer instanceof CombinedFragment && Objects.equal((Object)(combinedFragment = (CombinedFragment)(_eContainer_1 = operand.eContainer())).getKeyword(), (Object)"alt") && !combinedFragment.getOperands().isEmpty()) {
            boolean _notEquals;
            String _keyword = operand.getKeyword();
            boolean bl = _notEquals = !Objects.equal((Object)_keyword, (Object)"else");
            if (_notEquals) {
                this.error("Expected 'else' keyword!", (EStructuralFeature)TextualScenarioPackage.Literals.OPERAND__KEYWORD);
            }
        }
    }

    @Check
    public void checkKeyworkNotAvailable(Operand operand) {
        EObject _eContainer_1;
        CombinedFragment combinedFragment;
        EObject _eContainer = operand.eContainer();
        if (!(!(_eContainer instanceof CombinedFragment) || Objects.equal((Object)(combinedFragment = (CombinedFragment)(_eContainer_1 = operand.eContainer())).getKeyword(), (Object)"alt") || combinedFragment.getOperands().isEmpty() || operand.getKeyword() == null && operand.getKeyword().isEmpty())) {
            this.error("Unexpected keyword!", (EStructuralFeature)TextualScenarioPackage.Literals.OPERAND__KEYWORD);
        }
    }

    @Check
    public void checkCombinedFragmentOnValidTimelines(CombinedFragment combinedFragment) {
        ArrayList<String> participantsDefined = TextualScenarioHelper.participantsDefinedBeforeNames(combinedFragment);
        int index = 0;
        EList<String> _timelines = combinedFragment.getTimelines();
        for (String timeline : _timelines) {
            boolean _not;
            boolean _contains = participantsDefined.contains(timeline);
            boolean bl = _not = !_contains;
            if (_not) {
                this.error("Timeline not defined in text editor!", (EStructuralFeature)TextualScenarioPackage.Literals.COMBINED_FRAGMENT__TIMELINES, index);
            }
            ++index;
        }
    }

    @Check
    public void checkContainedCombinedFragment(CombinedFragment combinedFragment) {
        EObject upperContainer;
        EObject container = TextualScenarioHelper.getDirectContainer(combinedFragment);
        if (container instanceof CombinedFragment && (upperContainer = this.getContainerCombinedFragmentTimelines((List<String>)combinedFragment.getTimelines(), (CombinedFragment)container)) != null && upperContainer instanceof CombinedFragment) {
            String _keyword = combinedFragment.getKeyword();
            String _plus = "Timelines covered by this " + _keyword;
            String _plus_1 = String.valueOf(_plus) + " must be a subset of the parent covered timelines ";
            EList<String> _timelines = ((CombinedFragment)upperContainer).getTimelines();
            String _plus_2 = String.valueOf(_plus_1) + _timelines;
            String _plus_3 = String.valueOf(_plus_2) + "!";
            this.error(_plus_3, (EStructuralFeature)TextualScenarioPackage.Literals.COMBINED_FRAGMENT__TIMELINES);
        }
    }

    @Check
    public void checkReference(Reference reference) {
        EObject model;
        EObject upperContainer;
        EObject container;
        boolean _not;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int index = 0;
        EList<String> _timelines = reference.getTimelines();
        for (String timeline : _timelines) {
            Integer _get = (Integer)hashMap.get(timeline);
            boolean _equals = Objects.equal((Object)_get, null);
            if (_equals) {
                hashMap.put(timeline, 1);
            } else {
                this.error("Duplicated timeline!", (EStructuralFeature)TextualScenarioPackage.Literals.REFERENCE__TIMELINES, index);
            }
            ++index;
        }
        ArrayList<String> participantsDefined = TextualScenarioHelper.participantsDefinedBeforeNames(reference);
        index = 0;
        EList<String> _timelines_1 = reference.getTimelines();
        for (String timeline_1 : _timelines_1) {
            boolean _not2;
            boolean _contains = participantsDefined.contains(timeline_1);
            boolean bl = _not2 = !_contains;
            if (_not2) {
                this.error("Timeline not defined in text editor!", (EStructuralFeature)TextualScenarioPackage.Literals.REFERENCE__TIMELINES, index);
            }
            ++index;
        }
        boolean _contains = EmbeddedEditorInstanceHelper.getReferencedScenariosName().contains(reference.getName());
        boolean bl = _not = !_contains;
        if (_not) {
            this.error("Referenced scenario does not exist!", (EStructuralFeature)TextualScenarioPackage.Literals.REFERENCE__NAME);
        }
        if ((container = TextualScenarioHelper.getDirectContainer(reference)) instanceof CombinedFragment && (upperContainer = this.getContainerCombinedFragmentTimelines((List<String>)reference.getTimelines(), (CombinedFragment)container)) != null && upperContainer instanceof CombinedFragment) {
            EList<String> _timelines_2 = ((CombinedFragment)upperContainer).getTimelines();
            String _plus = "Timelines covered by this reference must be a subset of the parent covered timelines " + _timelines_2;
            String _plus_1 = String.valueOf(_plus) + "!";
            this.error(_plus_1, (EStructuralFeature)TextualScenarioPackage.Literals.REFERENCE__TIMELINES);
        }
        if ((model = TextualScenarioHelper.getModelContainer(reference)) instanceof Model) {
            index = 0;
            EList<String> _timelines_3 = reference.getTimelines();
            for (String timeline_2 : _timelines_3) {
                int _plusPlus = index++;
                this.checkElementAfterDelete((Model)model, reference, timeline_2, TextualScenarioPackage.Literals.REFERENCE__TIMELINES, _plusPlus);
            }
        }
    }

    public EObject getContainerCombinedFragmentTimelines(List<String> timelines, CombinedFragment container) {
        if (this.innerCombinedFragment(timelines, container) && !this.isASubset(timelines, (List<String>)container.getTimelines())) {
            return container;
        }
        EObject upperContainer = TextualScenarioHelper.getDirectContainer(container);
        if (upperContainer instanceof CombinedFragment) {
            return this.getContainerCombinedFragmentTimelines(timelines, (CombinedFragment)upperContainer);
        }
        return null;
    }

    public boolean isASubset(List<String> smallList, List<String> containerList) {
        for (String element : smallList) {
            boolean _not;
            boolean _contains = containerList.contains(element);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            return false;
        }
        return true;
    }

    public boolean isASublist(List<String> smallList, List<String> containerList) {
        int i = 0;
        while (i < containerList.size()) {
            int _size;
            int _plus;
            List<String> subset;
            if (i < containerList.size() && i + smallList.size() <= containerList.size() && (subset = containerList.subList(i, _plus = i + (_size = smallList.size()))) != null && smallList.equals(subset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean innerCombinedFragment(List<String> timelines, CombinedFragment container) {
        for (String timeline : timelines) {
            boolean _contains = container.getTimelines().contains((Object)timeline);
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public String getParticipantsMapKey(Participant p) {
        String _name = p.getName();
        String _plus = String.valueOf(_name) + ":";
        String _keyword = p.getKeyword();
        return String.valueOf(_plus) + _keyword;
    }

    public String getElementMapKey(EObject element) {
        if (element instanceof CombinedFragment) {
            String _keyword = ((CombinedFragment)element).getKeyword();
            String _expression = ((CombinedFragment)element).getExpression();
            String key = String.valueOf(_keyword) + _expression;
            List _sort = IterableExtensions.sort((Iterable)IterableExtensions.toSet(((CombinedFragment)element).getTimelines()));
            for (String timeline : _sort) {
                key = String.valueOf(key) + ":" + timeline;
            }
            return key;
        }
        if (element instanceof SequenceMessageType) {
            String _name = ((SequenceMessageType)element).getName();
            String _plus = String.valueOf(_name) + ":";
            String _arrow = ((SequenceMessageType)element).getArrow();
            String _plus_1 = String.valueOf(_plus) + _arrow;
            String _plus_2 = String.valueOf(_plus_1) + ":";
            String _source = ((SequenceMessageType)element).getSource();
            String _plus_3 = String.valueOf(_plus_2) + _source;
            String _plus_4 = String.valueOf(_plus_3) + ":";
            String _target = ((SequenceMessageType)element).getTarget();
            return String.valueOf(_plus_4) + _target;
        }
        if (element instanceof ArmTimerMessage) {
            String _participant = ((ArmTimerMessage)element).getParticipant();
            String _plus_5 = String.valueOf(_participant) + ":";
            String _name_1 = ((ArmTimerMessage)element).getName();
            return String.valueOf(_plus_5) + _name_1;
        }
        return null;
    }
}

