/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.multiphases;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.transition.system2subsystem.tests.TraceabilityArchitectureSID;
import org.polarsys.capella.transition.system2subsystem.tests.multiphases.MultiPhasesTest;

public abstract class ManagementPropertiesTest
extends MultiPhasesTest {
    public static final String PC_1 = "a3abe83b-203f-44e5-83ef-733d11ae1c3a";

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("testManagementProps", "output");
    }

    @Override
    protected Collection<?> getProjectionElements() {
        return this.getObjects(new String[]{PC_1});
    }

    private void checkTargetNullValues(boolean checkReview, boolean checkStatus, boolean isVisibleDoc, boolean isVisibleLM) {
        CapellaElement target = (CapellaElement)this.retrieveTargetElement(PC_1);
        if (checkReview) {
            ManagementPropertiesTest.assertNull((Object)target.getReview());
        }
        if (checkStatus) {
            ManagementPropertiesTest.assertNull((Object)target.getStatus());
        }
        ManagementPropertiesTest.assertEquals((boolean)target.isVisibleInDoc(), (boolean)isVisibleDoc);
        ManagementPropertiesTest.assertEquals((boolean)target.isVisibleInLM(), (boolean)isVisibleLM);
    }

    private void matchAttributeValues(boolean checkReview, boolean checkStatus, boolean checkVisibleDoc, boolean checkVisibleLM) {
        EObject source = this.retrieveReferenceElement(PC_1);
        EObject target = this.retrieveTargetElement(PC_1);
        if (checkStatus) {
            ManagementPropertiesTest.assertEquals((String)((CapellaElement)source).getStatus().getName(), (String)((CapellaElement)target).getStatus().getName());
        }
        if (checkReview) {
            this.testAttributeIdentity(source, target, CapellacorePackage.Literals.CAPELLA_ELEMENT__REVIEW);
        }
        if (checkVisibleDoc) {
            this.testAttributeIdentity(source, target, ModellingcorePackage.Literals.PUBLISHABLE_ELEMENT__VISIBLE_IN_DOC);
        }
        if (checkVisibleLM) {
            this.testAttributeIdentity(source, target, ModellingcorePackage.Literals.PUBLISHABLE_ELEMENT__VISIBLE_IN_LM);
        }
    }

    public static class TransitionAll
    extends ManagementPropertiesTest {
        @Override
        public void setUp() throws Exception {
            super.setUp();
            this.addSharedParameter("managementExport.progressStatus", Boolean.TRUE);
            this.addSharedParameter("managementExport.review", Boolean.TRUE);
            this.addSharedParameter("managementExport.visibleForTraceability", Boolean.TRUE);
            this.addSharedParameter("managementExport.visibleInDocumentation", Boolean.TRUE);
        }

        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            super.matchAttributeValues(true, true, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            super.matchAttributeValues(true, true, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            super.matchAttributeValues(true, true, true, true);
        }
    }

    public static class TransitionDefaultFalsePreferences
    extends ManagementPropertiesTest {
        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            super.checkTargetNullValues(true, true, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            super.checkTargetNullValues(true, true, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            super.checkTargetNullValues(true, true, true, true);
        }
    }

    public static class TransitionReview
    extends ManagementPropertiesTest {
        @Override
        public void setUp() throws Exception {
            super.setUp();
            this.addSharedParameter("managementExport.review", Boolean.TRUE);
        }

        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            super.matchAttributeValues(true, false, false, false);
            super.checkTargetNullValues(false, true, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            super.matchAttributeValues(true, false, false, false);
            super.checkTargetNullValues(false, true, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            super.matchAttributeValues(true, false, false, false);
            super.checkTargetNullValues(false, true, true, true);
        }
    }

    public static class TransitionStatus
    extends ManagementPropertiesTest {
        @Override
        public void setUp() throws Exception {
            super.setUp();
            this.addSharedParameter("managementExport.progressStatus", Boolean.TRUE);
        }

        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            super.matchAttributeValues(false, true, false, false);
            super.checkTargetNullValues(true, false, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            super.matchAttributeValues(false, true, false, false);
            super.checkTargetNullValues(true, false, true, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            super.matchAttributeValues(false, true, false, false);
            super.checkTargetNullValues(true, false, true, true);
        }
    }

    public static class TransitionVisibleInDoc
    extends ManagementPropertiesTest {
        @Override
        public void setUp() throws Exception {
            super.setUp();
            this.addSharedParameter("managementExport.visibleInDocumentation", Boolean.TRUE);
        }

        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            super.matchAttributeValues(false, false, true, false);
            super.checkTargetNullValues(false, false, false, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            super.matchAttributeValues(false, false, true, false);
            super.checkTargetNullValues(false, false, false, true);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            super.matchAttributeValues(false, false, true, false);
            super.checkTargetNullValues(false, false, false, true);
        }
    }

    public static class TransitionVisibleInLM
    extends ManagementPropertiesTest {
        @Override
        public void setUp() throws Exception {
            super.setUp();
            this.addSharedParameter("managementExport.visibleForTraceability", Boolean.TRUE);
        }

        @Override
        protected void verify() throws Exception {
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.SA);
            super.matchAttributeValues(false, false, false, true);
            super.checkTargetNullValues(false, false, true, false);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.LA);
            super.matchAttributeValues(false, false, false, true);
            super.checkTargetNullValues(false, false, true, false);
            ((TraceabilityArchitectureSID)this.traceability).setArchitecture(BlockArchitectureExt.Type.PA);
            super.matchAttributeValues(false, false, false, true);
            super.checkTargetNullValues(false, false, true, false);
        }
    }
}

