/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMergePolicy;
import org.eclipse.emf.diffmerge.impl.scopes.RootedModelScope;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;

public class DiffHelper {
    IMatchPolicy matchPolicy = null;

    public IMatchPolicy getMatchPolicy() {
        if (this.matchPolicy == null) {
            this.matchPolicy = new DefaultMatchPolicy(){

                public boolean keepMatchIDs() {
                    return true;
                }
            };
        }
        return this.matchPolicy;
    }

    public DiffHelper setMatchPolicy(IMatchPolicy matchPolicy) {
        this.matchPolicy = matchPolicy;
        return this;
    }

    public Collection<IDifference> getDifferences(IFile file1, IFile file2) {
        ResourceSet set2 = new ExecutionManager().getEditingDomain().getResourceSet();
        Resource outputModelResource1 = set2.getResource(EcoreUtil2.getURI((IFile)file1), true);
        Resource outputModelResource2 = set2.getResource(EcoreUtil2.getURI((IFile)file2), true);
        RootedModelScope source = new RootedModelScope((List)outputModelResource1.getContents());
        RootedModelScope target = new RootedModelScope((List)outputModelResource2.getContents());
        EComparisonImpl impl = new EComparisonImpl((IEditableTreeDataScope)target, (IEditableTreeDataScope)source);
        impl.compute(this.getMatchPolicy(), (IDiffPolicy)new DefaultDiffPolicy(){

            protected boolean considerOrderedFeature(EStructuralFeature feature_p) {
                return false;
            }
        }, (IMergePolicy)new DefaultMergePolicy(), (IProgressMonitor)new NullProgressMonitor());
        HashSet<IDifference> differences = new HashSet<IDifference>();
        differences.addAll(impl.getDifferences(Role.REFERENCE));
        differences.addAll(impl.getDifferences(Role.TARGET));
        return differences;
    }

    public static IFile copyFile(IFile file) {
        IFile file2 = file.getParent().getFile(file.getProjectRelativePath().addFileExtension("bkp").addFileExtension(file.getFileExtension()));
        try {
            file2.create(file.getContents(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file2;
    }
}

