/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.categories.RelationIdentifierCategory;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ModelDiffTestCase2
extends BasicTestCase {
    private static final String systemAnalysis = "24658239-7734-4c39-9402-83325c52d04c";
    private static final String inputFileName = "model/inputs/Sample1.reqif";
    private static final String projectTestName = "MultipleImports";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() throws Exception {
        SessionContext session = new SessionContext(this.getSession(projectTestName));
        final BlockArchitecture target = (BlockArchitecture)session.getSemanticElement(systemAnalysis);
        final TestRequirementsImportLauncher testRequirementsImportLauncher = new TestRequirementsImportLauncher();
        TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                File file = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)ModelDiffTestCase2.inputFileName);
                URI model = URI.createFileURI((String)file.getPath());
                testRequirementsImportLauncher.launch(model, target, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        IContext context = testRequirementsImportLauncher.getContext();
        List differences = (List)context.get((Object)"DIFFERENCES_FROM_REFERENCE_SCOPE");
        RelationIdentifierCategory relationIdentifierCategoryFilter = new RelationIdentifierCategory();
        List filteredDifferences = differences.stream().filter(d -> !relationIdentifierCategoryFilter.covers(d, null)).collect(Collectors.toList());
        ModelDiffTestCase2.assertTrue((String)"There should not be any differences when Sample1.reqif is imported to Capella model", (boolean)filteredDifferences.isEmpty());
    }
}

