/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.mapping.Messages;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingBridge;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQuery;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryIdentifier;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRule;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.MappingCause;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.MappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.QueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.util.QueryLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.mapping.util.RuleLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.operations.AbstractBridgeOperation;
import org.eclipse.emf.diffmerge.bridge.util.INormalizableModelScope;

public class MappingBridgeOperation
extends AbstractBridgeOperation {
    public MappingBridgeOperation(Object sourceDataSet_p, Object targetDataSet_p, IMappingBridge<?, ?> bridge_p, IBridgeExecution execution_p) {
        super(sourceDataSet_p, targetDataSet_p, bridge_p, execution_p);
    }

    protected QueryExecution createQueryExecution() {
        QueryExecution rootQueryEnv = new QueryExecution();
        return rootQueryEnv;
    }

    public IMappingBridge<?, ?> getBridge() {
        return (IMappingBridge)super.getBridge();
    }

    public MappingExecution getBridgeExecution() {
        return (MappingExecution)super.getBridgeExecution();
    }

    protected int getWorkAmount() {
        return this.getBridge().getWorkAmount(this.getSourceDataSet(), this.getTargetDataSet());
    }

    protected void handleBridge(IMappingBridge<?, ?> bridge_p, MappingExecution execution_p, Object sourceDataSet_p, Object targetDataSet_p) {
        execution_p.setTargetDataSet(targetDataSet_p);
        QueryExecution rootQueryEnv = this.createQueryExecution();
        this.getLogger().info((Object)Messages.BridgeLogger_TargetCreationStepMessage);
        this.handleQueriesForTargetCreationRec(bridge_p.getQueries(), bridge_p, sourceDataSet_p, targetDataSet_p, rootQueryEnv, execution_p);
        bridge_p.targetsCreated(targetDataSet_p);
        this.getLogger().info((Object)Messages.BridgeLogger_TargetDefinitionStepMessage);
        this.handleTargetDefinitions(execution_p);
        if (targetDataSet_p instanceof INormalizableModelScope) {
            ((INormalizableModelScope)targetDataSet_p).normalize();
        }
        bridge_p.targetsDefined(targetDataSet_p);
        execution_p.setStatus(Status.OK_STATUS);
    }

    protected void handleQueriesForTargetCreationRec(Collection<? extends IQuery<?, ?>> queries_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        for (IQuery<?, ?> query : queries_p) {
            this.handleQueryForTargetCreationRec(query, bridge_p, source_p, targetDataSet_p, queryExecution_p, execution_p);
        }
    }

    protected void handleQueryForTargetCreationRec(IQuery<?, ?> query_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        this.checkProgress();
        Iterable<?> queryResultIterable = query_p.evaluate(source_p, queryExecution_p);
        Iterator<?> queryResultIterator = queryResultIterable.iterator();
        if (queryResultIterator.hasNext()) {
            IQueryIdentifier queryID = (IQueryIdentifier)query_p.getID();
            while (queryResultIterator.hasNext()) {
                Object queryResult = queryResultIterator.next();
                QueryExecution newQueryEnv = queryExecution_p.newWith(queryID, queryResult);
                this.handleQueryForTargetCreation(query_p, bridge_p, queryResult, targetDataSet_p, newQueryEnv, execution_p);
                this.handleQueriesForTargetCreationRec(query_p.getQueries(), bridge_p, queryResult, targetDataSet_p, newQueryEnv, execution_p);
            }
        }
    }

    protected void handleQueryForTargetCreation(IQuery<?, ?> query_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        this.getLogger().info((Object)new QueryLoggingMessage(queryExecution_p));
        for (IRule<?, ?, ?> rule : query_p.getRules()) {
            this.handleRuleForTargetCreation(rule, bridge_p, source_p, targetDataSet_p, queryExecution_p, execution_p);
        }
        this.getMonitor().worked(1);
    }

    protected void handleRuleForTargetCreation(IRule<?, ?, ?> rule_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        this.checkProgress();
        MappingCause cause = new MappingCause(queryExecution_p, source_p, rule_p);
        if (!execution_p.isTolerantToDuplicates() || !execution_p.isRegistered((ICause<?>)cause)) {
            this.getLogger().info((Object)new RuleLoggingMessage(rule_p, RuleLoggingMessage.Step.TargetCreation, queryExecution_p));
            Object target = rule_p.createTarget(source_p, queryExecution_p);
            execution_p.put((ICause<?>)cause, target);
        }
    }

    protected void handleTargetDefinitions(MappingExecution execution_p) {
        Set<Object> pendingSources = execution_p.getPendingSources();
        for (Object traceSource : pendingSources) {
            this.handleRuleForTargetDefinitions(traceSource, execution_p);
        }
        int nbPendingSources = pendingSources.size();
        int remainingProgress = Math.max(0, this.getBridge().getNbRules() - nbPendingSources);
        this.getMonitor().worked(remainingProgress);
    }

    protected void handleRuleForTargetDefinitions(Object source_p, MappingExecution execution_p) {
        Map<IRule<?, ?, ?>, MappingExecution.PendingDefinition> pendingDefinitions = execution_p.getPendingDefinitions(source_p);
        for (Map.Entry<IRule<?, ?, ?>, MappingExecution.PendingDefinition> entry : pendingDefinitions.entrySet()) {
            MappingExecution.PendingDefinition pendingDef = entry.getValue();
            this.handleRuleForTargetDefinition(entry.getKey(), pendingDef, execution_p);
            this.registerTarget(entry.getValue(), source_p, entry.getKey(), execution_p);
        }
    }

    protected void handleRuleForTargetDefinition(IRule<?, ?, ?> rule_p, MappingExecution.PendingDefinition pendingDef_p, MappingExecution execution_p) {
        this.checkProgress();
        this.getLogger().info((Object)new RuleLoggingMessage(rule_p, RuleLoggingMessage.Step.TargetDefinition, pendingDef_p.getQueryExecution()));
        rule_p.defineTarget(pendingDef_p.getQueryExecution().getLast(), pendingDef_p.getTarget(), pendingDef_p.getQueryExecution(), execution_p);
        this.getMonitor().worked(1);
    }

    protected void registerTarget(MappingExecution.PendingDefinition pendingDef_p, Object source_p, IRule<?, ?, ?> rule_p, MappingExecution execution_p) {
        MappingCause cause = new MappingCause(pendingDef_p.getQueryExecution(), source_p, rule_p);
        execution_p.putInTrace((ICause<?>)cause, pendingDef_p.getTarget());
    }

    public IStatus run() {
        IStatus result;
        this.getMonitor().worked(1);
        try {
            this.handleBridge((IMappingBridge<?, ?>)this.getBridge(), this.getBridgeExecution(), this.getSourceDataSet(), this.getTargetDataSet());
            result = Status.OK_STATUS;
        }
        catch (OperationCanceledException e) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }
}

