/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.model.migration;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.core.data.migration.Messages;
import org.polarsys.capella.core.data.migration.MigrationJobScheduler;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.handlers.AbstractMigrationHandler;
import org.polarsys.capella.vp.requirements.model.helpers.TraceHelper;
import org.polarsys.capella.vp.requirements.model.migration.TraceMigrationRunnable;

public class TraceMigrationHandler
extends AbstractMigrationHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFile) {
                IFile traceFile = (IFile)element;
                MigrationContext context = new MigrationContext();
                context.setName(NLS.bind((String)Messages.MigrationAction_Title, (Object)traceFile.getName()));
                context.setShell(HandlerUtil.getActiveShell((ExecutionEvent)event));
                context.setSkipConfirmation(false);
                context.setBackupModel(false);
                TraceMigrationRunnable migrationRunnable = new TraceMigrationRunnable(traceFile);
                LinkedList<TraceMigrationRunnable> runnables = new LinkedList<TraceMigrationRunnable>();
                runnables.add(migrationRunnable);
                new MigrationJobScheduler().run(runnables, context, true, false);
            }
            ++n2;
        }
        return event;
    }

    protected boolean isValidSelection(List<Object> selection) {
        return selection.stream().allMatch(o -> o instanceof IFile && TraceHelper.isLegacyTraceResource((IResource)((IFile)o)));
    }
}

