/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQuery;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryHolder;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryIdentifier;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRule;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.AbstractQueryHolder;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.QueryIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query<I, O>
extends AbstractQueryHolder<O>
implements IQuery<I, O> {
    private final IQueryIdentifier<O> _identifier;
    private final IQueryHolder<? extends I> _holder;
    private final Set<IRule<? super O, ?, ?>> _rules;

    public Query(IQueryHolder<? extends I> parent_p) {
        this(parent_p, (IQueryIdentifier<O>)null);
    }

    public Query(IQueryHolder<? extends I> parent_p, String id_p) {
        this(parent_p, new QueryIdentifier(id_p));
    }

    public Query(IQueryHolder<? extends I> parent_p, IQueryIdentifier<O> id_p) {
        this._holder = parent_p;
        parent_p.accept(this);
        this._identifier = id_p != null ? id_p : this.getDefaultID();
        this._rules = new LinkedHashSet();
    }

    @Override
    public void accept(IRule<? super O, ?, ?> rule_p) {
        this._rules.add(rule_p);
    }

    @Override
    public final IQueryHolder<? extends I> getInputProvider() {
        return this._holder;
    }

    protected IQueryIdentifier<O> getDefaultID() {
        return new QueryIdentifier(this.getClass().getSimpleName());
    }

    public IQueryIdentifier<O> getID() {
        return this._identifier;
    }

    @Override
    public Collection<IRule<? super O, ?, ?>> getRules() {
        return Collections.unmodifiableCollection(this._rules);
    }

    public Object getSymbol(ISymbolFunction function_p) {
        return function_p.getSymbol(this.getID());
    }
}

