/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ThreatKind implements Enumerator
{
    EAVESDROPPING(0, "Eavesdropping", "EAVESDROPPING"),
    THEFT_AND_DATA_ALTERATION(1, "Theft_and_data_alteration", "THEFT_AND_DATA_ALTERATION"),
    DENIAL_OF_SERVICE(2, "Denial_of_service", "DENIAL_OF_SERVICE"),
    INTRUSION(3, "Intrusion", "INTRUSION"),
    TAMPERING(4, "Tampering", "TAMPERING");

    public static final int EAVESDROPPING_VALUE = 0;
    public static final int THEFT_AND_DATA_ALTERATION_VALUE = 1;
    public static final int DENIAL_OF_SERVICE_VALUE = 2;
    public static final int INTRUSION_VALUE = 3;
    public static final int TAMPERING_VALUE = 4;
    private static final ThreatKind[] VALUES_ARRAY;
    public static final List<ThreatKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ThreatKind[]{EAVESDROPPING, THEFT_AND_DATA_ALTERATION, DENIAL_OF_SERVICE, INTRUSION, TAMPERING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ThreatKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThreatKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThreatKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ThreatKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ThreatKind get(int value) {
        switch (value) {
            case 0: {
                return EAVESDROPPING;
            }
            case 1: {
                return THEFT_AND_DATA_ALTERATION;
            }
            case 2: {
                return DENIAL_OF_SERVICE;
            }
            case 3: {
                return INTRUSION;
            }
            case 4: {
                return TAMPERING;
            }
        }
        return null;
    }

    private ThreatKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

