/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.rules.testcases.cy_dcov;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.ComponentTemplate1;
import org.polarsys.capella.cybersecurity.test.common.DynamicValidationTest;

public class Rule_CY_DCOV_01
extends DynamicValidationTest {
    private static final String RULE = "org.polarsys.capella.cybersecurity.validation.CY_DCOV_01";
    CybersecurityServices service = new CybersecurityServices();
    Component threatSource;

    @Override
    protected void initModel(CapellaModelSkeleton skeleton) {
        ComponentTemplate1 t = new ComponentTemplate1(skeleton, this);
        this.threatSource = t.component;
    }

    public void test() throws Exception {
        Rule_CY_DCOV_01.assertNotNull((Object)this.threatSource);
        this.ok((EObject)this.threatSource, RULE);
        TrustBoundaryStorage storage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
        this.executeCommand(() -> this.threatSource.getOwnedExtensions().add((Object)storage));
        this.ok((EObject)this.threatSource, RULE);
        this.executeCommand(() -> storage.setThreatSource(true));
        this.ko((EObject)this.threatSource, RULE);
        this.executeCommand(() -> {
            Threat threat = this.service.createThreat((EObject)this.threatSource, this.project);
            this.service.createThreatInvolvement(threat, this.threatSource);
        });
        this.ok((EObject)this.threatSource, RULE);
    }
}

