/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.fs2es;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.resolver.ResolverFinalizer;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.ScenarioTransfo;
import org.polarsys.capella.core.projection.scenario.helpers.ScenarioHorizontalHelper;
import org.polarsys.capella.core.tiger.ITransfo;

public class FS2ESHelper
extends ScenarioHorizontalHelper {
    private Collection<Component> getAllocatingBlocks(AbstractFunction function) {
        HashSet<Component> allocatingBlocks = new HashSet<Component>();
        for (ComponentFunctionalAllocation allocation : function.getComponentFunctionalAllocations()) {
            AbstractFunctionalBlock block = allocation.getBlock();
            if (!(block instanceof Component)) continue;
            Component element = (Component)block;
            allocatingBlocks.add(element);
        }
        if (function instanceof OperationalActivity) {
            for (ComponentFunctionalAllocation allocation : ((OperationalActivity)function).getActivityAllocations()) {
                Role allocatingRole = allocation.getRole();
                if (allocatingRole == null) continue;
                for (RoleAllocation roleAllocation : allocatingRole.getRoleAllocations()) {
                    if (roleAllocation.getEntity() == null) continue;
                    allocatingBlocks.add((Component)roleAllocation.getEntity());
                }
            }
        }
        return allocatingBlocks;
    }

    private AbstractInstance getRelatedPart(InstanceRole role, AbstractFunction function, ITransfo transfo) {
        ArrayList elements = new ArrayList();
        boolean isMultiAllocation = false;
        int nbAllocation = 0;
        Collection<Component> allocatingBlocks = this.getAllocatingBlocks(function);
        Iterator leafs = ((List)ModelCache.getCache(FunctionExt::getAllLeafAbstractFunctions, (Object)function)).iterator();
        if (leafs.hasNext()) {
            AbstractFunction leaf = (AbstractFunction)leafs.next();
            Collection<Component> leafAllocatingBlocks = this.getAllocatingBlocks(leaf);
            while (leafs.hasNext() && leafAllocatingBlocks.size() > 0) {
                leaf = (AbstractFunction)leafs.next();
                leafAllocatingBlocks.retainAll(this.getAllocatingBlocks(leaf));
            }
            allocatingBlocks.addAll(leafAllocatingBlocks);
        }
        for (Component element : allocatingBlocks) {
            if (element.getRepresentingParts().size() <= 0) continue;
            ++nbAllocation;
            elements.addAll(element.getRepresentingParts());
        }
        boolean bl = isMultiAllocation = nbAllocation > 1;
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return (AbstractInstance)elements.get(0);
        }
        ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo);
        if (resolver == null) {
            return (AbstractInstance)elements.get(0);
        }
        String message = "";
        message = isMultiAllocation ? Messages.Rule_InstanceRole_AllocatedMoreThanOnce : Messages.Rule_InstanceRole_AllocatingMultipart;
        message = String.valueOf(message) + Messages.Rule_InstanceRole_Selection;
        message = NLS.bind((String)message, (Object)EObjectLabelProviderHelper.getText((Object)role), (Object)EObjectLabelProviderHelper.getText((Object)role));
        List result = resolver.resolve((EObject)function, elements, ScenarioTransfo.getTitle(transfo), message, false, transfo, new EObject[]{function});
        if (result.size() > 0) {
            return (AbstractInstance)result.get(0);
        }
        return null;
    }

    @Override
    public List<AbstractInstance> getTargetInstances(InstanceRole role_p, IContext context_p) {
        AbstractFunction function = (AbstractFunction)role_p.getRepresentedInstance();
        AbstractInstance part = this.getRelatedPart(role_p, function, context_p.getTransfo());
        if (part != null) {
            return Collections.singletonList(part);
        }
        return Collections.emptyList();
    }
}

