/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.data.modellingcore.AbstractRelationship;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CapellaElementNamingConflictDiagram
extends AbstractValidationRule {
    private static final String TYPE_SUFFIX = ") ";
    private static final String TYPE_PREFIX = " (";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CapellaElement) {
            Session curSession;
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            boolean hasConflict = false;
            HashMap<String, List<String>> typesAndNames = new HashMap<String, List<String>>();
            CapellaElement elt = (CapellaElement)eObj;
            if (!(elt instanceof AbstractRelationship) && (curSession = SessionManager.INSTANCE.getSession((EObject)elt)) != null) {
                Collection allRepresentationDescriptors = DialectManager.INSTANCE.getRepresentationDescriptors((EObject)elt, curSession);
                for (DRepresentationDescriptor dRepresentationDescriptor : allRepresentationDescriptors) {
                    String currentElementName = dRepresentationDescriptor.getName();
                    if (dRepresentationDescriptor.getDescription() == null) continue;
                    String currentElementType = dRepresentationDescriptor.getDescription().getName();
                    hasConflict |= this.checkTheNamingConflict(ctx, statuses, typesAndNames, elt, currentElementName, currentElementType);
                }
            }
            if (hasConflict) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean checkTheNamingConflict(IValidationContext ctx, Collection<IStatus> statuses, Map<String, List<String>> typesAndNames, CapellaElement elt, String currentElementName, String currentElementType) {
        boolean hasConflict = false;
        if (!typesAndNames.containsKey(currentElementType)) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(currentElementName);
            typesAndNames.put(currentElementType, names);
        } else {
            List<String> existingNamesForTypes = typesAndNames.get(currentElementType);
            boolean alreadyExist = false;
            for (String existingName : existingNamesForTypes) {
                if (!existingName.equalsIgnoreCase(currentElementName)) continue;
                hasConflict = true;
                alreadyExist = true;
                String currentConflict = TYPE_PREFIX + currentElementType + TYPE_SUFFIX + currentElementName;
                IStatus failureStatus = this.createFailureStatus(ctx, new Object[]{elt.eClass().getName(), elt.getLabel(), currentConflict});
                statuses.add(failureStatus);
                break;
            }
            if (!alreadyExist) {
                existingNamesForTypes.add(currentElementName);
            }
        }
        return hasConflict;
    }
}

