/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ReuseLink;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.ClassExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_Union_DiscriminantType
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        ArrayList<EObject> availableElements = new ArrayList();
        boolean isElementFromSharedPkg = false;
        if (systemEngineering == null) {
            SharedPkg sharedPkg = SystemEngineeringExt.getSharedPkg((CapellaElement)element);
            for (ReuseLink link : sharedPkg.getReuseLinks()) {
                if (SystemEngineeringExt.getSystemEngineering((CapellaElement)link) == null) continue;
                systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)link);
                isElementFromSharedPkg = true;
                break;
            }
            if (systemEngineering == null) {
                return availableElements;
            }
        }
        if (element instanceof Union) {
            Union union = (Union)element;
            if (!isElementFromSharedPkg) {
                availableElements.addAll(this.getRule_MQRY_Union_Descriminant_11(union));
                availableElements.addAll(this.getRule_MQRY_Union_Descriminant_12(union));
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Union_Descriminant_11(Union currentUnion) {
        DataPkg classPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        UnionProperty disc = currentUnion.getDiscriminant();
        Type type = null;
        if (disc != null) {
            type = disc.getType();
        }
        if ((classPkg = ClassExt.getRootOwnerDataPkg((Class)currentUnion)) != null) {
            DataPkg dataPkg;
            ComponentArchitecture parentComponentArchitecture = DataPkgExt.getRootComponentArchitecture((DataPkg)classPkg);
            availableElements.addAll(this.getElementsFromComponentArchitecture(parentComponentArchitecture, type));
            Component parentComponent = DataPkgExt.getRootComponent((DataPkg)classPkg);
            if (parentComponent != null && parentComponent instanceof LogicalComponent && (dataPkg = ((LogicalComponent)parentComponent).getOwnedDataPkg()) != null) {
                for (DataType element : DataPkgExt.getAllDataTypes((DataPkg)dataPkg)) {
                    if (type != null && type.equals(element)) continue;
                    availableElements.add((CapellaElement)element);
                }
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Union_Descriminant_12(Union currentUnion) {
        DataPkg classPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        UnionProperty disc = currentUnion.getDiscriminant();
        Type type = null;
        if (disc != null) {
            type = disc.getType();
        }
        if ((classPkg = ClassExt.getRootOwnerDataPkg((Class)currentUnion)) != null) {
            for (DataPkg dataPkg : StructureExt.getDataPkgsFromParentHierarchy((Structure)classPkg)) {
                if (dataPkg == null) continue;
                for (DataType element : DataPkgExt.getAllDataTypes((DataPkg)dataPkg)) {
                    if (type != null && type.equals(element)) continue;
                    availableElements.add((CapellaElement)element);
                }
            }
        }
        availableElements.addAll(this.getRule_MQRY_Union_Descriminant_12_1(currentUnion));
        return availableElements;
    }

    private List<CapellaElement> getElementsFromComponentArchitecture(ComponentArchitecture arch, Type type) {
        DataPkg dataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null && (dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture((ComponentArchitecture)arch)) != null) {
            for (DataType element : DataPkgExt.getAllDataTypes((DataPkg)dataPkg)) {
                if (type != null && type.equals(element)) continue;
                availableElements.add((CapellaElement)element);
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Union_Descriminant_12_1(Union currentUnion) {
        DataPkg classPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        UnionProperty disc = currentUnion.getDiscriminant();
        Type type = null;
        if (disc != null) {
            type = disc.getType();
        }
        if ((classPkg = ClassExt.getRootOwnerDataPkg((Class)currentUnion)) != null) {
            SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)classPkg);
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng);
            availableElements.addAll(this.getElementsFromComponentArchitecture((ComponentArchitecture)ca, type));
            ComponentArchitecture arch = DataPkgExt.getRootComponentArchitecture((DataPkg)classPkg);
            if (arch != null) {
                if (arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                    LogicalArchitecture logArch = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)sysEng);
                    availableElements.addAll(this.getElementsFromComponentArchitecture((ComponentArchitecture)logArch, type));
                }
                if (arch instanceof EPBSArchitecture) {
                    PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)sysEng);
                    availableElements.addAll(this.getElementsFromComponentArchitecture((ComponentArchitecture)physArch, type));
                }
            }
        }
        return availableElements;
    }
}

