/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ReuseLink;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_PhysicalQuantity_Unit
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        boolean isElementFromSharedPkg = false;
        if (systemEngineering == null) {
            SharedPkg sharedPkg = SystemEngineeringExt.getSharedPkg((CapellaElement)element);
            for (ReuseLink link : sharedPkg.getReuseLinks()) {
                if (SystemEngineeringExt.getSystemEngineering((CapellaElement)link) == null) continue;
                systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)link);
                isElementFromSharedPkg = true;
                break;
            }
            if (systemEngineering == null) {
                return availableElements;
            }
        }
        if (element instanceof PhysicalQuantity) {
            PhysicalQuantity currentPhysicalDimension = (PhysicalQuantity)element;
            if (!isElementFromSharedPkg) {
                availableElements.addAll(this.getRule_MQRY_PhysicalDimension_DefaultUnit_11(currentPhysicalDimension));
                availableElements.addAll(this.getRule_MQRY_PhysicalDimension_DefaultUnit_12(currentPhysicalDimension));
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_PhysicalDimension_DefaultUnit_11(PhysicalQuantity currentPhysicalDimension) {
        DataPkg dataPkg;
        Component comp;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        EObject container = currentPhysicalDimension.eContainer();
        BlockArchitecture arch = DataPkgExt.getRootBlockArchitecture((ModelElement)currentPhysicalDimension);
        availableElements.addAll(this.getElementsFromBlockArchitecture(arch, currentPhysicalDimension.getUnit()));
        if (container instanceof DataPkg && (comp = DataPkgExt.getRootComponent((DataPkg)((DataPkg)container))) != null && (dataPkg = comp.getOwnedDataPkg()) != null) {
            for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                availableElements.add((CapellaElement)unit);
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_PhysicalDimension_DefaultUnit_12(PhysicalQuantity currentPhysicalDimension) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        EObject container = currentPhysicalDimension.eContainer();
        if (container instanceof DataPkg) {
            List dataPkgList = DataPkgExt.getDataPkgsFromParentHierarchy((DataPkg)((DataPkg)container));
            for (DataPkg dataPkg : dataPkgList) {
                if (dataPkg == null) continue;
                for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                    availableElements.add((CapellaElement)unit);
                }
            }
        }
        availableElements.addAll(this.getRule_MQRY_PhysicalDimension_DefaultUnit_12_1(currentPhysicalDimension));
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Unit link) {
        DataPkg dataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null && (dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)arch)) != null) {
            for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                availableElements.add((CapellaElement)unit);
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_PhysicalDimension_DefaultUnit_12_1(PhysicalQuantity currentPhysicalDimension) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture arch = DataPkgExt.getRootBlockArchitecture((ModelElement)currentPhysicalDimension);
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)currentPhysicalDimension);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        if (oa != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)oa, currentPhysicalDimension.getUnit()));
        } else {
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ca, currentPhysicalDimension.getUnit()));
        }
        if (arch != null) {
            if (oa != null && arch instanceof LogicalArchitecture || arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                SystemAnalysis ctxArch = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ctxArch, currentPhysicalDimension.getUnit()));
            }
            if (arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                LogicalArchitecture logArch = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)logArch, currentPhysicalDimension.getUnit()));
            }
            if (arch instanceof EPBSArchitecture) {
                PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)physArch, currentPhysicalDimension.getUnit()));
            }
        }
        return availableElements;
    }
}

