/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.capellacore;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.business.queries.BusinessQueriesPlugin;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.Messages;

public class BusinessQueriesProvider {
    private static BusinessQueriesProvider _instance = null;
    public static final String BUSINESS_QUERIES_EXTENSION_ID = "MDEBusinessQueries";
    @Deprecated
    public static final String BUSINESS_QUERIES_PLUGIN_ID = "org.polarsys.capella.core.data.business.queries";
    private List<IBusinessQuery> _businessQueriesCache = null;
    private Map<AbstractMap.SimpleEntry<EClass, EStructuralFeature>, IBusinessQuery> businessQueriesMap;

    private BusinessQueriesProvider() {
    }

    public List<IBusinessQuery> getAllContributions() {
        if (this._businessQueriesCache == null) {
            this._businessQueriesCache = new ArrayList<IBusinessQuery>();
            List<IConfigurationElement> BQProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)BUSINESS_QUERIES_PLUGIN_ID, (String)BUSINESS_QUERIES_EXTENSION_ID));
            for (IConfigurationElement configurationElement : BQProvider) {
                IBusinessQuery contrib = (IBusinessQuery)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                if (contrib == null) continue;
                this._businessQueriesCache.add(contrib);
            }
        }
        return this._businessQueriesCache;
    }

    public IBusinessQuery getContribution(EClass cls, EStructuralFeature feature) {
        return this.getAllContributionsMap().get(new AbstractMap.SimpleEntry<EClass, EStructuralFeature>(cls, feature));
    }

    public Map<AbstractMap.SimpleEntry<EClass, EStructuralFeature>, IBusinessQuery> getAllContributionsMap() {
        if (this.businessQueriesMap == null) {
            this.businessQueriesMap = new HashMap<AbstractMap.SimpleEntry<EClass, EStructuralFeature>, IBusinessQuery>();
            for (IBusinessQuery query : this.getAllContributions()) {
                if (query.getEClass() == null || query.getEStructuralFeatures() == null) continue;
                for (EStructuralFeature eStructuralFeature : query.getEStructuralFeatures()) {
                    AbstractMap.SimpleEntry<EClass, EStructuralFeature> key = new AbstractMap.SimpleEntry<EClass, EStructuralFeature>(query.getEClass(), eStructuralFeature);
                    IBusinessQuery dup = this.businessQueriesMap.get(key);
                    if (dup == null) {
                        this.businessQueriesMap.put(key, query);
                        continue;
                    }
                    ILog log = BusinessQueriesPlugin.getDefault().getLog();
                    log.log((IStatus)new Status(2, BUSINESS_QUERIES_PLUGIN_ID, NLS.bind((String)Messages.BusinessQueriesProvider_duplicateQueryContributionKey, (Object[])new Object[]{key.getKey(), key.getValue(), query.getClass().getName(), dup.getClass().getName()})));
                }
            }
        }
        return Collections.unmodifiableMap(this.businessQueriesMap);
    }

    public static BusinessQueriesProvider getInstance() {
        if (_instance == null) {
            _instance = new BusinessQueriesProvider();
        }
        return _instance;
    }
}

