/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbortExecutionException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.projection.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.projection.common.rules.IRuleTransformation;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;
import org.polarsys.capella.core.tiger.impl.TransfoRule;

public abstract class AbstractCommonRule
extends TransfoRule
implements IRuleTransformation {
    protected ITransfo _transfo;

    protected ITransfo getTransfo() {
        return this._transfo;
    }

    public AbstractCommonRule(EClass sourceType_p, EClass targetType_p) {
        super(sourceType_p, targetType_p);
    }

    public AbstractCommonRule(EClass sourceType_p, EClass targetType_p, EClass _eSpecificLinkKind_p) {
        super(sourceType_p, targetType_p, _eSpecificLinkKind_p);
    }

    public void update_(EObject element_p, ITransfo transfo_p) {
        IContext context_p = IContext.getContext(transfo_p);
        if (Query.isElementTransformed((EObject)element_p, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            for (EObject result : this.retrieveTracedElements(element_p, context_p)) {
                if (!this.isValidTargetElement(element_p, result, context_p)) continue;
                this.updateElement(element_p, result, context_p);
            }
        }
        TigerRelationshipHelper.updateElementByProperty((EObject)element_p, (List)this._updatedAttributes, (ITransfo)transfo_p);
    }

    public String getDescription() {
        return String.valueOf(super.getDescription()) + __br + " - Required parameter: " + "transfoSource" + __br + " - The target " + this.getTargetType().getName() + " is named with the source name";
    }

    public List<EObject> retrieveRelatedElements_(EObject source_p, ITransfo transfo_p) {
        this._transfo = transfo_p;
        ArrayList<EObject> result = new ArrayList<EObject>(0);
        IContext context_p = IContext.getContext(transfo_p);
        this.retrieveCurrent(source_p, result, context_p);
        this.retrieveContainer(source_p, result, context_p);
        this.retrieveGoDeep(source_p, result, context_p);
        ArrayList<EObject> affectedMessages = new ArrayList<EObject>();
        affectedMessages.add(source_p);
        affectedMessages.addAll(result);
        this.notifyMessage(NLS.bind((String)ProjectionMessages.RetrieveElement, (Object)EObjectLabelProviderHelper.getText((Object)source_p), (Object)EObjectLabelProviderHelper.getText(result)), affectedMessages, "DEBUG", transfo_p);
        if (result.contains(null)) {
            this.notifyMessage(NLS.bind((String)ProjectionMessages.RetrieveElementNullElement, (Object)EObjectLabelProviderHelper.getText((Object)source_p)), affectedMessages, "DEBUG", transfo_p);
            while (result.contains(null)) {
                result.remove(null);
            }
        }
        return result;
    }

    protected void retrieveCurrent(EObject source_p, List<EObject> result_p, IContext context_p) {
        result_p.add(source_p);
    }

    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
    }

    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
        EObject container = element_p.eContainer();
        if (container != null && !Query.isElementTransformed((EObject)element_p, (ITransfo)this._transfo)) {
            result_p.add(container);
        }
    }

    protected List<EObject> retrieveTracedElements(EObject source_p, IContext context_p) {
        return TraceabilityHandlerHelper.getInstance(context_p).retrieveTracedElements(source_p, context_p);
    }

    protected boolean isValidTargetElement(EObject element_p, EObject result_p, IContext context_p) {
        return result_p != null;
    }

    protected void updateElement(EObject element_p, EObject result_p, IContext context_p) {
    }

    protected boolean isContainementAttached(EObject element_p, EObject result_p, IContext context_p) {
        return result_p.eContainer() != null;
    }

    protected EObject getBestContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject bestContainer = null;
        EObject container = this.getSourceContainer(element_p, result_p, context_p);
        if (container != null) {
            bestContainer = TransformationHandlerHelper.getInstance(context_p).getBestTracedElement(container, context_p, TransformationHandlerHelper.getInstance(context_p).getTargetType(container, context_p));
        }
        return bestContainer;
    }

    protected EObject getSourceContainer(EObject element_p, EObject result_p, IContext context_p) {
        return element_p.eContainer();
    }

    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        return null;
    }

    protected EStructuralFeature getSourceContainementFeature(EObject element_p, EObject result_p, IContext context_p) {
        return element_p.eContainingFeature();
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container, IContext context_p) {
        return element_p.eContainingFeature();
    }

    protected void attachContainement(EObject element_p, EObject result_p, IContext context_p) {
        EObject container = this.getBestContainer(element_p, result_p, context_p);
        if (container == null) {
            container = this.getDefaultContainer(element_p, result_p, context_p);
        }
        EStructuralFeature feature = this.getTargetContainementFeature(element_p, result_p, container, context_p);
        IReadOnlySectionHandler roHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        if (roHandler != null && roHandler.isLockedByOthers(container)) {
            throw new AbortExecutionException("the container may be read only. Please check that you are allowed to edit " + EObjectExt.getText((EObject)container) + ".");
        }
        if (container != null && AttachmentHelper.getInstance(context_p).isApplicable(container.eClass(), feature)) {
            AttachmentHelper.getInstance(context_p).attachElementByRel(container, result_p, (EReference)feature);
        }
    }

    protected void attachRelated(EObject element_p, EObject result_p, IContext context_p) {
        IReadOnlySectionHandler roHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        if (roHandler != null && roHandler.isLockedByOthers(result_p)) {
            throw new AbortExecutionException("the related element may be read only. Please check that you are allowed to edit " + EObjectExt.getText((EObject)result_p) + ".");
        }
    }

    protected boolean isFirstAttach(EObject element_p, EObject result_p, IContext context_p) {
        return ((Collection)context_p.get("transformedElements")).contains(result_p);
    }

    protected boolean isRelatedAttached(EObject element_p, EObject result_p, IContext context_p) {
        return false;
    }

    public void attach_(EObject element_p, ITransfo transfo_p) throws TransfoException {
        IContext context_p = IContext.getContext(transfo_p);
        if (Query.isElementTransformed((EObject)element_p, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            this.runSubTransition(element_p, transfo_p);
            for (EObject result : this.retrieveTracedElements(element_p, context_p)) {
                if (!this.isValidTargetElement(element_p, result, context_p)) continue;
                this.updateElement(element_p, result, context_p);
                if (!this.isContainementAttached(element_p, result, context_p)) {
                    this.attachContainement(element_p, result, context_p);
                }
                if (this.isRelatedAttached(element_p, result, context_p)) continue;
                this.attachRelated(element_p, result, context_p);
            }
        }
    }

    protected void runSubTransition(EObject element_p, ITransfo transfo_p) {
    }

    protected void runSubTransitionBeforeTransform(EObject element_p, ITransfo transfo_p) {
    }

    protected Collection<EObject> transformElement(EObject element_p, IContext context_p) {
        EObject transitioned = this.transformDirectElement(element_p, context_p);
        return Collections.singleton(transitioned);
    }

    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        EClass targetType = this.getTargetType();
        if (targetType != null && !targetType.isAbstract()) {
            EPackage pkg = (EPackage)targetType.eContainer();
            return pkg.getEFactoryInstance().create(targetType);
        }
        return null;
    }

    protected Resource getHoldingResource(ITransfo transfo_p) {
        if (!transfo_p.containsKey((Object)"HOLDING_RESOURCE")) {
            EObject transfoSource = (EObject)this._transfo.get((Object)"transfoSource");
            transfo_p.put((Object)"HOLDING_RESOURCE", (Object)HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)transfoSource)));
        }
        return (Resource)transfo_p.get((Object)"HOLDING_RESOURCE");
    }

    public final Object transform_(EObject element_p, ITransfo transfo_p) {
        IContext context_p = IContext.getContext(transfo_p);
        this.runSubTransitionBeforeTransform(element_p, transfo_p);
        IStatus transformRequired = this.transformRequired(element_p, context_p);
        if (transformRequired.isOK()) {
            Collection<EObject> result = this.transformElement(element_p, context_p);
            Iterator<EObject> iterator = result.iterator();
            while (iterator.hasNext()) {
                EObject res;
                EObject transformed = res = iterator.next();
                if (res.eResource() == null) {
                    HoldingResourceHelper.attachToHoldingResource((EObject)res, (Resource)this.getHoldingResource(this._transfo));
                }
                String sourceText = EObjectLabelProviderHelper.getText((Object)element_p);
                String targetText = EObjectLabelProviderHelper.getText((Object)transformed);
                String targetName = CapellaElementExt.getName((EObject)transformed);
                String sourceEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)element_p, (boolean)true);
                String targetEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)transformed, (boolean)true);
                if ((targetName == null || targetName.length() == 0) && res instanceof AbstractNamedElement) {
                    targetText = sourceText;
                }
                this.notifyMessage(NLS.bind((String)ProjectionMessages.ElementTransitioned, (Object[])new Object[]{sourceText, sourceEClassName, targetText, targetEClassName}), new Object[]{element_p, transformed}, "INFO", transfo_p);
            }
            return result;
        }
        String reason = transformRequired.getMessage();
        String sourceEClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)element_p, (boolean)true);
        this.notifyMessage(String.valueOf(NLS.bind((String)ProjectionMessages.ElementNotTransitioned, (Object)EObjectLabelProviderHelper.getText((Object)element_p), (Object)sourceEClassName)) + (reason == null || reason.length() == 0 ? "" : reason), element_p, "WARN", transfo_p);
        return null;
    }

    @Override
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        return Status.OK_STATUS;
    }

    protected void notifyMessage(String message, Object affectedObject, String priority, ITransfo transfo_p) {
        LogHelper.getInstance().log(message, priority, affectedObject, this.getClass().getSimpleName());
    }

    protected boolean isOrWillBeTransformed(EObject element_p, ITransfo transfo_p) {
        IContext context = IContext.getContext(transfo_p);
        return TransformationHandlerHelper.getInstance(context).isOrWillBeTransformed(element_p, context).isOK();
    }
}

